/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonassert;

import com.jayway.jsonassert.JsonAsserter;
import com.jayway.jsonassert.impl.JsonAsserterImpl;
import com.jayway.jsonassert.impl.matcher.CollectionMatcher;
import com.jayway.jsonassert.impl.matcher.IsCollectionWithSize;
import com.jayway.jsonassert.impl.matcher.IsEmptyCollection;
import com.jayway.jsonassert.impl.matcher.IsMapContainingKey;
import com.jayway.jsonassert.impl.matcher.IsMapContainingValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonAssert {
    private static JSONParser JSON_PARSER = new JSONParser();
    public static final int STRICT_MODE = 0;
    public static final int SLACK_MODE = -1;
    private static int mode = -1;

    public static void setMode(int mode) {
        if (mode != JsonAssert.mode) {
            JsonAssert.mode = mode;
            JSON_PARSER = new JSONParser(JsonAssert.mode);
        }
    }

    public static int getMode() {
        return mode;
    }

    public static JsonAsserter with(String json) throws java.text.ParseException {
        try {
            return new JsonAsserterImpl(JSON_PARSER.parse(json));
        }
        catch (ParseException e) {
            throw new java.text.ParseException(json, e.getPosition());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonAsserter with(Reader reader) throws java.text.ParseException, IOException {
        try {
            return new JsonAsserterImpl(JSON_PARSER.parse(JsonAssert.convertReaderToString(reader)));
        }
        catch (ParseException e) {
            throw new java.text.ParseException(e.toString(), e.getPosition());
        }
    }

    public static JsonAsserter with(InputStream is) throws java.text.ParseException, IOException {
        InputStreamReader reader = new InputStreamReader(is);
        return JsonAssert.with(reader);
    }

    public static CollectionMatcher collectionWithSize(Matcher<? super Integer> sizeMatcher) {
        return new IsCollectionWithSize(sizeMatcher);
    }

    public static Matcher<Map<String, ?>> mapContainingKey(Matcher<String> keyMatcher) {
        return new IsMapContainingKey<String>(keyMatcher);
    }

    public static <V> Matcher<? super Map<?, V>> mapContainingValue(Matcher<? super V> valueMatcher) {
        return new IsMapContainingValue<V>(valueMatcher);
    }

    public static Matcher<Collection<Object>> emptyCollection() {
        return new IsEmptyCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertReaderToString(Reader reader) throws IOException {
        if (reader != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                reader.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }
}

