/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonassert.impl;

import com.jayway.jsonassert.JsonAsserter;
import com.jayway.jsonpath.JsonPath;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonAsserterImpl
implements JsonAsserter {
    private final Object jsonObject;

    public JsonAsserterImpl(Object jsonObject) {
        this.jsonObject = jsonObject;
    }

    @Override
    public <T> JsonAsserter assertThat(String path, Matcher<T> matcher) {
        Object obj = JsonPath.read((Object)this.jsonObject, (String)path);
        if (!matcher.matches(obj)) {
            throw new AssertionError((Object)String.format("JSON doesn't match.\nExpected:\n%s\nActual:\n%s", matcher.toString(), obj));
        }
        return this;
    }

    @Override
    public <T> JsonAsserter assertEquals(String path, T expected) {
        return this.assertThat(path, Matchers.equalTo(expected));
    }

    @Override
    public JsonAsserter assertNotDefined(String path) {
        Object o = JsonPath.read((Object)this.jsonObject, (String)path);
        if (o != null) {
            throw new AssertionError((Object)String.format("Document contains the path <%s> but was expected not to.", path));
        }
        return this;
    }

    @Override
    public JsonAsserter assertNull(String path) {
        return this.assertThat(path, Matchers.nullValue());
    }

    @Override
    public <T> JsonAsserter assertNotNull(String path) {
        return this.assertThat(path, Matchers.notNullValue());
    }

    @Override
    public JsonAsserter and() {
        return this;
    }
}

