/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.filter;

import com.jayway.jsonpath.filter.JsonPathFilterBase;
import com.jayway.jsonpath.filter.ListFilter;
import com.jayway.jsonpath.filter.PropertyFilter;
import com.jayway.jsonpath.filter.RootFilter;
import com.jayway.jsonpath.filter.TraverseFilter;
import java.util.regex.Pattern;

public class JsonPathFilterFactory {
    private static final Pattern ROOT_FILTER_PATTERN = Pattern.compile("\\$");
    private static final Pattern PROPERTY_FILTER_PATTERN = Pattern.compile("(.*)|\\['(.*?)'\\]");
    private static final Pattern WILDCARD_PROPERTY_FILTER_PATTERN = Pattern.compile("\\*");
    private static final Pattern LIST_FILTER_PATTERN = Pattern.compile("\\[.*?\\]");
    private static final Pattern TRAVERSE_FILTER_PATTERN = Pattern.compile("\\.\\.");
    private static final RootFilter ROOT_FILTER = new RootFilter();
    private static final TraverseFilter TRAVERSE_FILTER = new TraverseFilter();

    public static JsonPathFilterBase createFilter(String pathFragment) {
        if (ROOT_FILTER_PATTERN.matcher(pathFragment).matches()) {
            return ROOT_FILTER;
        }
        if (LIST_FILTER_PATTERN.matcher(pathFragment).matches()) {
            return new ListFilter(pathFragment);
        }
        if (TRAVERSE_FILTER_PATTERN.matcher(pathFragment).matches()) {
            return TRAVERSE_FILTER;
        }
        if (PROPERTY_FILTER_PATTERN.matcher(pathFragment).matches() || WILDCARD_PROPERTY_FILTER_PATTERN.matcher(pathFragment).matches()) {
            return new PropertyFilter(pathFragment);
        }
        return null;
    }
}

