/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.filter;

import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.filter.FilterOutput;
import com.jayway.jsonpath.filter.JsonPathFilterBase;
import com.jayway.jsonpath.filter.JsonPathFilterFactory;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonPathFilterChain {
    private List<JsonPathFilterBase> filters;

    public JsonPathFilterChain(List<String> pathFragments) {
        this.filters = this.configureFilters(pathFragments);
    }

    private List<JsonPathFilterBase> configureFilters(List<String> pathFragments) {
        LinkedList<JsonPathFilterBase> configured = new LinkedList<JsonPathFilterBase>();
        for (String pathFragment : pathFragments) {
            configured.add(JsonPathFilterFactory.createFilter(pathFragment));
        }
        return configured;
    }

    public FilterOutput filter(Object root) {
        FilterOutput out = new FilterOutput(root);
        for (JsonPathFilterBase filter : this.filters) {
            if (filter == null) {
                throw new InvalidPathException();
            }
            if (out.getResult() == null) {
                return null;
            }
            out = filter.apply(out);
        }
        return out;
    }
}

