/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.filter;

import com.jayway.jsonpath.filter.FilterOutput;
import com.jayway.jsonpath.filter.JsonPathFilterBase;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.simple.JSONArray;

public class ListFrontFilter
extends JsonPathFilterBase {
    public static final Pattern PATTERN = Pattern.compile("\\[\\s?:(\\d+)\\s?\\]");
    private final String pathFragment;

    public ListFrontFilter(String pathFragment) {
        this.pathFragment = pathFragment;
    }

    public FilterOutput apply(FilterOutput filterItems) {
        Integer[] index;
        JSONArray result = new JSONArray();
        Integer[] arr$ = index = this.getListPullIndex();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int i = arr$[i$];
            if (!this.indexIsInRange(filterItems.getResultAsList(), i)) continue;
            result.add(filterItems.getResultAsList().get(i));
        }
        return new FilterOutput(result);
    }

    private Integer[] getListPullIndex() {
        Matcher matcher = PATTERN.matcher(this.pathFragment);
        if (matcher.matches()) {
            int pullCount = Integer.parseInt(matcher.group(1));
            LinkedList<Integer> result = new LinkedList<Integer>();
            for (int y = 0; y < pullCount; ++y) {
                result.add(y);
            }
            return result.toArray(new Integer[0]);
        }
        throw new IllegalArgumentException("invalid list index");
    }

    private boolean indexIsInRange(List list, int index) {
        if (index < 0) {
            return false;
        }
        return index <= list.size() - 1;
    }
}

