/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.filter;

import com.jayway.jsonpath.filter.FilterOutput;
import com.jayway.jsonpath.filter.JsonPathFilterBase;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.json.simple.JSONArray;

public class ListIndexFilter
extends JsonPathFilterBase {
    public static final Pattern PATTERN = Pattern.compile("\\[(\\s?\\d+\\s?,?)+\\]");
    private final String pathFragment;

    public ListIndexFilter(String pathFragment) {
        this.pathFragment = pathFragment;
    }

    public FilterOutput apply(FilterOutput filterItems) {
        Object result = null;
        Integer[] index = this.getArrayIndex();
        if (index.length > 1) {
            JSONArray tmp = new JSONArray();
            Integer[] arr$ = index;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int i = arr$[i$];
                if (!this.indexIsInRange(filterItems.getResultAsList(), i)) continue;
                tmp.add(filterItems.getResultAsList().get(i));
            }
            result = tmp;
        } else if (this.indexIsInRange(filterItems.getResultAsList(), index[0])) {
            result = filterItems.getResultAsList().get(index[0]);
        }
        return new FilterOutput(result);
    }

    private boolean indexIsInRange(List list, int index) {
        if (index < 0) {
            return false;
        }
        return index <= list.size() - 1;
    }

    private Integer[] getArrayIndex() {
        String[] split;
        String prepared = this.pathFragment.replaceAll(" ", "");
        prepared = prepared.substring(1, prepared.length() - 1);
        LinkedList<Integer> index = new LinkedList<Integer>();
        for (String s : split = prepared.split(",")) {
            index.add(Integer.parseInt(s));
        }
        return index.toArray(new Integer[0]);
    }
}

