/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath;

import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.PathUtil;
import com.jayway.jsonpath.filter.FilterOutput;
import com.jayway.jsonpath.filter.JsonPathFilterChain;
import java.io.IOException;
import java.util.logging.Logger;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonPath {
    public static final int STRICT_MODE = 0;
    public static final int SLACK_MODE = -1;
    private static int mode = -1;
    private static final Logger log = Logger.getLogger(JsonPath.class.getName());
    private static JSONParser JSON_PARSER = new JSONParser(mode);
    private JsonPathFilterChain filters;

    public static void setMode(int mode) {
        if (mode != JsonPath.mode) {
            JsonPath.mode = mode;
            JSON_PARSER = new JSONParser(JsonPath.mode);
        }
    }

    public static int getMode() {
        return mode;
    }

    private JsonPath(String jsonPath) {
        if (jsonPath == null || jsonPath.trim().isEmpty() || jsonPath.matches("new ") || jsonPath.matches("[^\\?\\+\\=\\-\\*\\/\\!]\\(")) {
            throw new InvalidPathException("Invalid path");
        }
        this.filters = new JsonPathFilterChain(PathUtil.splitPath(jsonPath));
    }

    public <T> T read(Object json) {
        FilterOutput filterOutput = this.filters.filter(json);
        if (filterOutput == null || filterOutput.getResult() == null) {
            return null;
        }
        return (T)filterOutput.getResult();
    }

    public <T> T read(String json) throws java.text.ParseException {
        return this.read(JsonPath.parse(json));
    }

    public static JsonPath compile(String jsonPath) {
        return new JsonPath(jsonPath);
    }

    public static <T> T read(String json, String jsonPath) throws java.text.ParseException {
        return JsonPath.compile(jsonPath).read(json);
    }

    public static <T> T read(Object json, String jsonPath) {
        return JsonPath.compile(jsonPath).read(json);
    }

    private static Object parse(String json) throws java.text.ParseException {
        try {
            return JSON_PARSER.parse(json);
        }
        catch (ParseException e) {
            throw new java.text.ParseException(json, e.getPosition());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

