/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal;

import com.jayway.jsonpath.Criteria;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.Cache;
import com.jayway.jsonpath.internal.CompiledPath;
import com.jayway.jsonpath.internal.Path;
import com.jayway.jsonpath.internal.Utils;
import com.jayway.jsonpath.internal.token.ArrayPathToken;
import com.jayway.jsonpath.internal.token.PathToken;
import com.jayway.jsonpath.internal.token.PredicatePathToken;
import com.jayway.jsonpath.internal.token.PropertyPathToken;
import com.jayway.jsonpath.internal.token.RootPathToken;
import com.jayway.jsonpath.internal.token.ScanPathToken;
import com.jayway.jsonpath.internal.token.WildcardPathToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathCompiler {
    private static final Logger logger = LoggerFactory.getLogger(PathCompiler.class);
    private static final String PROPERTY_OPEN = "['";
    private static final String PROPERTY_CLOSE = "']";
    private static final char DOCUMENT = '$';
    private static final char ANY = '*';
    private static final char PERIOD = '.';
    private static final char BRACKET_OPEN = '[';
    private static final char BRACKET_CLOSE = ']';
    private static final char SPACE = ' ';
    private static final Cache cache = new Cache(200);
    private static final String[] OPERATORS = new String[]{"==", ">=", "<=", "!=", "<", ">"};

    public static Path compile(String path, Predicate ... filters) {
        boolean isRootPath;
        Utils.notEmpty(path, "Path may not be null empty", new Object[0]);
        path = path.trim();
        LinkedList<Predicate> filterList = new LinkedList<Predicate>(Arrays.asList(filters));
        if (path.charAt(0) != '$' && path.charAt(0) != '@') {
            path = "$." + path;
        }
        boolean bl = isRootPath = path.charAt(0) == '$';
        if (path.charAt(0) == '@') {
            path = "$" + path.substring(1);
        }
        if (path.length() > 1 && path.charAt(1) != '.' && path.charAt(1) != '[') {
            throw new InvalidPathException("Invalid path " + path);
        }
        String cacheKey = path + isRootPath + filterList.toString();
        Path p = cache.get(cacheKey);
        if (p != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Using cached path");
            }
            return p;
        }
        RootPathToken root = null;
        int i = 0;
        String fragment = "";
        block7: do {
            char current = path.charAt(i);
            switch (current) {
                case ' ': {
                    throw new InvalidPathException("Space not allowed in path");
                }
                case '$': {
                    fragment = "$";
                    ++i;
                    break;
                }
                case '[': {
                    int positions = PathCompiler.fastForwardUntilClosed(path, i);
                    fragment = path.substring(i, i + positions);
                    i += positions;
                    break;
                }
                case '.': {
                    if (path.charAt(++i) == '.') {
                        fragment = "..";
                        ++i;
                        break;
                    }
                    int positions = PathCompiler.fastForward(path, i);
                    if (positions == 0) continue block7;
                    if (positions == 1 && path.charAt(i) == '*') {
                        fragment = new String("[*]");
                    } else {
                        PathCompiler.assertValidFieldChars(path, i, positions);
                        fragment = PROPERTY_OPEN + path.substring(i, i + positions) + PROPERTY_CLOSE;
                    }
                    i += positions;
                    break;
                }
                case '*': {
                    fragment = new String("[*]");
                    ++i;
                    break;
                }
                default: {
                    int positions = PathCompiler.fastForward(path, i);
                    fragment = PROPERTY_OPEN + path.substring(i, i + positions) + PROPERTY_CLOSE;
                    i += positions;
                }
            }
            if (root == null) {
                root = (RootPathToken)PathComponentAnalyzer.analyze(fragment, filterList);
                continue;
            }
            root.append(PathComponentAnalyzer.analyze(fragment, filterList));
        } while (i < path.length());
        CompiledPath pa = new CompiledPath(root, isRootPath);
        cache.put(cacheKey, pa);
        return pa;
    }

    private static void assertValidFieldChars(String s, int start, int positions) {
    }

    private static int fastForward(String s, int index) {
        char current;
        int skipCount = 0;
        while (index < s.length() && (current = s.charAt(index)) != '.' && current != '[' && current != ' ') {
            ++index;
            ++skipCount;
        }
        return skipCount;
    }

    private static int fastForwardUntilClosed(String s, int index) {
        int skipCount = 0;
        int nestedBrackets = 0;
        ++index;
        ++skipCount;
        while (index < s.length()) {
            char current = s.charAt(index);
            ++index;
            ++skipCount;
            if (current == ']' && nestedBrackets == 0) break;
            if (current == '[') {
                ++nestedBrackets;
            }
            if (current != ']') continue;
            --nestedBrackets;
        }
        return skipCount;
    }

    static class PathComponentAnalyzer {
        private static final Pattern FILTER_PATTERN = Pattern.compile("^\\[\\s*\\?\\s*[,\\s*\\?]*?\\s*]$");
        private int i;
        private char current;
        private final LinkedList<Predicate> filterList;
        private final String pathFragment;

        PathComponentAnalyzer(String pathFragment, LinkedList<Predicate> filterList) {
            this.pathFragment = pathFragment;
            this.filterList = filterList;
        }

        static PathToken analyze(String pathFragment, LinkedList<Predicate> filterList) {
            return new PathComponentAnalyzer(pathFragment, filterList).analyze();
        }

        public PathToken analyze() {
            if ("$".equals(this.pathFragment)) {
                return new RootPathToken();
            }
            if ("..".equals(this.pathFragment)) {
                return new ScanPathToken();
            }
            if ("[*]".equals(this.pathFragment)) {
                return new WildcardPathToken();
            }
            if (".*".equals(this.pathFragment)) {
                return new WildcardPathToken();
            }
            if ("[?]".equals(this.pathFragment)) {
                return new PredicatePathToken(this.filterList.poll());
            }
            if (FILTER_PATTERN.matcher(this.pathFragment).matches()) {
                int criteriaCount = Utils.countMatches(this.pathFragment, "?");
                ArrayList<Predicate> filters = new ArrayList<Predicate>(criteriaCount);
                for (int i = 0; i < criteriaCount; ++i) {
                    filters.add(this.filterList.poll());
                }
                return new PredicatePathToken(filters);
            }
            this.i = 0;
            do {
                this.current = this.pathFragment.charAt(this.i);
                switch (this.current) {
                    case '?': {
                        return this.analyzeCriteriaSequence2();
                    }
                    case '\'': {
                        return this.analyzeProperty();
                    }
                }
                if (Character.isDigit(this.current) || this.current == ':' || this.current == '-' || this.current == '@') {
                    return this.analyzeArraySequence();
                }
                ++this.i;
            } while (this.i < this.pathFragment.length());
            throw new InvalidPathException("Could not analyze path component: " + this.pathFragment);
        }

        private int findNext(char charToFind, boolean disregardStringContent) {
            int x = this.i;
            boolean inProperty = false;
            boolean found = false;
            while (!found) {
                char analyzing = this.pathFragment.charAt(x);
                if (analyzing == '\'' && disregardStringContent) {
                    boolean bl = inProperty = !inProperty;
                }
                if (!inProperty) {
                    found = analyzing == charToFind;
                }
                ++x;
            }
            return x - 1;
        }

        private PathToken analyzeCriteriaSequence2() {
            String[] split;
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            int startPos = this.findNext('(', true) + 1;
            int stopPos = this.findNext(')', true);
            for (String criteria : split = this.pathFragment.substring(startPos, stopPos).split("&&")) {
                int operatorIndex = -1;
                String left = "";
                String operator = "";
                String right = "";
                for (int y = 0; y < OPERATORS.length; ++y) {
                    operatorIndex = criteria.indexOf(OPERATORS[y]);
                    if (operatorIndex == -1) continue;
                    operator = OPERATORS[y];
                    break;
                }
                if (!operator.isEmpty()) {
                    left = criteria.substring(0, operatorIndex).trim();
                    right = criteria.substring(operatorIndex + operator.length()).trim();
                } else {
                    left = criteria.trim();
                }
                predicates.add(Criteria.create(left, operator, right));
            }
            this.i = stopPos;
            return new PredicatePathToken(Filter.filter(predicates));
        }

        private static boolean isAnd(char c) {
            return c == '&';
        }

        private static boolean isOr(char c) {
            if (c == '|') {
                throw new UnsupportedOperationException("OR operator is not supported.");
            }
            return false;
        }

        private static boolean isLogicOperatorChar(char c) {
            return PathComponentAnalyzer.isAnd(c) || PathComponentAnalyzer.isOr(c);
        }

        private static boolean isOperatorChar(char c) {
            return c == '=' || c == '!' || c == '<' || c == '>';
        }

        private PathToken analyzeProperty() {
            ArrayList<String> properties = new ArrayList<String>();
            StringBuilder buffer = new StringBuilder();
            boolean propertyIsOpen = false;
            while (this.current != ']') {
                switch (this.current) {
                    case '\'': {
                        if (propertyIsOpen) {
                            properties.add(buffer.toString());
                            buffer.setLength(0);
                            propertyIsOpen = false;
                            break;
                        }
                        propertyIsOpen = true;
                        break;
                    }
                    default: {
                        if (!propertyIsOpen) break;
                        buffer.append(this.current);
                    }
                }
                this.current = this.pathFragment.charAt(++this.i);
            }
            return new PropertyPathToken(properties);
        }

        private PathToken analyzeArraySequence() {
            StringBuilder buffer = new StringBuilder();
            ArrayList<Integer> numbers = new ArrayList<Integer>();
            boolean contextSize = this.current == '@';
            boolean sliceTo = false;
            boolean sliceFrom = false;
            boolean sliceBetween = false;
            boolean indexSequence = false;
            boolean singleIndex = false;
            if (contextSize) {
                this.current = this.pathFragment.charAt(++this.i);
                this.current = this.pathFragment.charAt(++this.i);
                while (this.current != '-') {
                    if (this.current == ' ' || this.current == '(' || this.current == ')') {
                        this.current = this.pathFragment.charAt(++this.i);
                        continue;
                    }
                    buffer.append(this.current);
                    this.current = this.pathFragment.charAt(++this.i);
                }
                String function = buffer.toString();
                buffer.setLength(0);
                if (!function.equals("size") && !function.equals("length")) {
                    throw new InvalidPathException("Invalid function: @." + function + ". Supported functions are: [(@.length - n)] and [(@.size() - n)]");
                }
                while (this.current != ')') {
                    if (this.current == ' ') {
                        this.current = this.pathFragment.charAt(++this.i);
                        continue;
                    }
                    buffer.append(this.current);
                    this.current = this.pathFragment.charAt(++this.i);
                }
            } else {
                while (Character.isDigit(this.current) || this.current == ',' || this.current == ' ' || this.current == ':' || this.current == '-') {
                    switch (this.current) {
                        case ' ': {
                            break;
                        }
                        case ':': {
                            if (buffer.length() == 0) {
                                sliceTo = true;
                                this.current = this.pathFragment.charAt(++this.i);
                                while (Character.isDigit(this.current) || this.current == ' ' || this.current == '-') {
                                    if (this.current != ' ') {
                                        buffer.append(this.current);
                                    }
                                    this.current = this.pathFragment.charAt(++this.i);
                                }
                                numbers.add(Integer.parseInt(buffer.toString()));
                                buffer.setLength(0);
                                break;
                            }
                            numbers.add(Integer.parseInt(buffer.toString()));
                            buffer.setLength(0);
                            this.current = this.pathFragment.charAt(++this.i);
                            while (Character.isDigit(this.current) || this.current == ' ' || this.current == '-') {
                                if (this.current != ' ') {
                                    buffer.append(this.current);
                                }
                                this.current = this.pathFragment.charAt(++this.i);
                            }
                            if (buffer.length() == 0) {
                                sliceFrom = true;
                                break;
                            }
                            sliceBetween = true;
                            numbers.add(Integer.parseInt(buffer.toString()));
                            buffer.setLength(0);
                            break;
                        }
                        case ',': {
                            numbers.add(Integer.parseInt(buffer.toString()));
                            buffer.setLength(0);
                            indexSequence = true;
                            break;
                        }
                        default: {
                            buffer.append(this.current);
                        }
                    }
                    if (this.current != ']') {
                        this.current = this.pathFragment.charAt(++this.i);
                        continue;
                    }
                    break;
                }
            }
            if (buffer.length() > 0) {
                numbers.add(Integer.parseInt(buffer.toString()));
            }
            boolean bl = singleIndex = numbers.size() == 1 && !sliceTo && !sliceFrom && !contextSize;
            if (logger.isTraceEnabled()) {
                logger.debug("numbers are                : {}", (Object)((Object)numbers).toString());
                logger.debug("sequence is singleNumber   : {}", (Object)singleIndex);
                logger.debug("sequence is numberSequence : {}", (Object)indexSequence);
                logger.debug("sequence is sliceFrom      : {}", (Object)sliceFrom);
                logger.debug("sequence is sliceTo        : {}", (Object)sliceTo);
                logger.debug("sequence is sliceBetween   : {}", (Object)sliceBetween);
                logger.debug("sequence is contextFetch   : {}", (Object)contextSize);
                logger.debug("---------------------------------------------");
            }
            ArrayPathToken.Operation operation = null;
            if (singleIndex) {
                operation = ArrayPathToken.Operation.SINGLE_INDEX;
            } else if (indexSequence) {
                operation = ArrayPathToken.Operation.INDEX_SEQUENCE;
            } else if (sliceFrom) {
                operation = ArrayPathToken.Operation.SLICE_FROM;
            } else if (sliceTo) {
                operation = ArrayPathToken.Operation.SLICE_TO;
            } else if (sliceBetween) {
                operation = ArrayPathToken.Operation.SLICE_BETWEEN;
            } else if (contextSize) {
                operation = ArrayPathToken.Operation.CONTEXT_SIZE;
            }
            assert (operation != null);
            return new ArrayPathToken(numbers, operation);
        }
    }
}

