/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.spi.json;

import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.internal.spi.json.AbstractJsonProvider;
import com.jayway.jsonpath.spi.json.Mode;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.mapper.AMapper;
import net.minidev.json.mapper.DefaultMapperOrdered;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;

public class JsonSmartJsonProvider
extends AbstractJsonProvider {
    private final Mode mode;
    private static final AMapper<?> orderedMapper = DefaultMapperOrdered.DEFAULT;

    public JsonSmartJsonProvider() {
        this(Mode.SLACK);
    }

    public JsonSmartJsonProvider(Mode mode) {
        this.mode = mode;
    }

    @Override
    public Object createArray() {
        return orderedMapper.createArray();
    }

    @Override
    public Object createMap() {
        return orderedMapper.createObject();
    }

    @Override
    public Object parse(String json) {
        try {
            return this.createParser().parse(json, orderedMapper);
        }
        catch (ParseException e) {
            throw new InvalidJsonException(e);
        }
    }

    @Override
    public Object parse(InputStream jsonStream, String charset) throws InvalidJsonException {
        try {
            return this.createParser().parse((Reader)new InputStreamReader(jsonStream, charset), orderedMapper);
        }
        catch (ParseException e) {
            throw new InvalidJsonException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new JsonPathException(e);
        }
    }

    @Override
    public String toJson(Object obj) {
        if (obj instanceof Map) {
            return JSONObject.toJSONString((Map)((Map)obj));
        }
        if (obj instanceof List) {
            return JSONArray.toJSONString((List)((List)obj));
        }
        throw new UnsupportedOperationException(obj.getClass().getName() + " can not be converted to JSON");
    }

    private JSONParser createParser() {
        return new JSONParser(this.mode.intValue());
    }
}

