/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.spi.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.internal.spi.mapper.Mapper;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.HashMap;

public class JacksonMappingProvider
implements MappingProvider {
    private final ObjectMapper objectMapper;
    private HashMap<Class<?>, HashMap<Class<?>, Mapper>> converters = new HashMap();

    public JacksonMappingProvider() {
        this(new ObjectMapper());
    }

    public JacksonMappingProvider(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void addMapper(Mapper converter) {
        for (Mapper.ConvertiblePair convertible : converter.getConvertibleTypes()) {
            if (!this.converters.containsKey(convertible.getTargetType())) {
                this.converters.put(convertible.getTargetType(), new HashMap());
            }
            this.converters.get(convertible.getTargetType()).put(convertible.getSourceType(), converter);
        }
    }

    @Override
    public <T> T map(Object source, Class<T> targetType, Configuration configuration) {
        Mapper mapper;
        if (source == null) {
            return null;
        }
        HashMap<Class<?>, Mapper> targetConverters = this.converters.get(targetType);
        if (targetConverters != null && (mapper = targetConverters.get(source.getClass())) != null) {
            return (T)mapper.convert(source, source.getClass(), targetType, configuration);
        }
        return (T)this.objectMapper.convertValue(source, targetType);
    }
}

