/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android;

import com.jayway.maven.plugins.android.InvalidNdkException;
import java.io.File;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.plugin.MojoExecutionException;

public class AndroidNdk {
    public static final String PROPER_NDK_HOME_DIRECTORY_MESSAGE = "Please provide a proper Android NDK directory path as configuration parameter <ndk><path>...</path></ndk> in the plugin <configuration/>. As an alternative, you may add the parameter to commandline: -Dandroid.ndk.path=... or set environment variable ANDROID_NDK_HOME.";
    private final File ndkPath;

    public AndroidNdk(File ndkPath) {
        this.assertPathIsDirectory(ndkPath);
        this.ndkPath = ndkPath;
    }

    private void assertPathIsDirectory(File path) {
        if (path == null) {
            throw new InvalidNdkException(PROPER_NDK_HOME_DIRECTORY_MESSAGE);
        }
        if (!path.isDirectory()) {
            throw new InvalidNdkException("Path \"" + path + "\" is not a directory. " + PROPER_NDK_HOME_DIRECTORY_MESSAGE);
        }
    }

    public File getStripper(String toolchain) throws MojoExecutionException {
        File stripper;
        if (SystemUtils.IS_OS_LINUX) {
            stripper = new File(this.ndkPath, "toolchains/" + toolchain + "/prebuilt/linux-x86/bin/arm-linux-androideabi-strip");
        } else if (SystemUtils.IS_OS_WINDOWS) {
            stripper = new File(this.ndkPath, "toolchains/" + toolchain + "/prebuilt/windows/bin/arm-linux-androideabi-strip.exe");
        } else if (SystemUtils.IS_OS_MAC || SystemUtils.IS_OS_MAC_OSX) {
            stripper = new File(this.ndkPath, "toolchains/" + toolchain + "/prebuilt/darwin-x86/bin/arm-linux-androideabi-strip");
        } else {
            throw new MojoExecutionException("Could not resolve stripper for current OS: " + SystemUtils.OS_NAME);
        }
        if (!stripper.exists()) {
            throw new MojoExecutionException("Strip binary " + stripper.getAbsolutePath() + " does not exist, please double check the toolchain and OS used");
        }
        return stripper;
    }

    public String getNdkBuildPath() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return new File(this.ndkPath, "/ndk-build.cmd").getAbsolutePath();
        }
        return new File(this.ndkPath, "/ndk-build").getAbsolutePath();
    }

    public File getGdbServer(String toolchain) throws MojoExecutionException {
        File gdbServerFile = new File(this.ndkPath, "toolchains/" + toolchain + "/prebuilt/gdbserver");
        if (!gdbServerFile.exists()) {
            throw new MojoExecutionException("gdbserver binary " + gdbServerFile.getAbsolutePath() + " does not exist, please double check the toolchain and OS used");
        }
        return gdbServerFile;
    }
}

