/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase05compile;

import com.jayway.maven.plugins.android.common.AetherHelper;
import com.jayway.maven.plugins.android.common.JarHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.repository.RemoteRepository;

public class MakefileHelper {
    public static final String MAKEFILE_CAPTURE_FILE = "ANDROID_MAVEN_PLUGIN_LOCAL_C_INCLUDES_FILE";

    public static void cleanupAfterBuild(MakefileHolder makefileHolder) {
        if (makefileHolder.getIncludeDirectories() != null) {
            for (File file : makefileHolder.getIncludeDirectories()) {
                try {
                    FileUtils.deleteDirectory((File)file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static MakefileHolder createMakefileFromArtifacts(File outputDir, Set<Artifact> artifacts, boolean useHeaderArchives, RepositorySystemSession repoSession, List<RemoteRepository> projectRepos, RepositorySystem repoSystem) throws MojoExecutionException {
        StringBuilder makeFile = new StringBuilder("# Generated by Android Maven Plugin\n");
        ArrayList<File> includeDirectories = new ArrayList<File>();
        makeFile.append("$(shell echo \"LOCAL_C_INCLUDES=$(LOCAL_C_INCLUDES)\" > $(ANDROID_MAVEN_PLUGIN_LOCAL_C_INCLUDES_FILE))");
        makeFile.append('\n');
        makeFile.append("$(shell echo \"LOCAL_PATH=$(LOCAL_PATH)\" >> $(ANDROID_MAVEN_PLUGIN_LOCAL_C_INCLUDES_FILE))");
        makeFile.append('\n');
        makeFile.append("$(shell echo \"LOCAL_MODULE_FILENAME=$(LOCAL_MODULE_FILENAME)\" >> $(ANDROID_MAVEN_PLUGIN_LOCAL_C_INCLUDES_FILE))");
        makeFile.append('\n');
        makeFile.append("$(shell echo \"LOCAL_MODULE=$(LOCAL_MODULE)\" >> $(ANDROID_MAVEN_PLUGIN_LOCAL_C_INCLUDES_FILE))");
        makeFile.append('\n');
        makeFile.append("$(shell echo \"LOCAL_CFLAGS=$(LOCAL_CFLAGS)\" >> $(ANDROID_MAVEN_PLUGIN_LOCAL_C_INCLUDES_FILE))");
        makeFile.append('\n');
        if (!artifacts.isEmpty()) {
            makeFile.append("LOCAL_PATH := $(call my-dir)\n");
            for (Artifact artifact : artifacts) {
                makeFile.append("#\n");
                makeFile.append("# Group ID: ");
                makeFile.append(artifact.getGroupId());
                makeFile.append('\n');
                makeFile.append("# Artifact ID: ");
                makeFile.append(artifact.getArtifactId());
                makeFile.append('\n');
                makeFile.append("# Version: ");
                makeFile.append(artifact.getVersion());
                makeFile.append('\n');
                makeFile.append("include $(CLEAR_VARS)");
                makeFile.append('\n');
                makeFile.append("LOCAL_MODULE    := ");
                makeFile.append(artifact.getArtifactId());
                makeFile.append('\n');
                makeFile.append("LOCAL_SRC_FILES := ");
                makeFile.append(MakefileHelper.resolveRelativePath(outputDir, artifact.getFile()));
                makeFile.append('\n');
                if (useHeaderArchives) {
                    try {
                        DefaultArtifact harArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope(), "har", artifact.getClassifier(), artifact.getArtifactHandler());
                        Artifact resolvedHarArtifact = AetherHelper.resolveArtifact((Artifact)harArtifact, repoSystem, repoSession, projectRepos);
                        File includeDir = new File(System.getProperty("java.io.tmpdir"), "android_maven_plugin_native_includes" + System.currentTimeMillis() + "_" + resolvedHarArtifact.getArtifactId());
                        includeDir.deleteOnExit();
                        includeDirectories.add(includeDir);
                        JarHelper.unjar(new JarFile(resolvedHarArtifact.getFile()), includeDir, new JarHelper.UnjarListener(){

                            @Override
                            public boolean include(JarEntry jarEntry) {
                                return !jarEntry.getName().startsWith("META-INF");
                            }
                        });
                        makeFile.append("LOCAL_EXPORT_C_INCLUDES := ");
                        String str = includeDir.getAbsolutePath();
                        makeFile.append(str);
                        makeFile.append('\n');
                    }
                    catch (Exception e) {
                        throw new MojoExecutionException("Error while resolving header archive file for: " + artifact.getArtifactId(), e);
                    }
                }
                if ("a".equals(artifact.getType())) {
                    makeFile.append("include $(PREBUILT_STATIC_LIBRARY)\n");
                    continue;
                }
                makeFile.append("include $(PREBUILT_SHARED_LIBRARY)\n");
            }
        }
        return new MakefileHolder(includeDirectories, makeFile.toString());
    }

    public static String resolveRelativePath(File outputDirectory, File file) {
        String[] split;
        StringBuilder stringBuilder = new StringBuilder();
        String separator = File.separator;
        if (separator.equals("\\")) {
            separator = "\\\\";
        }
        if ((split = outputDirectory.getAbsolutePath().split(separator)) == null || split.length == 0) {
            return file.getAbsolutePath();
        }
        stringBuilder.append("..");
        for (int i = 0; i < split.length - 1; ++i) {
            stringBuilder.append(File.separator);
            stringBuilder.append("..");
        }
        return stringBuilder.toString() + file.getAbsolutePath();
    }

    public static String createLibraryList(Set<Artifact> resolvedStaticLibraryList, boolean staticLibrary) {
        StringBuilder sb = new StringBuilder();
        Iterator<Artifact> iterator = resolvedStaticLibraryList.iterator();
        while (iterator.hasNext()) {
            Artifact resolvedstaticLibraryArtifact = iterator.next();
            if (staticLibrary && "a".equals(resolvedstaticLibraryArtifact.getType())) {
                sb.append(resolvedstaticLibraryArtifact.getArtifactId());
            }
            if (!staticLibrary && "so".equals(resolvedstaticLibraryArtifact.getType())) {
                sb.append(resolvedstaticLibraryArtifact.getArtifactId());
            }
            if (!iterator.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public static class MakefileHolder {
        String makeFile;
        List<File> includeDirectories;

        public MakefileHolder(List<File> includeDirectories, String makeFile) {
            this.includeDirectories = includeDirectories;
            this.makeFile = makeFile;
        }

        public List<File> getIncludeDirectories() {
            return this.includeDirectories;
        }

        public String getMakeFile() {
            return this.makeFile;
        }
    }
}

