/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.standalonemojos;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.DeviceCallback;
import com.jayway.maven.plugins.android.common.DeviceHelper;
import com.jayway.maven.plugins.android.common.LogSyncProgressMonitor;
import com.jayway.maven.plugins.android.config.ConfigHandler;
import com.jayway.maven.plugins.android.config.ConfigPojo;
import com.jayway.maven.plugins.android.config.PullParameter;
import com.jayway.maven.plugins.android.configuration.Push;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class PushMojo
extends AbstractAndroidMojo {
    @ConfigPojo
    private Push push;
    private String pushSource;
    @PullParameter(required=true)
    private String parsedSource;
    private String pushDestination;
    @PullParameter(required=true)
    private String parsedDestination;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ConfigHandler configHandler = new ConfigHandler((Object)this);
        configHandler.parseConfiguration();
        final Map<String, String> sourceDestinationMap = this.calculateSourceDestinationMapping();
        this.doWithDevices(new DeviceCallback(){

            @Override
            public void doWithDevice(IDevice device) throws MojoExecutionException {
                String message = "";
                try {
                    SyncService syncService = device.getSyncService();
                    for (Map.Entry pushFileEntry : sourceDestinationMap.entrySet()) {
                        String sourcePath = (String)pushFileEntry.getKey();
                        String destinationPath = (String)pushFileEntry.getValue();
                        message = "Push of " + sourcePath + " to " + destinationPath + " on " + DeviceHelper.getDescriptiveName(device);
                        syncService.pushFile(sourcePath, destinationPath, (SyncService.ISyncProgressMonitor)new LogSyncProgressMonitor(PushMojo.this.getLog()));
                        PushMojo.this.getLog().info((CharSequence)(message + " successful."));
                    }
                }
                catch (SyncException e) {
                    throw new MojoExecutionException(message + " failed.", (Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new MojoExecutionException(message + " failed.", (Exception)e);
                }
                catch (TimeoutException e) {
                    throw new MojoExecutionException(message + " failed.", (Exception)((Object)e));
                }
                catch (AdbCommandRejectedException e) {
                    throw new MojoExecutionException(message + " failed.", (Exception)((Object)e));
                }
            }
        });
    }

    private Map<String, String> calculateSourceDestinationMapping() throws MojoExecutionException {
        HashMap<String, String> result = new HashMap<String, String>();
        File sourceFile = new File(this.parsedSource);
        String destinationPath = this.parsedDestination.endsWith("/") ? this.parsedDestination + sourceFile.getName() : this.parsedDestination;
        if (sourceFile.isFile()) {
            String sourcePath = sourceFile.getAbsolutePath();
            result.put(sourcePath, destinationPath);
        } else if (sourceFile.isDirectory()) {
            Collection filesList = FileUtils.listFiles((File)sourceFile, null, (boolean)true);
            for (File file : filesList) {
                String filePath = file.getAbsolutePath().substring(sourceFile.getAbsolutePath().length());
                result.put(file.getAbsolutePath(), destinationPath + filePath);
            }
        } else {
            throw new MojoExecutionException("Cannot execute push goal: File or directory " + sourceFile.getAbsolutePath() + " does not exist.");
        }
        return result;
    }
}

