/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android;

import com.jayway.maven.plugins.android.InvalidNdkException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.plugin.MojoExecutionException;

public class AndroidNdk {
    public static final String PROPER_NDK_HOME_DIRECTORY_MESSAGE = "Please provide a proper Android NDK directory path as configuration parameter <ndk><path>...</path></ndk> in the plugin <configuration/>. As an alternative, you may add the parameter to commandline: -Dandroid.ndk.path=... or set environment variable ANDROID_NDK_HOME.";
    public static final String[] NDK_ARCHITECTURES = new String[]{"armeabi", "armeabi-v7a", "mips", "x86"};
    private static final String[] ARM_TOOLCHAIN = new String[]{"arm-linux-androideabi-4.7", "arm-linux-androideabi-4.6", "arm-linux-androideabi-4.4.3"};
    private static final String[] X86_TOOLCHAIN = new String[]{"x86-4.7", "x86-4.6", "x86-4.4.3"};
    private static final String[] MIPS_TOOLCHAIN = new String[]{"mipsel-linux-android-4.7", "mipsel-linux-android-4.6", "mipsel-linux-android-4.4.3"};
    private static final String[] GDB_SERVER_LOCATIONS = new String[]{"toolchains/%s/prebuilt/gdbserver", "prebuilt/%s/gdbserver/gdbserver"};
    private final File ndkPath;

    public AndroidNdk(File ndkPath) {
        this.assertPathIsDirectory(ndkPath);
        this.ndkPath = ndkPath;
    }

    private void assertPathIsDirectory(File path) {
        if (path == null) {
            throw new InvalidNdkException(PROPER_NDK_HOME_DIRECTORY_MESSAGE);
        }
        if (!path.isDirectory()) {
            throw new InvalidNdkException("Path \"" + path + "\" is not a directory. " + PROPER_NDK_HOME_DIRECTORY_MESSAGE);
        }
    }

    private File findStripper(String toolchain) {
        String os = "";
        String extension = "";
        if (SystemUtils.IS_OS_LINUX) {
            os = "linux-x86";
        } else if (SystemUtils.IS_OS_WINDOWS) {
            os = "windows";
            extension = ".exe";
        } else if (SystemUtils.IS_OS_MAC || SystemUtils.IS_OS_MAC_OSX) {
            os = "darwin-x86";
        }
        String fileName = "";
        if (toolchain.startsWith("arm")) {
            fileName = "arm-linux-androideabi-strip" + extension;
        } else if (toolchain.startsWith("x86")) {
            fileName = "i686-linux-android-strip" + extension;
        } else if (toolchain.startsWith("mips")) {
            fileName = "mipsel-linux-android-strip" + extension;
        }
        String stripperLocation = String.format("toolchains/%s/prebuilt/%s/bin/%s", toolchain, os, fileName);
        File stripper = new File(this.ndkPath, stripperLocation);
        if (stripper.exists()) {
            return stripper;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAppAbi(File applicationMakefile) {
        block8: {
            Scanner scanner = null;
            try {
                if (applicationMakefile == null || !applicationMakefile.exists()) break block8;
                scanner = new Scanner(applicationMakefile);
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine().trim();
                    if (!line.startsWith("APP_ABI")) continue;
                    String[] stringArray = line.substring(line.indexOf(":=") + 2).trim().split(" ");
                    return stringArray;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }
        return null;
    }

    public File getStripper(String toolchain) throws MojoExecutionException {
        File stripper = this.findStripper(toolchain);
        if (stripper == null) {
            throw new MojoExecutionException("Could not resolve stripper for current OS: " + SystemUtils.OS_NAME);
        }
        if (!stripper.exists()) {
            throw new MojoExecutionException("Strip binary " + stripper.getAbsolutePath() + " does not exist, please double check the toolchain and OS used");
        }
        return stripper;
    }

    private String resolveNdkToolchain(String[] toolchains) {
        for (String toolchain : toolchains) {
            File f = this.findStripper(toolchain);
            if (f == null || !f.exists()) continue;
            return toolchain;
        }
        return null;
    }

    public String getToolchain(File file) throws MojoExecutionException {
        String resolvedNdkToolchain = null;
        String ndkArchitecture = file.getParentFile().getName();
        if (ndkArchitecture.startsWith("arm")) {
            resolvedNdkToolchain = this.resolveNdkToolchain(ARM_TOOLCHAIN);
        } else if (ndkArchitecture.startsWith("x86")) {
            resolvedNdkToolchain = this.resolveNdkToolchain(X86_TOOLCHAIN);
        } else if (ndkArchitecture.startsWith("mips")) {
            resolvedNdkToolchain = this.resolveNdkToolchain(MIPS_TOOLCHAIN);
        }
        if (resolvedNdkToolchain == null) {
            throw new MojoExecutionException("Can not resolve automatically a toolchain to use. Please specify one.");
        }
        return resolvedNdkToolchain;
    }

    public String getNdkBuildPath() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return new File(this.ndkPath, "/ndk-build.cmd").getAbsolutePath();
        }
        return new File(this.ndkPath, "/ndk-build").getAbsolutePath();
    }

    public File getGdbServer(String ndkArchitecture) throws MojoExecutionException {
        ArrayList<String> gdbServerLocations = new ArrayList<String>();
        if (ndkArchitecture.startsWith("arm")) {
            gdbServerLocations.add("android-arm");
            gdbServerLocations.addAll(Arrays.asList(ARM_TOOLCHAIN));
        } else if (ndkArchitecture.startsWith("x86")) {
            gdbServerLocations.add("android-x86");
            gdbServerLocations.addAll(Arrays.asList(X86_TOOLCHAIN));
        } else if (ndkArchitecture.startsWith("mips")) {
            gdbServerLocations.add("android-mips");
            gdbServerLocations.addAll(Arrays.asList(MIPS_TOOLCHAIN));
        }
        for (String location : GDB_SERVER_LOCATIONS) {
            for (String gdbServerLocation : gdbServerLocations) {
                File gdbServerFile = new File(this.ndkPath, String.format(location, gdbServerLocation));
                if (!gdbServerFile.exists()) continue;
                return gdbServerFile;
            }
        }
        throw new MojoExecutionException("gdbserver binary for architecture " + ndkArchitecture + " does not exist, please double check the toolchain and OS used");
    }

    public String[] getNdkArchitectures(String ndkClassifier, String ndkArchitecture, String applicationMakefile, File basedir) throws MojoExecutionException {
        String[] foundNdkArchitectures;
        File appMK;
        if (ndkClassifier != null) {
            return new String[]{ndkClassifier};
        }
        if (ndkArchitecture != null) {
            return new String[]{ndkArchitecture};
        }
        String applicationMakefileToUse = applicationMakefile;
        if (applicationMakefileToUse == null) {
            applicationMakefileToUse = "jni/Application.mk";
        }
        if ((appMK = new File(basedir, applicationMakefileToUse)).exists() && (foundNdkArchitectures = this.getAppAbi(appMK)) != null) {
            return foundNdkArchitectures;
        }
        return new String[]{"armeabi"};
    }
}

