/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.InstallException;
import com.jayway.maven.plugins.android.AndroidNdk;
import com.jayway.maven.plugins.android.AndroidSdk;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.DeviceCallback;
import com.jayway.maven.plugins.android.ExecutionException;
import com.jayway.maven.plugins.android.common.AetherHelper;
import com.jayway.maven.plugins.android.common.DeviceHelper;
import com.jayway.maven.plugins.android.config.ConfigPojo;
import com.jayway.maven.plugins.android.configuration.Ndk;
import com.jayway.maven.plugins.android.configuration.Sdk;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathNotFoundException;
import org.apache.commons.jxpath.xml.DocumentContainer;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.DirectoryScanner;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

public abstract class AbstractAndroidMojo
extends AbstractMojo {
    public static final List<String> SUPPORTED_PACKAGING_TYPES = new ArrayList<String>();
    private static final long ADB_TIMEOUT_MS = 60000L;
    public static final String ENV_ANDROID_NDK_HOME = "ANDROID_NDK_HOME";
    @ConfigPojo(prefix="ndk")
    private Ndk ndk;
    protected MavenProject project;
    protected MavenSession session;
    protected File sourceDirectory;
    protected File targetDirectory;
    protected File resourceDirectory;
    protected File nativeLibrariesDirectory;
    protected File resourceOverlayDirectory;
    protected File[] resourceOverlayDirectories;
    protected File assetsDirectory;
    protected File androidManifestFile;
    protected String renameManifestPackage;
    protected File extractedDependenciesDirectory;
    protected File extractedDependenciesRes;
    protected File extractedDependenciesAssets;
    protected File extractedDependenciesJavaSources;
    protected File extractedDependenciesJavaResources;
    protected File combinedRes;
    protected File combinedAssets;
    protected File unpackedApkLibsDirectory;
    protected String device;
    protected String configurations;
    protected String[] aaptExtraArgs;
    protected File proguardFile;
    protected boolean generateApk;
    protected RepositorySystem repoSystem;
    protected RepositorySystemSession repoSession;
    protected List<RemoteRepository> projectRepos;
    protected String customPackage;
    protected MavenProjectHelper projectHelper;
    private Sdk sdk;
    private File sdkPath;
    private String envAndroidHome;
    public static final String ENV_ANDROID_HOME = "ANDROID_HOME";
    private String sdkPlatform;
    protected boolean undeployBeforeDeploy;
    protected boolean attachJar;
    protected boolean attachSources;
    private File ndkPath;
    protected boolean release;
    private static final Object ADB_LOCK;
    private static boolean adbInitialized;
    protected static final List<String> EXCLUDED_DEPENDENCY_SCOPES;

    protected Set<Artifact> getRelevantCompileArtifacts() {
        List allArtifacts = this.project.getCompileArtifacts();
        Set<Artifact> results = this.filterOutIrrelevantArtifacts(allArtifacts);
        return results;
    }

    protected Set<Artifact> getRelevantDependencyArtifacts() {
        Set allArtifacts = this.project.getDependencyArtifacts();
        Set<Artifact> results = this.filterOutIrrelevantArtifacts(allArtifacts);
        return results;
    }

    protected Set<Artifact> getAllRelevantDependencyArtifacts() {
        Set allArtifacts = this.project.getArtifacts();
        Set<Artifact> results = this.filterOutIrrelevantArtifacts(allArtifacts);
        return results;
    }

    private Set<Artifact> filterOutIrrelevantArtifacts(Iterable<Artifact> allArtifacts) {
        LinkedHashSet<Artifact> results = new LinkedHashSet<Artifact>();
        for (Artifact artifact : allArtifacts) {
            if (artifact == null || EXCLUDED_DEPENDENCY_SCOPES.contains(artifact.getScope()) || "apk".equalsIgnoreCase(artifact.getType())) continue;
            results.add(artifact);
        }
        return results;
    }

    protected File resolveArtifactToFile(Artifact artifact) throws MojoExecutionException {
        Artifact resolvedArtifact = AetherHelper.resolveArtifact(artifact, this.repoSystem, this.repoSession, this.projectRepos);
        File jar = resolvedArtifact.getFile();
        if (jar == null) {
            throw new MojoExecutionException("Could not resolve artifact " + artifact.getId() + ". Please install it with \"mvn install:install-file ...\" or deploy it to a repository " + "with \"mvn deploy:deploy-file ...\"");
        }
        return jar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AndroidDebugBridge initAndroidDebugBridge() throws MojoExecutionException {
        Object object = ADB_LOCK;
        synchronized (object) {
            if (!adbInitialized) {
                AndroidDebugBridge.init((boolean)false);
                adbInitialized = true;
            }
            AndroidDebugBridge androidDebugBridge = AndroidDebugBridge.createBridge((String)this.getAndroidSdk().getAdbPath(), (boolean)false);
            this.waitUntilConnected(androidDebugBridge);
            return androidDebugBridge;
        }
    }

    private void waitUntilConnected(AndroidDebugBridge adb) {
        int connectionWaitTime = 50;
        for (int trials = 10; trials > 0; --trials) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (adb.isConnected()) break;
        }
    }

    protected void waitForInitialDeviceList(AndroidDebugBridge androidDebugBridge) throws MojoExecutionException {
        if (!androidDebugBridge.hasInitialDeviceList()) {
            this.getLog().info((CharSequence)"Waiting for initial device list from the Android Debug Bridge");
            long limitTime = System.currentTimeMillis() + 60000L;
            while (!androidDebugBridge.hasInitialDeviceList() && System.currentTimeMillis() < limitTime) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new MojoExecutionException("Interrupted waiting for initial device list from Android Debug Bridge");
                }
            }
            if (!androidDebugBridge.hasInitialDeviceList()) {
                this.getLog().error((CharSequence)"Did not receive initial device list from the Android Debug Bridge.");
            }
        }
    }

    protected void deployApk(final File apkFile) throws MojoExecutionException, MojoFailureException {
        if (this.undeployBeforeDeploy) {
            this.undeployApk(apkFile);
        }
        this.doWithDevices(new DeviceCallback(){

            @Override
            public void doWithDevice(IDevice device) throws MojoExecutionException {
                String deviceLogLinePrefix = DeviceHelper.getDeviceLogLinePrefix(device);
                try {
                    String result = device.installPackage(apkFile.getAbsolutePath(), true, new String[0]);
                    if (result != null) {
                        throw new MojoExecutionException(deviceLogLinePrefix + "Install of " + apkFile.getAbsolutePath() + " failed - [" + result + "]");
                    }
                    AbstractAndroidMojo.this.getLog().info((CharSequence)(deviceLogLinePrefix + "Successfully installed " + apkFile.getAbsolutePath() + " to " + DeviceHelper.getDescriptiveName(device)));
                }
                catch (InstallException e) {
                    throw new MojoExecutionException(deviceLogLinePrefix + "Install of " + apkFile.getAbsolutePath() + " failed.", (Exception)((Object)e));
                }
            }
        });
    }

    protected void deployDependencies() throws MojoExecutionException, MojoFailureException {
        Set directDependentArtifacts = this.project.getDependencyArtifacts();
        if (directDependentArtifacts != null) {
            for (Artifact artifact : directDependentArtifacts) {
                String type = artifact.getType();
                if (!type.equals("apk")) continue;
                this.getLog().debug((CharSequence)("Detected apk dependency " + artifact + ". Will resolve and deploy to device..."));
                File targetApkFile = this.resolveArtifactToFile(artifact);
                if (this.undeployBeforeDeploy) {
                    this.getLog().debug((CharSequence)("Attempting undeploy of " + targetApkFile + " from device..."));
                    this.undeployApk(targetApkFile);
                }
                this.getLog().debug((CharSequence)("Deploying " + targetApkFile + " to device..."));
                this.deployApk(targetApkFile);
            }
        }
    }

    protected void deployBuiltApk() throws MojoExecutionException, MojoFailureException {
        if (!SUPPORTED_PACKAGING_TYPES.contains(this.project.getPackaging())) {
            this.getLog().info((CharSequence)("Skipping deployment on " + this.project.getPackaging()));
            return;
        }
        File apkFile = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + "." + "apk");
        this.deployApk(apkFile);
    }

    protected void doWithDevices(final DeviceCallback deviceCallback) throws MojoExecutionException, MojoFailureException {
        AndroidDebugBridge androidDebugBridge = this.initAndroidDebugBridge();
        if (!androidDebugBridge.isConnected()) {
            throw new MojoExecutionException("Android Debug Bridge is not connected.");
        }
        this.waitForInitialDeviceList(androidDebugBridge);
        List<IDevice> devices = Arrays.asList(androidDebugBridge.getDevices());
        int numberOfDevices = devices.size();
        this.getLog().info((CharSequence)("Found " + numberOfDevices + " devices connected with the Android Debug Bridge"));
        if (devices.size() == 0) {
            throw new MojoExecutionException("No online devices attached.");
        }
        boolean shouldRunOnAllDevices = StringUtils.isBlank((String)this.device);
        if (shouldRunOnAllDevices) {
            this.getLog().info((CharSequence)"android.device parameter not set, using all attached devices");
        } else {
            this.getLog().info((CharSequence)("android.device parameter set to " + this.device));
        }
        ArrayList<DoThread> doThreads = new ArrayList<DoThread>();
        for (final IDevice idevice : devices) {
            if (shouldRunOnAllDevices) {
                String deviceType = idevice.isEmulator() ? "Emulator " : "Device ";
                this.getLog().info((CharSequence)(deviceType + DeviceHelper.getDescriptiveName(idevice) + " found."));
            }
            if (!shouldRunOnAllDevices && !this.shouldDoWithThisDevice(idevice)) continue;
            DoThread deviceDoThread = new DoThread(){

                @Override
                public void runDo() throws MojoFailureException, MojoExecutionException {
                    deviceCallback.doWithDevice(idevice);
                }
            };
            doThreads.add(deviceDoThread);
            deviceDoThread.start();
        }
        this.joinAllThreads(doThreads);
        this.throwAnyDoThreadErrors(doThreads);
        if (!shouldRunOnAllDevices && doThreads.isEmpty()) {
            throw new MojoExecutionException("No device found for android.device=" + this.device);
        }
    }

    private void joinAllThreads(ArrayList<DoThread> doThreads) {
        for (Thread thread : doThreads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                new MojoExecutionException("Thread#join error for device: " + this.device);
            }
        }
    }

    private void throwAnyDoThreadErrors(ArrayList<DoThread> doThreads) throws MojoExecutionException, MojoFailureException {
        for (DoThread deviceDoThread : doThreads) {
            if (deviceDoThread.failure != null) {
                throw deviceDoThread.failure;
            }
            if (deviceDoThread.execution == null) continue;
            throw deviceDoThread.execution;
        }
    }

    private boolean shouldDoWithThisDevice(IDevice idevice) throws MojoExecutionException, MojoFailureException {
        if ("emulator".equals(this.device) && idevice.isEmulator()) {
            return true;
        }
        if ("usb".equals(this.device) && !idevice.isEmulator()) {
            return true;
        }
        if (idevice.isEmulator() && (this.device.equalsIgnoreCase(idevice.getAvdName()) || this.device.equalsIgnoreCase(idevice.getSerialNumber()))) {
            return true;
        }
        return !idevice.isEmulator() && this.device.equals(idevice.getSerialNumber());
    }

    protected boolean undeployApk(File apkFile) throws MojoExecutionException, MojoFailureException {
        String packageName = this.extractPackageNameFromApk(apkFile);
        return this.undeployApk(packageName);
    }

    protected boolean undeployApk(final String packageName) throws MojoExecutionException, MojoFailureException {
        final AtomicBoolean result = new AtomicBoolean(true);
        this.doWithDevices(new DeviceCallback(){

            @Override
            public void doWithDevice(IDevice device) throws MojoExecutionException {
                String deviceLogLinePrefix = DeviceHelper.getDeviceLogLinePrefix(device);
                try {
                    device.uninstallPackage(packageName);
                    AbstractAndroidMojo.this.getLog().info((CharSequence)(deviceLogLinePrefix + "Successfully uninstalled " + packageName + " from " + DeviceHelper.getDescriptiveName(device)));
                    result.set(true);
                }
                catch (InstallException e) {
                    result.set(false);
                    throw new MojoExecutionException(deviceLogLinePrefix + "Uninstall of " + packageName + " failed.", (Exception)((Object)e));
                }
            }
        });
        return result.get();
    }

    protected String extractPackageNameFromApk(File apkFile) throws MojoExecutionException {
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("dump");
        commands.add("xmltree");
        commands.add(apkFile.getAbsolutePath());
        commands.add("AndroidManifest.xml");
        this.getLog().info((CharSequence)(this.getAndroidSdk().getAaptPath() + " " + ((Object)commands).toString()));
        try {
            executor.executeCommand(this.getAndroidSdk().getAaptPath(), commands, false);
            String xmlTree = executor.getStandardOut();
            String string = this.extractPackageNameFromAndroidManifestXmlTree(xmlTree);
            return string;
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("Error while trying to figure out package name from inside apk file " + apkFile);
        }
        finally {
            String errout = executor.getStandardError();
            if (errout != null && errout.trim().length() > 0) {
                this.getLog().error((CharSequence)errout);
            }
        }
    }

    protected String extractPackageNameFromAndroidManifestXmlTree(String aaptDumpXmlTree) {
        Scanner scanner = new Scanner(aaptDumpXmlTree);
        scanner.findWithinHorizon("^E: manifest", 0);
        scanner.findWithinHorizon("  A: package=\"", 0);
        String packageName = scanner.next(".*?\"");
        packageName = packageName.substring(0, packageName.length() - 1);
        return packageName;
    }

    protected String extractPackageNameFromAndroidManifest(File androidManifestFile) throws MojoExecutionException {
        URL xmlURL;
        try {
            xmlURL = androidManifestFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error while trying to figure out package name from inside AndroidManifest.xml file " + androidManifestFile, (Exception)e);
        }
        DocumentContainer documentContainer = new DocumentContainer(xmlURL);
        Object packageName = JXPathContext.newContext((Object)documentContainer).getValue("manifest/@package", String.class);
        return (String)packageName;
    }

    protected String extractInstrumentationRunnerFromAndroidManifest(File androidManifestFile) throws MojoExecutionException {
        Object instrumentationRunner;
        URL xmlURL;
        try {
            xmlURL = androidManifestFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error while trying to figure out instrumentation runner from inside AndroidManifest.xml file " + androidManifestFile, (Exception)e);
        }
        DocumentContainer documentContainer = new DocumentContainer(xmlURL);
        try {
            instrumentationRunner = JXPathContext.newContext((Object)documentContainer).getValue("manifest//instrumentation/@android:name", String.class);
        }
        catch (JXPathNotFoundException e) {
            return null;
        }
        return (String)instrumentationRunner;
    }

    protected int deleteFilesFromDirectory(File baseDirectory, String ... includes) throws MojoExecutionException {
        String[] files = this.findFilesInDirectory(baseDirectory, includes);
        if (files == null) {
            return 0;
        }
        for (String file : files) {
            boolean successfullyDeleted = new File(baseDirectory, file).delete();
            if (successfullyDeleted) continue;
            throw new MojoExecutionException("Failed to delete \"" + file + "\"");
        }
        return files.length;
    }

    protected String[] findFilesInDirectory(File baseDirectory, String ... includes) {
        if (baseDirectory.exists()) {
            DirectoryScanner directoryScanner = new DirectoryScanner();
            directoryScanner.setBasedir(baseDirectory);
            directoryScanner.setIncludes(includes);
            directoryScanner.addDefaultExcludes();
            directoryScanner.scan();
            String[] files = directoryScanner.getIncludedFiles();
            return files;
        }
        return new String[0];
    }

    protected AndroidSdk getAndroidSdk() throws MojoExecutionException {
        String chosenSdkPlatform;
        File chosenSdkPath;
        if (this.sdk != null) {
            chosenSdkPath = this.sdk.getPath() != null ? this.sdk.getPath() : (this.sdkPath != null ? this.sdkPath : new File(this.getAndroidHomeOrThrow()));
            chosenSdkPlatform = !StringUtils.isBlank((String)this.sdk.getPlatform()) ? this.sdk.getPlatform() : this.sdkPlatform;
        } else {
            chosenSdkPath = this.sdkPath != null ? this.sdkPath : new File(this.getAndroidHomeOrThrow());
            chosenSdkPlatform = this.sdkPlatform;
        }
        return new AndroidSdk(chosenSdkPath, chosenSdkPlatform);
    }

    private String getAndroidHomeOrThrow() throws MojoExecutionException {
        String androidHome = System.getenv(ENV_ANDROID_HOME);
        if (StringUtils.isBlank((String)androidHome)) {
            throw new MojoExecutionException("No Android SDK path could be found. You may configure it in the plugin configuration section in the pom file using <sdk><path>...</path></sdk> or <properties><android.sdk.path>...</android.sdk.path></properties> or on command-line using -Dandroid.sdk.path=... or by setting environment variable ANDROID_HOME");
        }
        return androidHome;
    }

    protected String getLibraryUnpackDirectory(Artifact apkLibraryArtifact) {
        return AbstractAndroidMojo.getLibraryUnpackDirectory(this.unpackedApkLibsDirectory, apkLibraryArtifact);
    }

    public static String getLibraryUnpackDirectory(File unpackedApkLibsDirectory, Artifact apkLibraryArtifact) {
        return unpackedApkLibsDirectory.getAbsolutePath() + "/" + apkLibraryArtifact.getId().replace(":", "_");
    }

    protected AndroidNdk getAndroidNdk() throws MojoExecutionException {
        File chosenNdkPath = null;
        chosenNdkPath = this.ndkPath != null ? this.ndkPath : (this.ndk != null && this.ndk.getPath() != null ? this.ndk.getPath() : new File(this.getAndroidNdkHomeOrThrow()));
        return new AndroidNdk(chosenNdkPath);
    }

    private String getAndroidNdkHomeOrThrow() throws MojoExecutionException {
        String androidHome = System.getenv(ENV_ANDROID_NDK_HOME);
        if (StringUtils.isBlank((String)androidHome)) {
            throw new MojoExecutionException("No Android NDK path could be found. You may configure it in the pom using <ndk><path>...</path></ndk> or <properties><ndk.path>...</ndk.path></properties> or on command-line using -Dandroid.ndk.path=... or by setting environment variable ANDROID_NDK_HOME");
        }
        return androidHome;
    }

    public File[] getResourceOverlayDirectories() {
        File[] overlayDirectories = this.resourceOverlayDirectories == null || this.resourceOverlayDirectories.length == 0 ? new File[]{this.resourceOverlayDirectory} : this.resourceOverlayDirectories;
        return overlayDirectories;
    }

    static {
        SUPPORTED_PACKAGING_TYPES.add("apk");
        ADB_LOCK = new Object();
        adbInitialized = false;
        EXCLUDED_DEPENDENCY_SCOPES = Arrays.asList("provided", "system", "import");
    }

    private abstract class DoThread
    extends Thread {
        private MojoFailureException failure;
        private MojoExecutionException execution;

        private DoThread() {
        }

        @Override
        public final void run() {
            try {
                this.runDo();
            }
            catch (MojoFailureException e) {
                this.failure = e;
            }
            catch (MojoExecutionException e) {
                this.execution = e;
            }
        }

        protected abstract void runDo() throws MojoFailureException, MojoExecutionException;
    }
}

