/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.testrunner;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.InstrumentationResultParser;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class UIAutomatorRemoteAndroidTestRunner {
    private IDevice mRemoteDevice;
    private int mMaxTimeToOutputResponse = 0;
    private String mRunName = null;
    private List<Map.Entry<String, String>> mArgList;
    private InstrumentationResultParser mParser;
    private final String jarFile;
    private boolean noHup;
    private Object dumpFilePath;
    private static final String LOG_TAG = "RemoteAndroidTest";
    private static final String CLASS_ARG_NAME = "class";
    private static final String DEBUG_ARG_NAME = "debug";

    public UIAutomatorRemoteAndroidTestRunner(String jarFile, IDevice remoteDevice) {
        this.jarFile = jarFile;
        this.mRemoteDevice = remoteDevice;
        this.mArgList = new ArrayList<Map.Entry<String, String>>();
    }

    public void setTestClassOrMethods(String[] testClassOrMethods) {
        for (String testClassOrMethod : testClassOrMethods) {
            this.addInstrumentationArg(CLASS_ARG_NAME, testClassOrMethod);
        }
    }

    public void addInstrumentationArg(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("name or value arguments cannot be null");
        }
        this.mArgList.add(new AbstractMap.SimpleImmutableEntry<String, String>(name, value));
    }

    public void addBooleanArg(String name, boolean value) {
        this.addInstrumentationArg(name, Boolean.toString(value));
    }

    public void setDebug(boolean debug) {
        this.addBooleanArg(DEBUG_ARG_NAME, debug);
    }

    public void setNoHup(boolean noHup) {
        this.noHup = noHup;
    }

    public void setDumpFilePath(String dumpFilePath) {
        this.dumpFilePath = dumpFilePath;
    }

    public void setMaxtimeToOutputResponse(int maxTimeToOutputResponse) {
        this.mMaxTimeToOutputResponse = maxTimeToOutputResponse;
    }

    public void setRunName(String runName) {
        this.mRunName = runName;
    }

    public void run(ITestRunListener ... listeners) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        this.run(Arrays.asList(listeners));
    }

    public void run(Collection<ITestRunListener> listeners) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        String runCaseCommandStr = String.format("uiautomator runtest %1$s %2$s", this.jarFile, this.buildArgsCommand());
        Log.i((String)LOG_TAG, (String)String.format("Running %1$s on %2$s", runCaseCommandStr, this.mRemoteDevice.getSerialNumber()));
        this.mParser = new InstrumentationResultParser(this.mRunName, listeners);
        try {
            this.mRemoteDevice.executeShellCommand(runCaseCommandStr, (IShellOutputReceiver)this.mParser, this.mMaxTimeToOutputResponse);
        }
        catch (IOException e) {
            Log.w((String)LOG_TAG, (String)String.format("IOException %1$s when running tests %2$s on %3$s", e.toString(), this.jarFile, this.mRemoteDevice.getSerialNumber()));
            this.mParser.handleTestRunFailed(e.toString());
            throw e;
        }
        catch (ShellCommandUnresponsiveException e) {
            Log.w((String)LOG_TAG, (String)String.format("ShellCommandUnresponsiveException %1$s when running tests %2$s on %3$s", e.toString(), this.jarFile, this.mRemoteDevice.getSerialNumber()));
            this.mParser.handleTestRunFailed(String.format("Failed to receive adb shell test output within %1$d ms. Test may have timed out, or adb connection to device became unresponsive", this.mMaxTimeToOutputResponse));
            throw e;
        }
        catch (TimeoutException e) {
            Log.w((String)LOG_TAG, (String)String.format("TimeoutException when running tests %1$s on %2$s", this.jarFile, this.mRemoteDevice.getSerialNumber()));
            this.mParser.handleTestRunFailed(e.toString());
            throw e;
        }
        catch (AdbCommandRejectedException e) {
            Log.w((String)LOG_TAG, (String)String.format("AdbCommandRejectedException %1$s when running tests %2$s on %3$s", e.toString(), this.jarFile, this.mRemoteDevice.getSerialNumber()));
            this.mParser.handleTestRunFailed(e.toString());
            throw e;
        }
    }

    public void cancel() {
        if (this.mParser != null) {
            this.mParser.cancel();
        }
    }

    private String buildArgsCommand() {
        StringBuilder commandBuilder = new StringBuilder();
        for (Map.Entry<String, String> argPair : this.mArgList) {
            String argCmd = String.format(" -e %1$s %2$s", argPair.getKey(), argPair.getValue());
            commandBuilder.append(argCmd);
        }
        if (this.noHup) {
            commandBuilder.append(" --nohup");
        }
        if (this.dumpFilePath != null) {
            commandBuilder.append(" dump " + this.dumpFilePath);
        }
        return commandBuilder.toString();
    }

    public void setUserProperties(Properties userProperties, String propertiesKeyPrefix) {
        if (userProperties == null) {
            throw new IllegalArgumentException("userProperties  cannot be null");
        }
        if (StringUtils.isBlank((String)propertiesKeyPrefix)) {
            return;
        }
        for (Map.Entry<Object, Object> property : userProperties.entrySet()) {
            String name = (String)property.getKey();
            if (!StringUtils.startsWith((String)name, (String)propertiesKeyPrefix)) continue;
            String value = (String)property.getValue();
            if (!StringUtils.isNotBlank((String)(name = StringUtils.substring((String)name, (int)StringUtils.length((String)propertiesKeyPrefix), (int)StringUtils.length((String)name))))) continue;
            this.addInstrumentationArg(name, value);
        }
    }
}

