/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase01generatesources;

import com.jayway.maven.plugins.android.phase01generatesources.ConflictingLayout;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;

final class ConflictingLayoutDetector {
    private Map<String, Collection<String>> map = new HashMap<String, Collection<String>>();

    ConflictingLayoutDetector() {
    }

    public void addLayoutFiles(String packageName, String[] layoutFiles) {
        this.map.put(packageName, Arrays.asList(layoutFiles));
    }

    public Collection<ConflictingLayout> getConflictingLayouts() {
        TreeMap<String, ConflictingLayout> result = new TreeMap<String, ConflictingLayout>();
        for (String entryA : this.map.keySet()) {
            for (String entryB : this.map.keySet()) {
                if (entryA.equals(entryB)) continue;
                HashSet<String> tmp = new HashSet<String>();
                tmp.addAll(this.map.get(entryA));
                tmp.retainAll(this.map.get(entryB));
                for (String layoutFile : tmp) {
                    if (!result.containsKey(layoutFile)) {
                        result.put(layoutFile, new ConflictingLayout(layoutFile));
                    }
                    ConflictingLayout layout = (ConflictingLayout)result.get(layoutFile);
                    layout.addPackageName(entryA);
                    layout.addPackageName(entryB);
                }
            }
        }
        return result.values();
    }
}

