/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android;

import com.jayway.maven.plugins.android.InvalidNdkException;
import java.io.File;

public class AndroidNdk {
    private static final String PARAMETER_MESSAGE = "Please provide a proper Android NDK directory path as configuration parameter <ndk><path>...</path></ndk> in the plugin <configuration/>. As an alternative, you may add the parameter to commandline: -Dandroid.ndk.path=... or set environment variable ANDROID_NDK_HOME.";
    private final File ndkPath;

    public AndroidNdk(File ndkPath) {
        this.assertPathIsDirectory(ndkPath);
        this.ndkPath = ndkPath;
    }

    private void assertPathIsDirectory(File path) {
        if (path == null) {
            throw new InvalidNdkException(PARAMETER_MESSAGE);
        }
        if (!path.isDirectory()) {
            throw new InvalidNdkException("Path \"" + path + "\" is not a directory. " + PARAMETER_MESSAGE);
        }
    }

    public String getNdkBuildPath() {
        return new File(this.ndkPath, "/ndk-build").getAbsolutePath();
    }
}

