/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.builder;

import com.jayway.restassured.assertion.AssertParameter;
import com.jayway.restassured.internal.RestAssuredResponseImpl;
import com.jayway.restassured.response.Cookies;
import com.jayway.restassured.response.Headers;
import com.jayway.restassured.response.Response;
import java.io.InputStream;

public class ResponseBuilder {
    private RestAssuredResponseImpl restAssuredResponse = new RestAssuredResponseImpl();

    public ResponseBuilder clone(Response response) {
        if (this.isRestAssuredResponse(response)) {
            RestAssuredResponseImpl raResponse = this.raResponse(response);
            this.restAssuredResponse.setContent(raResponse.getContent());
            this.restAssuredResponse.setHasExpectations(raResponse.getHasExpectations());
            this.restAssuredResponse.setDefaultContentType(raResponse.getDefaultContentType());
            this.restAssuredResponse.setDefaultCharset(raResponse.getDefaultCharset());
            this.restAssuredResponse.setSessionIdName(raResponse.getSessionIdName());
            this.restAssuredResponse.setConnectionManager(raResponse.getConnectionManager());
            this.restAssuredResponse.setObjectMapperConfig(raResponse.getObjectMapperConfig());
            this.restAssuredResponse.setConnectionConfig(raResponse.getConnectionConfig());
            this.restAssuredResponse.setRpr(raResponse.getRpr());
        } else {
            this.restAssuredResponse.setContent(response.asInputStream());
        }
        this.restAssuredResponse.setContentType(response.getContentType());
        this.restAssuredResponse.setCookies(response.getDetailedCookies());
        this.restAssuredResponse.setResponseHeaders(response.getHeaders());
        this.restAssuredResponse.setStatusCode(response.getStatusCode());
        this.restAssuredResponse.setStatusLine(response.getStatusLine());
        return this;
    }

    public ResponseBuilder setBody(String stringBody) {
        AssertParameter.notNull(stringBody, "Response body");
        this.restAssuredResponse.setContent(stringBody);
        return this;
    }

    public ResponseBuilder setBody(InputStream inputStream) {
        AssertParameter.notNull(inputStream, "Response body");
        this.restAssuredResponse.setContent(inputStream);
        return this;
    }

    public ResponseBuilder setBody(byte[] bytes) {
        AssertParameter.notNull(bytes, "Response body");
        this.restAssuredResponse.setContent(bytes);
        return this;
    }

    public ResponseBuilder setHeaders(Headers headers) {
        AssertParameter.notNull(headers, "Headers");
        this.restAssuredResponse.setResponseHeaders(headers);
        return this;
    }

    public ResponseBuilder setCookies(Cookies cookies) {
        AssertParameter.notNull(cookies, "Cookies");
        this.restAssuredResponse.setCookies(cookies);
        return this;
    }

    public ResponseBuilder setContentType(String contentType) {
        AssertParameter.notNull(contentType, "Content type");
        this.restAssuredResponse.setContentType(contentType);
        return this;
    }

    public ResponseBuilder setStatusLine(String statusLine) {
        AssertParameter.notNull(statusLine, "Status line");
        this.restAssuredResponse.setStatusLine(statusLine);
        return this;
    }

    public ResponseBuilder setStatusCode(int statusCode) {
        this.restAssuredResponse.setStatusCode(statusCode);
        return this;
    }

    public Response build() {
        int statusCode = this.restAssuredResponse.statusCode();
        if (statusCode < 100 || statusCode >= 600) {
            throw new IllegalArgumentException(String.format("Status code must be greater than 100 and less than 600, was %d.", statusCode));
        }
        AssertParameter.notNull("Status line", this.restAssuredResponse.statusLine());
        return this.restAssuredResponse;
    }

    private boolean isRestAssuredResponse(Response response) {
        return response instanceof RestAssuredResponseImpl;
    }

    private RestAssuredResponseImpl raResponse(Response response) {
        return (RestAssuredResponseImpl)response;
    }
}

