/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.http;

import com.jayway.restassured.internal.http.ContentTypeExtractor;
import org.apache.commons.collections.iterators.ArrayIterator;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ContentType {
    ANY("*/*"),
    TEXT("text/plain"),
    JSON("application/json", "application/javascript", "text/javascript"),
    XML("application/xml", "text/xml", "application/xhtml+xml"),
    HTML("text/html"),
    URLENC("application/x-www-form-urlencoded"),
    BINARY("application/octet-stream");

    private static final String PLUS_XML = "+xml";
    private static final String PLUS_JSON = "+json";
    private static final String PLUS_HTML = "+html";
    private final String[] ctStrings;

    public String[] getContentTypeStrings() {
        return this.ctStrings;
    }

    public String toString() {
        return this.ctStrings[0];
    }

    public String getAcceptHeader() {
        ArrayIterator iter = new ArrayIterator((Object)this.ctStrings);
        StringBuilder sb = new StringBuilder();
        while (iter.hasNext()) {
            sb.append((String)iter.next());
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private ContentType(String ... contentTypes) {
        this.ctStrings = contentTypes;
    }

    public static ContentType fromContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        ContentType foundContentType = ArrayUtils.contains((Object[])ContentType.XML.ctStrings, (Object)(contentType = ContentTypeExtractor.getContentTypeWithoutCharset(contentType.toLowerCase()))) || StringUtils.endsWithIgnoreCase((CharSequence)contentType, (CharSequence)PLUS_XML) ? XML : (ArrayUtils.contains((Object[])ContentType.JSON.ctStrings, (Object)contentType) || StringUtils.endsWithIgnoreCase((CharSequence)contentType, (CharSequence)PLUS_JSON) ? JSON : (ArrayUtils.contains((Object[])ContentType.TEXT.ctStrings, (Object)contentType) ? TEXT : (ArrayUtils.contains((Object[])ContentType.HTML.ctStrings, (Object)contentType) || StringUtils.endsWithIgnoreCase((CharSequence)contentType, (CharSequence)PLUS_HTML) ? HTML : null)));
        return foundContentType;
    }
}

