/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.internal.http;

import com.jayway.restassured.internal.http.HTTPBuilder;
import com.jayway.restassured.internal.http.URIBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.commonshttp.CommonsHttpOAuthConsumer;
import oauth.signpost.commonshttp.HttpRequestAdapter;
import oauth.signpost.exception.OAuthException;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.protocol.HttpContext;

public class AuthConfig {
    protected HTTPBuilder builder;

    public AuthConfig(HTTPBuilder builder) {
        this.builder = builder;
    }

    public void basic(String user, String pass) {
        URI uri = ((URIBuilder)this.builder.getUri()).toURI();
        if (uri == null) {
            throw new IllegalStateException("a default URI must be set");
        }
        this.basic(uri.getHost(), uri.getPort(), user, pass);
    }

    public void basic(String host, int port, String user, String pass) {
        this.builder.getClient().getCredentialsProvider().setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(user, pass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void certificate(String certURL, String password) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        InputStream jksStream = new URL(certURL).openStream();
        try {
            keyStore.load(jksStream, password.toCharArray());
        }
        finally {
            jksStream.close();
        }
        SSLSocketFactory ssl = new SSLSocketFactory(keyStore, password);
        ssl.setHostnameVerifier(SSLSocketFactory.STRICT_HOSTNAME_VERIFIER);
        this.builder.getClient().getConnectionManager().getSchemeRegistry().register(new Scheme("https", (SocketFactory)ssl, 443));
    }

    public void oauth(String consumerKey, String consumerSecret, String accessToken, String secretToken) {
        this.builder.client.removeRequestInterceptorByClass(OAuthSigner.class);
        if (consumerKey != null) {
            this.builder.client.addRequestInterceptor((HttpRequestInterceptor)new OAuthSigner(consumerKey, consumerSecret, accessToken, secretToken));
        }
    }

    static class OAuthSigner
    implements HttpRequestInterceptor {
        protected OAuthConsumer oauth;

        public OAuthSigner(String consumerKey, String consumerSecret, String accessToken, String secretToken) {
            this.oauth = new CommonsHttpOAuthConsumer(consumerKey, consumerSecret);
            this.oauth.setTokenWithSecret(accessToken, secretToken);
        }

        public void process(HttpRequest request, HttpContext ctx) throws HttpException, IOException {
            try {
                HttpUriRequest uriRequest = (HttpUriRequest)request;
                HttpHost host = (HttpHost)ctx.getAttribute("http.target_host");
                final URI requestURI = new URI(host.toURI()).resolve(uriRequest.getURI());
                HttpRequestAdapter oAuthRequest = new HttpRequestAdapter(uriRequest){

                    public String getRequestUrl() {
                        return requestURI.toString();
                    }
                };
                this.oauth.sign((oauth.signpost.http.HttpRequest)oAuthRequest);
            }
            catch (ClassCastException ex) {
                throw new HttpException("Request must be an instance of HttpUriRequest", (Throwable)ex);
            }
            catch (URISyntaxException ex) {
                throw new HttpException("Error rebuilding request URI", (Throwable)ex);
            }
            catch (OAuthException e) {
                throw new HttpException("OAuth signing error", (Throwable)e);
            }
        }
    }
}

