/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.config;

import com.jayway.restassured.config.ConnectionConfig;
import com.jayway.restassured.config.DecoderConfig;
import com.jayway.restassured.config.EncoderConfig;
import com.jayway.restassured.config.HttpClientConfig;
import com.jayway.restassured.config.LogConfig;
import com.jayway.restassured.config.ObjectMapperConfig;
import com.jayway.restassured.config.RedirectConfig;
import com.jayway.restassured.config.SessionConfig;
import com.jayway.restassured.internal.assertion.AssertParameter;
import com.jayway.restassured.path.json.config.JsonPathConfig;

public class RestAssuredConfig {
    private final RedirectConfig redirectConfig;
    private final HttpClientConfig httpClientConfig;
    private final LogConfig logConfig;
    private final EncoderConfig encoderConfig;
    private final DecoderConfig decoderConfig;
    private final SessionConfig sessionConfig;
    private final ObjectMapperConfig objectMapperConfig;
    private final ConnectionConfig connectionConfig;
    private final JsonPathConfig jsonPathConfig;

    public RestAssuredConfig() {
        this(new RedirectConfig(), new HttpClientConfig(), new LogConfig(), new EncoderConfig(), new DecoderConfig(), new SessionConfig(), new ObjectMapperConfig(), new ConnectionConfig(), new JsonPathConfig());
    }

    public RestAssuredConfig(RedirectConfig redirectConfig, HttpClientConfig httpClientConfig, LogConfig logConfig, EncoderConfig encoderConfig, DecoderConfig decoderConfig, SessionConfig sessionConfig, ObjectMapperConfig objectMapperConfig, ConnectionConfig connectionConfig, JsonPathConfig jsonPathConfig) {
        AssertParameter.notNull((Object)redirectConfig, (String)"Redirect Config");
        AssertParameter.notNull((Object)httpClientConfig, (String)"HTTP Client Config");
        AssertParameter.notNull((Object)logConfig, (String)"Log config");
        AssertParameter.notNull((Object)encoderConfig, (String)"Encoder config");
        AssertParameter.notNull((Object)decoderConfig, (String)"Decoder config");
        AssertParameter.notNull((Object)sessionConfig, (String)"Session config");
        AssertParameter.notNull((Object)objectMapperConfig, (String)"Object mapper config");
        AssertParameter.notNull((Object)connectionConfig, (String)"Connection config");
        AssertParameter.notNull((Object)jsonPathConfig, (String)"JsonPath config");
        this.httpClientConfig = httpClientConfig;
        this.redirectConfig = redirectConfig;
        this.logConfig = logConfig;
        this.encoderConfig = encoderConfig;
        this.decoderConfig = decoderConfig;
        this.sessionConfig = sessionConfig;
        this.objectMapperConfig = objectMapperConfig;
        this.connectionConfig = connectionConfig;
        this.jsonPathConfig = jsonPathConfig;
    }

    public RestAssuredConfig redirect(RedirectConfig redirectConfig) {
        AssertParameter.notNull((Object)redirectConfig, (String)"Redirect config");
        return new RestAssuredConfig(redirectConfig, this.httpClientConfig, this.logConfig, this.encoderConfig, this.decoderConfig, this.sessionConfig, this.objectMapperConfig, this.connectionConfig, this.jsonPathConfig);
    }

    public RestAssuredConfig httpClient(HttpClientConfig httpClientConfig) {
        AssertParameter.notNull((Object)httpClientConfig, (String)"HTTP Client Config");
        return new RestAssuredConfig(this.redirectConfig, httpClientConfig, this.logConfig, this.encoderConfig, this.decoderConfig, this.sessionConfig, this.objectMapperConfig, this.connectionConfig, this.jsonPathConfig);
    }

    public RestAssuredConfig logConfig(LogConfig logConfig) {
        AssertParameter.notNull((Object)logConfig, (String)"Log config");
        return new RestAssuredConfig(this.redirectConfig, this.httpClientConfig, logConfig, this.encoderConfig, this.decoderConfig, this.sessionConfig, this.objectMapperConfig, this.connectionConfig, this.jsonPathConfig);
    }

    public RestAssuredConfig encoderConfig(EncoderConfig encoderConfig) {
        AssertParameter.notNull((Object)encoderConfig, (String)"Encoder config");
        return new RestAssuredConfig(this.redirectConfig, this.httpClientConfig, this.logConfig, encoderConfig, this.decoderConfig, this.sessionConfig, this.objectMapperConfig, this.connectionConfig, this.jsonPathConfig);
    }

    public RestAssuredConfig decoderConfig(DecoderConfig decoderConfig) {
        AssertParameter.notNull((Object)decoderConfig, (String)"Decoder config");
        return new RestAssuredConfig(this.redirectConfig, this.httpClientConfig, this.logConfig, this.encoderConfig, decoderConfig, this.sessionConfig, this.objectMapperConfig, this.connectionConfig, this.jsonPathConfig);
    }

    public RestAssuredConfig sessionConfig(SessionConfig sessionConfig) {
        AssertParameter.notNull((Object)sessionConfig, (String)"Session config");
        return new RestAssuredConfig(this.redirectConfig, this.httpClientConfig, this.logConfig, this.encoderConfig, this.decoderConfig, sessionConfig, this.objectMapperConfig, this.connectionConfig, this.jsonPathConfig);
    }

    public RestAssuredConfig objectMapperConfig(ObjectMapperConfig objectMapperConfig) {
        AssertParameter.notNull((Object)objectMapperConfig, (String)"Object mapper config");
        return new RestAssuredConfig(this.redirectConfig, this.httpClientConfig, this.logConfig, this.encoderConfig, this.decoderConfig, this.sessionConfig, objectMapperConfig, this.connectionConfig, this.jsonPathConfig);
    }

    public RestAssuredConfig connectionConfig(ConnectionConfig connectionConfig) {
        AssertParameter.notNull((Object)connectionConfig, (String)"Connection config");
        return new RestAssuredConfig(this.redirectConfig, this.httpClientConfig, this.logConfig, this.encoderConfig, this.decoderConfig, this.sessionConfig, this.objectMapperConfig, connectionConfig, this.jsonPathConfig);
    }

    public RestAssuredConfig jsonPathConfig(JsonPathConfig jsonPathConfig) {
        AssertParameter.notNull((Object)jsonPathConfig, (String)"JsonPath config");
        return new RestAssuredConfig(this.redirectConfig, this.httpClientConfig, this.logConfig, this.encoderConfig, this.decoderConfig, this.sessionConfig, this.objectMapperConfig, this.connectionConfig, jsonPathConfig);
    }

    public RestAssuredConfig and() {
        return this;
    }

    public RestAssuredConfig set() {
        return this;
    }

    public RedirectConfig getRedirectConfig() {
        return this.redirectConfig;
    }

    public LogConfig getLogConfig() {
        return this.logConfig;
    }

    public HttpClientConfig getHttpClientConfig() {
        return this.httpClientConfig;
    }

    public EncoderConfig getEncoderConfig() {
        return this.encoderConfig;
    }

    public DecoderConfig getDecoderConfig() {
        return this.decoderConfig;
    }

    public SessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    public ObjectMapperConfig getObjectMapperConfig() {
        return this.objectMapperConfig;
    }

    public ConnectionConfig getConnectionConfig() {
        return this.connectionConfig;
    }

    public JsonPathConfig getJsonPathConfig() {
        return this.jsonPathConfig;
    }

    public static RestAssuredConfig newConfig() {
        return new RestAssuredConfig();
    }

    public static RestAssuredConfig config() {
        return new RestAssuredConfig();
    }
}

