/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.metrics.internal.cloudwatch.spi;

import com.amazonaws.metrics.internal.cloudwatch.spi.RequestMetricTransformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AWSMetricTransformerFactory {
    DynamoDB;

    private static final String REQUEST_TRANSFORMER_CLASSNAME_SUFFIX = "RequestMetricTransformer";
    private static final String METRIC_TRANSFORM_PROVIDER_PACKAGE = "com.amazonaws.metrics.internal.cloudwatch.provider.transform";
    private final RequestMetricTransformer reqTransformer = this.loadRequestMetricTransformer(AWSMetricTransformerFactory.buildRequestMetricTransformerFQCN(this.name()));

    public static String buildRequestMetricTransformerFQCN(String awsPrefix) {
        return "com.amazonaws.metrics.internal.cloudwatch.provider.transform." + awsPrefix + REQUEST_TRANSFORMER_CLASSNAME_SUFFIX;
    }

    private RequestMetricTransformer loadRequestMetricTransformer(String className) {
        Log log = LogFactory.getLog(AWSMetricTransformerFactory.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading " + className));
        }
        try {
            Class<?> c = Class.forName(className);
            return (RequestMetricTransformer)c.newInstance();
        }
        catch (Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed to load " + className + "; therefore ignoring " + this.name() + " specific predefined metrics"), e);
            }
            return RequestMetricTransformer.NONE;
        }
    }

    public RequestMetricTransformer getRequestMetricTransformer() {
        return this.reqTransformer;
    }
}

