/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.transform.AbstractErrorUnmarshaller;
import com.amazonaws.util.json.JSONException;
import com.amazonaws.util.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonErrorUnmarshaller
extends AbstractErrorUnmarshaller<JSONObject> {
    public JsonErrorUnmarshaller() {
    }

    protected JsonErrorUnmarshaller(Class<? extends AmazonServiceException> exceptionClass) {
        super(exceptionClass);
    }

    @Override
    public AmazonServiceException unmarshall(JSONObject json) throws Exception {
        String message = this.parseMessage(json);
        String errorCode = this.parseErrorCode(json);
        if ((null == message || message.isEmpty()) && (null == errorCode || errorCode.isEmpty())) {
            throw new AmazonClientException("Neither error message nor error code is found in the error response payload.");
        }
        AmazonServiceException ase = this.newException(message);
        ase.setErrorCode(errorCode);
        return ase;
    }

    public String parseMessage(JSONObject json) throws Exception {
        return this.parseMember("message", json);
    }

    public String parseMember(String key, JSONObject json) throws JSONException {
        if (key == null || key.length() == 0) {
            return null;
        }
        String firstLetterLowercaseKey = key.substring(0, 1).toLowerCase() + key.substring(1);
        String firstLetterUppercaseKey = key.substring(0, 1).toUpperCase() + key.substring(1);
        String value = "";
        if (json.has(firstLetterUppercaseKey)) {
            value = json.getString(firstLetterUppercaseKey);
        } else if (json.has(firstLetterLowercaseKey)) {
            value = json.getString(firstLetterLowercaseKey);
        }
        return value;
    }

    public String parseErrorCode(JSONObject json) throws Exception {
        if (json.has("__type")) {
            String type = json.getString("__type");
            int separator = type.lastIndexOf("#");
            return type.substring(separator + 1);
        }
        return null;
    }
}

