/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.transform;

import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListUnmarshaller<T>
implements Unmarshaller<List<T>, JsonUnmarshallerContext> {
    private final Unmarshaller<T, JsonUnmarshallerContext> itemUnmarshaller;

    public ListUnmarshaller(Unmarshaller<T, JsonUnmarshallerContext> itemUnmarshaller) {
        this.itemUnmarshaller = itemUnmarshaller;
    }

    @Override
    public List<T> unmarshall(JsonUnmarshallerContext context) throws Exception {
        ArrayList<T> list = new ArrayList<T>();
        int originalDepth = context.getCurrentDepth();
        JsonToken firstToken = context.peek();
        if (firstToken == JsonToken.VALUE_NULL) {
            return null;
        }
        JsonToken token;
        while ((token = context.nextToken()) != null) {
            if (token == JsonToken.START_ARRAY) continue;
            if (token == JsonToken.END_ARRAY || token == JsonToken.END_OBJECT) {
                if (context.getCurrentDepth() >= originalDepth) continue;
                return list;
            }
            list.add(this.itemUnmarshaller.unmarshall(context));
        }
        return list;
    }
}

