/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.server;

import com.amazonaws.services.dynamodbv2.local.mapper.DynamoDBObjectMapper;
import com.amazonaws.services.dynamodbv2.local.server.DynamoDBRequestHandler;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jetty.server.handler.AbstractHandler;

public abstract class AbstractLocalDynamoDBServerHandler
extends AbstractHandler {
    static Logger logger = Logger.getLogger(AbstractLocalDynamoDBServerHandler.class);
    protected DynamoDBObjectMapper jsonMapper = new DynamoDBObjectMapper();
    protected DynamoDBRequestHandler primaryHandler;
    protected Map<String, DynamoDBRequestHandler> secondaryHandlers;

    public AbstractLocalDynamoDBServerHandler(DynamoDBRequestHandler pHandler) {
        this.primaryHandler = pHandler;
        this.secondaryHandlers = new HashMap<String, DynamoDBRequestHandler>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(String name, DynamoDBRequestHandler handler) {
        Map<String, DynamoDBRequestHandler> map = this.secondaryHandlers;
        synchronized (map) {
            if (this.secondaryHandlers.containsKey(name)) {
                throw new IllegalArgumentException(String.valueOf(name) + " is already in use.");
            }
            this.secondaryHandlers.put(name, handler);
        }
    }

    public AbstractLocalDynamoDBServerHandler withHandler(String name, DynamoDBRequestHandler handler) {
        this.secondaryHandlers.put(name, handler);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamoDBRequestHandler removeHandler(String name) {
        Map<String, DynamoDBRequestHandler> map = this.secondaryHandlers;
        synchronized (map) {
            return this.secondaryHandlers.remove(name);
        }
    }

    public void close() {
        try {
            this.primaryHandler.shutdown();
        }
        catch (Exception e) {
            logger.error((Object)"Primary handler shutdown gave an Exception.", (Throwable)e);
        }
        for (DynamoDBRequestHandler h : this.secondaryHandlers.values()) {
            try {
                h.shutdown();
            }
            catch (Exception e) {
                logger.error((Object)"Secondary handler shutdown gave an Exception.", (Throwable)e);
            }
        }
    }
}

