/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.serverRunner;

import com.amazonaws.services.dynamodbv2.local.server.DynamoDBProxyServer;
import java.io.File;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ServerRunner {
    public static final int DEFAULT_PORT = 8000;
    public static final String PORT_OPTION = "port";
    public static final String IN_MEMORY_OPTION = "inMemory";
    public static final String DB_FILE_PATH_OPTION = "dbPath";
    public static final String HELP_OPTION = "help";
    public static final String PORT_OPTION_ARG = "port-no.";
    public static final String DB_FILE_PATH_OPTION_ARG = "path";
    public static final String PORT_OPTION_DESC = "Specify a port number. Default is 8000";
    public static final String IN_MEMORY_OPTION_DESC = "When specified, DynamoDB Local will run in memory.";
    public static final String DB_FILE_PATH_OPTION_DESC = "Specify the location of your database file. Default is the current directory.";
    public static final String HELP_OPTION_DESC = "Display DynamoDB Local usage and options.";
    public static final String INVALID_PORT_ERR = "Invalid Port. Port number must lie between 1 and 65535.";
    public static final String DB_PATH_IN_MEMORY_CONFLICT_ERR = "dbPath and inMemory cannot be set at the same time.";
    public static final String INVALID_DIRECTORY_ERR = "Invalid directory for database creation.";
    public static final String PARSING_ERR = "Error while parsing options.";
    public static final String DDB_LOCAL_USAGE_STRING = "java -Djava.library.path=./DynamoDBLocal_lib -jar DynamoDBLocal.jar [-port <port-no.>] [-inMemory] [-dbPath <path>]";

    public static void main(String[] args) throws Exception {
        File dbFileDir;
        CommandLine cmd;
        Options cliOptions = new Options();
        Option portOption = new Option(PORT_OPTION, PORT_OPTION_DESC);
        portOption.setArgName(PORT_OPTION_ARG);
        portOption.setArgs(1);
        portOption.setRequired(false);
        cliOptions.addOption(portOption);
        Option dbFilePathOption = new Option(DB_FILE_PATH_OPTION, DB_FILE_PATH_OPTION_DESC);
        dbFilePathOption.setArgName(DB_FILE_PATH_OPTION_ARG);
        dbFilePathOption.setArgs(1);
        dbFilePathOption.setRequired(false);
        cliOptions.addOption(dbFilePathOption);
        Option inMemoryOption = new Option(IN_MEMORY_OPTION, IN_MEMORY_OPTION_DESC);
        inMemoryOption.setArgs(0);
        inMemoryOption.setRequired(false);
        cliOptions.addOption(inMemoryOption);
        Option helpOption = new Option(HELP_OPTION, HELP_OPTION_DESC);
        helpOption.setArgs(0);
        helpOption.setRequired(false);
        cliOptions.addOption(helpOption);
        BasicParser parser = new BasicParser();
        try {
            cmd = parser.parse(cliOptions, args);
        }
        catch (ParseException pe) {
            System.err.println("Error while parsing options. " + pe.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(DDB_LOCAL_USAGE_STRING, cliOptions);
            return;
        }
        if (cmd.hasOption(HELP_OPTION)) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(DDB_LOCAL_USAGE_STRING, cliOptions);
            return;
        }
        String portStr = null;
        portStr = cmd.getOptionValue(PORT_OPTION);
        int port = 8000;
        if (portStr != null) {
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException nfe) {
                System.err.print(INVALID_PORT_ERR);
                return;
            }
        }
        if (port <= 0 || port > 65535) {
            System.err.print(INVALID_PORT_ERR);
            return;
        }
        boolean inMemory = cmd.hasOption(IN_MEMORY_OPTION);
        String dbPath = cmd.getOptionValue(DB_FILE_PATH_OPTION);
        if (inMemory && dbPath != null) {
            System.err.print(DB_PATH_IN_MEMORY_CONFLICT_ERR);
            return;
        }
        if (dbPath != null && !(dbFileDir = new File(dbPath)).isDirectory()) {
            System.err.print(INVALID_DIRECTORY_ERR);
            return;
        }
        DynamoDBProxyServer server = inMemory ? new DynamoDBProxyServer(port, inMemory) : (dbPath != null ? new DynamoDBProxyServer(port, dbPath) : new DynamoDBProxyServer(port));
        server.start();
    }
}

