/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.shared.access.sqlite;

import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteJob;
import com.almworks.sqlite4java.SQLiteQueue;
import com.almworks.sqlite4java.SQLiteStatement;
import com.amazonaws.services.dynamodbv2.exceptions.AWSExceptionFactory;
import com.amazonaws.services.dynamodbv2.exceptions.AmazonServiceExceptionType;
import com.amazonaws.services.dynamodbv2.local.shared.access.ListTablesResultInfo;
import com.amazonaws.services.dynamodbv2.local.shared.access.LocalDBAccess;
import com.amazonaws.services.dynamodbv2.local.shared.access.LocalDBUtils;
import com.amazonaws.services.dynamodbv2.local.shared.access.PaddingNumberEncoder;
import com.amazonaws.services.dynamodbv2.local.shared.access.QueryResultInfo;
import com.amazonaws.services.dynamodbv2.local.shared.access.TableInfo;
import com.amazonaws.services.dynamodbv2.local.shared.access.sqlite.SQLiteDBAccessJob;
import com.amazonaws.services.dynamodbv2.local.shared.access.sqlite.SQLiteIndexElement;
import com.amazonaws.services.dynamodbv2.local.shared.access.sqlite.TableSchemaInfo;
import com.amazonaws.services.dynamodbv2.local.shared.exceptions.LocalDBAccessException;
import com.amazonaws.services.dynamodbv2.local.shared.exceptions.LocalDBAccessExceptionType;
import com.amazonaws.services.dynamodbv2.local.shared.exceptions.LocalDBClientExceptionMessage;
import com.amazonaws.services.dynamodbv2.local.shared.mapper.DynamoDBObjectMapper;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

public class SQLiteDBAccess
implements LocalDBAccess {
    public static final String HASH_VALUE_COLUMN_NAME = "hashValue";
    public static final String RANGE_VALUE_COLUMN_NAME = "rangeValue";
    public static final String HASH_RANGE_VALUE_COLUMN_NAME = "hashRangeValue";
    public static final String HASH_KEY_COLUMN_NAME = "hashKey";
    public static final String RANGE_KEY_COLUMN_NAME = "rangeKey";
    public static final String INDEX_KEY_COLUMN_NAME = "indexKey_";
    public static final String ITEM_SIZE_COLUMN_NAME = "itemSize";
    public static final String OBJECT_COLUMN_NAME = "ObjectJSON";
    public static final String PRIMARY_KEY_INDEX_NAME = "";
    public static final String CONFIG_TABLE = "cf";
    public static final String CONFIG_VERSION_COLUMN_NAME = "version";
    public static final String CURRENT_VERSION = "v2";
    public static final String METADATA_TABLE_NAME = "dm";
    public static final String TABLE_NAME = "TableName";
    public static final String CREATION_DATE_TIME = "CreationDateTime";
    public static final String LAST_DECREASE_DATE = "LastDecreaseDate";
    public static final String LAST_INCREASE_DATE = "LastIncreaseDate";
    public static final String NUM_DECREASES_TODAY = "NumberOfDecreasesToday";
    public static final String READ_CAPACITY_UNITS = "ReadCapacityUnits";
    public static final String WRITE_CAPACITY_UNITS = "WriteCapacityUnits";
    public static final String TABLE_INFO = "TableInfo";
    private static Logger logger = Logger.getLogger(SQLiteDBAccess.class);
    private ConcurrentHashMap<String, ReadWriteLock> rowLockTable = new ConcurrentHashMap();
    private static final String INDEX_DELIMITER = "*";
    private static final String HASH_VALUE_INDEX_NAME_PREFIX = "*HVI";
    private static Set<File> openedFiles = new HashSet<File>();
    private final File databaseFile;
    private final SQLiteQueue queue;
    private static final DynamoDBObjectMapper MAPPER = new DynamoDBObjectMapper();

    public SQLiteDBAccess() {
        this((File)null);
    }

    public SQLiteDBAccess(String pathToFile) {
        this(new File(pathToFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLiteDBAccess(File databaseFile) {
        this.databaseFile = databaseFile;
        Set<File> set = openedFiles;
        synchronized (set) {
            if (openedFiles.contains(this.databaseFile)) {
                throw new IllegalArgumentException("Database specified by path already in use.");
            }
            openedFiles.add(this.databaseFile);
        }
        LocalDBUtils.setLog4jToUtilsLogging("com.almworks.sqlite4java");
        LocalDBUtils.setLog4jToUtilsLogging("com.almworks.sqlite4java.Internal");
        this.queue = new SQLiteQueue(this.databaseFile);
        this.queue.start();
        final AtomicBoolean isErr = new AtomicBoolean(false);
        (this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<Void>(){

            @Override
            public Void doWork() throws SQLiteException {
                String configSQL;
                SQLiteStatement configStatement;
                boolean mdExists = false;
                boolean cfgExists = false;
                String metadataSQL = "SELECT name FROM sqlite_master WHERE type='table' AND name='dm';";
                SQLiteStatement mdStatement = this.getPreparedStatement(metadataSQL);
                if (mdStatement.step()) {
                    mdExists = true;
                }
                if ((configStatement = this.getPreparedStatement(configSQL = "SELECT name FROM sqlite_master WHERE type='table' AND name='cf';")).step()) {
                    cfgExists = true;
                }
                if (mdExists && !cfgExists || cfgExists && !mdExists) {
                    isErr.set(true);
                    return null;
                }
                if (!cfgExists) {
                    String configTableCreationSQL = "CREATE TABLE IF NOT EXISTS cf (version TEXT);";
                    this.getPreparedStatement(configTableCreationSQL).step();
                    String insertSQL = "INSERT INTO cf VALUES('v2');";
                    this.getPreparedStatement(insertSQL).step();
                } else {
                    String getVersionSQL = "SELECT version FROM cf";
                    SQLiteStatement statement = this.getPreparedStatement(getVersionSQL);
                    if (!statement.step() || !statement.columnString(0).equals(SQLiteDBAccess.CURRENT_VERSION)) {
                        isErr.set(true);
                        return null;
                    }
                }
                if (!mdExists) {
                    String metadataTableCreationSQL = "CREATE TABLE IF NOT EXISTS dm (TableName TEXT, CreationDateTime INTEGER, LastDecreaseDate INTEGER, LastIncreaseDate INTEGER, NumberOfDecreasesToday INTEGER, ReadCapacityUnits INTEGER, WriteCapacityUnits INTEGER, TableInfo BLOB, PRIMARY KEY(TableName));";
                    this.getPreparedStatement(metadataTableCreationSQL).step();
                }
                return null;
            }
        })).get();
        if (isErr.get()) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.STALE_DATABASE.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.queue.stop(true);
        Set<File> set = openedFiles;
        synchronized (set) {
            openedFiles.remove(this.databaseFile);
        }
    }

    @Override
    public void createTable(final String tableName, AttributeDefinition hashKey, AttributeDefinition rangeKey, List<AttributeDefinition> allAttributes, List<LocalSecondaryIndex> lsiIndexes, List<GlobalSecondaryIndex> gsiIndexes, final ProvisionedThroughput throughput) {
        final TableSchemaInfo tableSchema = new TableSchemaInfo(hashKey, rangeKey, allAttributes, lsiIndexes, gsiIndexes);
        StringBuilder sqlBuilder = new StringBuilder("CREATE TABLE IF NOT EXISTS " + SQLiteDBAccess.escapedTableName(tableName) + " (");
        List<SQLiteIndexElement> uniqueRangeKeyIndexes = tableSchema.getUniqueIndexes();
        List<List<SQLiteIndexElement>> uniqueGSIIndexes = tableSchema.getUniqueGSIIndexes();
        final ArrayList<String> secondaryIndexCreationSQL = new ArrayList<String>();
        int count = 0;
        HashSet<String> columnsAdded = new HashSet<String>();
        for (SQLiteIndexElement sQLiteIndexElement : uniqueRangeKeyIndexes) {
            sqlBuilder.append(String.valueOf(sQLiteIndexElement.getSqliteColumnName()) + " " + sQLiteIndexElement.getSqliteDataType().getSQLiteType() + " DEFAULT NULL, ");
            columnsAdded.add(sQLiteIndexElement.getSqliteColumnName());
            if (sQLiteIndexElement.getSqliteColumnName().equals(HASH_KEY_COLUMN_NAME) || sQLiteIndexElement.getSqliteColumnName().equals(RANGE_KEY_COLUMN_NAME)) continue;
            secondaryIndexCreationSQL.add("CREATE INDEX " + SQLiteDBAccess.escapedTableName(String.valueOf(tableName) + INDEX_DELIMITER + count) + " ON " + SQLiteDBAccess.escapedTableName(tableName) + " (" + HASH_KEY_COLUMN_NAME + ", " + sQLiteIndexElement.getSqliteColumnName() + ", " + RANGE_VALUE_COLUMN_NAME + ");");
            logger.debug(secondaryIndexCreationSQL.get(count));
            ++count;
        }
        if (uniqueGSIIndexes != null) {
            for (List list : uniqueGSIIndexes) {
                String trailingHashColName;
                for (SQLiteIndexElement indexElement : list) {
                    if (columnsAdded.contains(indexElement.getSqliteColumnName())) continue;
                    sqlBuilder.append(String.valueOf(indexElement.getSqliteColumnName()) + " " + indexElement.getSqliteDataType().getSQLiteType() + " DEFAULT NULL, ");
                    columnsAdded.add(indexElement.getSqliteColumnName());
                }
                StringBuilder indexStr = new StringBuilder("CREATE INDEX " + SQLiteDBAccess.escapedTableName(String.valueOf(tableName) + INDEX_DELIMITER + count) + " ON " + SQLiteDBAccess.escapedTableName(tableName) + " (" + ((SQLiteIndexElement)list.get(0)).getSqliteColumnName());
                if (list.size() == 2) {
                    indexStr.append(", " + ((SQLiteIndexElement)list.get(1)).getSqliteColumnName());
                }
                if ((trailingHashColName = this.getTrailingHashColumnName(rangeKey, list)) != null) {
                    indexStr.append(", " + trailingHashColName);
                }
                indexStr.append(");");
                secondaryIndexCreationSQL.add(indexStr.toString());
                logger.debug(secondaryIndexCreationSQL.get(count));
                ++count;
            }
        }
        secondaryIndexCreationSQL.add("CREATE INDEX " + SQLiteDBAccess.escapedTableName(String.valueOf(tableName) + HASH_VALUE_INDEX_NAME_PREFIX) + " ON " + SQLiteDBAccess.escapedTableName(tableName) + " (" + HASH_VALUE_COLUMN_NAME + ");");
        logger.debug((Object)("Index on Hash Value: " + (String)secondaryIndexCreationSQL.get(count)));
        sqlBuilder.append("hashValue BLOB NOT NULL, ");
        if (rangeKey != null) {
            sqlBuilder.append("rangeValue BLOB NOT NULL, ");
            if (gsiIndexes != null) {
                sqlBuilder.append("hashRangeValue BLOB NOT NULL, ");
            }
        }
        sqlBuilder.append("itemSize INTEGER DEFAULT 0, ObjectJSON BLOB NOT NULL, ");
        sqlBuilder.append("PRIMARY KEY(" + tableSchema.getHashKeyIndex().getSqliteColumnName());
        if (rangeKey != null) {
            sqlBuilder.append(", " + tableSchema.getRangeKeyIndex().getSqliteColumnName());
        }
        sqlBuilder.append("));");
        final String string = sqlBuilder.toString();
        logger.debug((Object)string);
        final String metadataUpdateSQL = String.format("INSERT INTO \"%s\" (\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\") VALUES (?,?,?,?,?,?,?,?)", METADATA_TABLE_NAME, TABLE_NAME, CREATION_DATE_TIME, LAST_DECREASE_DATE, LAST_INCREASE_DATE, NUM_DECREASES_TODAY, READ_CAPACITY_UNITS, WRITE_CAPACITY_UNITS, TABLE_INFO);
        logger.debug((Object)metadataUpdateSQL);
        (this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<Void>(){

            @Override
            public Void doWork() throws SQLiteException, JsonProcessingException {
                this.getPreparedStatement(string).step();
                for (String sql : secondaryIndexCreationSQL) {
                    this.getPreparedStatement(sql).step();
                }
                this.getPreparedStatement(metadataUpdateSQL).bind(1, tableName).bind(2, System.currentTimeMillis()).bind(3, 0).bind(4, 0).bind(5, 0).bind(6, throughput.getReadCapacityUnits().longValue()).bind(7, throughput.getWriteCapacityUnits().longValue()).bind(8, MAPPER.writeValueAsBytes(tableSchema)).step();
                return null;
            }
        })).get();
    }

    private String getTrailingHashColumnName(AttributeDefinition rangeKey, List<SQLiteIndexElement> indexElementList) {
        HashSet<String> indexAttributes = new HashSet<String>();
        for (SQLiteIndexElement indexElement : indexElementList) {
            indexAttributes.add(indexElement.getSqliteColumnName());
        }
        String orderByColName = null;
        if (indexAttributes.contains(HASH_KEY_COLUMN_NAME)) {
            if (rangeKey != null && !indexAttributes.contains(RANGE_KEY_COLUMN_NAME)) {
                orderByColName = RANGE_VALUE_COLUMN_NAME;
            }
        } else {
            orderByColName = rangeKey != null ? (!indexAttributes.contains(RANGE_KEY_COLUMN_NAME) ? HASH_RANGE_VALUE_COLUMN_NAME : HASH_VALUE_COLUMN_NAME) : HASH_VALUE_COLUMN_NAME;
        }
        return orderByColName;
    }

    @Override
    public void deleteTable(String tableName) {
        final String dropTableSQL = "DROP TABLE " + SQLiteDBAccess.escapedTableName(tableName) + ";";
        logger.debug((Object)dropTableSQL);
        final String updateMetadataSQL = "DELETE FROM dm WHERE TableName = " + SQLiteDBAccess.escapedTableName(tableName) + ";";
        logger.debug((Object)updateMetadataSQL);
        (this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<Void>(){

            @Override
            public Void doWork() throws SQLiteException {
                this.getPreparedStatement(dropTableSQL).step();
                this.getPreparedStatement(updateMetadataSQL).step();
                return null;
            }
        })).get();
    }

    @Override
    public void updateTable(final String tableName, final ProvisionedThroughput provisionedThroughput, TableInfo info, List<GlobalSecondaryIndex> gsiList) {
        final TableSchemaInfo tableSchema = this.getTableSchemaInfo(tableName);
        tableSchema.setGsiList(gsiList);
        final String updateMetadataSQL = String.format("UPDATE %s SET %s=?, %s=?, %s=? WHERE %s=?;", METADATA_TABLE_NAME, READ_CAPACITY_UNITS, WRITE_CAPACITY_UNITS, TABLE_INFO, TABLE_NAME);
        (this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<Void>(){

            @Override
            public Void doWork() throws SQLiteException, JsonProcessingException {
                this.getPreparedStatement(updateMetadataSQL).bind(1, provisionedThroughput.getReadCapacityUnits().longValue()).bind(2, provisionedThroughput.getWriteCapacityUnits().longValue()).bind(3, MAPPER.writeValueAsBytes(tableSchema)).bind(4, tableName).step();
                return null;
            }
        })).get();
    }

    @Override
    public Map<String, AttributeValue> getRecord(final String tableName, final Map<String, AttributeValue> primaryKey) {
        return (Map)(this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<Map<String, AttributeValue>>(){

            @Override
            public Map<String, AttributeValue> doWork() throws SQLiteException, JsonParseException, JsonMappingException, IOException {
                Map ret = null;
                TableSchemaInfo tableSchema = this.getTableSchemaInfo(tableName);
                List<SQLiteIndexElement> relevantIndexes = tableSchema.getSqliteIndex().get(SQLiteDBAccess.PRIMARY_KEY_INDEX_NAME);
                StringBuilder sql = new StringBuilder(String.format("SELECT %s FROM %s WHERE ", SQLiteDBAccess.OBJECT_COLUMN_NAME, SQLiteDBAccess.escapedTableName(tableName)));
                sql.append(SQLiteDBAccess.this.constructIndexWhereClause(relevantIndexes));
                sql.append(";");
                logger.debug((Object)sql.toString());
                SQLiteStatement statement = this.getPreparedStatement(sql.toString());
                SQLiteDBAccess.this.applyKeyBinds(statement, relevantIndexes, primaryKey);
                if (statement.step()) {
                    ret = (Map)MAPPER.readValue(statement.columnBlob(0), DynamoDBObjectMapper.ITEM_TYPE);
                }
                if (statement.step()) {
                    LocalDBUtils.ldAccessFail(LocalDBAccessExceptionType.DATA_CORRUPTION, "Given key conditions were not unique. Returned: [%s] and [%s].", ret.toString(), MAPPER.readValue(statement.columnBlob(0), DynamoDBObjectMapper.ITEM_TYPE).toString());
                }
                return ret;
            }
        })).get();
    }

    @Override
    public boolean deleteRecord(final String tableName, final Map<String, AttributeValue> primaryKey) {
        Map<String, AttributeValue> record = this.getRecord(tableName, primaryKey);
        if (record == null) {
            return false;
        }
        (this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<Void>(){

            @Override
            public Void doWork() throws JsonParseException, JsonMappingException, SQLiteException, IOException {
                TableSchemaInfo tableSchema = this.getTableSchemaInfo(tableName);
                List<SQLiteIndexElement> relevantIndexes = tableSchema.getSqliteIndex().get(SQLiteDBAccess.PRIMARY_KEY_INDEX_NAME);
                StringBuilder sql = new StringBuilder(String.format("DELETE FROM %s WHERE ", SQLiteDBAccess.escapedTableName(tableName)));
                sql.append(SQLiteDBAccess.this.constructIndexWhereClause(relevantIndexes));
                sql.append(";");
                logger.debug((Object)sql.toString());
                SQLiteStatement statement = this.getPreparedStatement(sql.toString());
                SQLiteDBAccess.this.applyKeyBinds(statement, relevantIndexes, primaryKey);
                statement.step();
                return null;
            }
        })).get();
        return true;
    }

    @Override
    public void putRecord(final String tableName, final Map<String, AttributeValue> record, final AttributeValue hashKey, final AttributeValue rangeKey) {
        (this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<Void>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public Void doWork() throws SQLiteException, JsonParseException, JsonMappingException, IOException {
                void var6_13;
                void var6_12;
                void var6_9;
                TableSchemaInfo tableSchema = this.getTableSchemaInfo(tableName);
                StringBuilder sql = new StringBuilder(String.format("INSERT OR REPLACE INTO %s (", SQLiteDBAccess.escapedTableName(tableName)));
                List<SQLiteIndexElement> uniqueTableIndexes = tableSchema.getUniqueIndexes();
                ArrayList<Object> attributesToBind = new ArrayList<Object>();
                for (SQLiteIndexElement indexElement : uniqueTableIndexes) {
                    String attributeName = indexElement.getDynamoDBAttribute().getAttributeName();
                    if (record.get(attributeName) == null) continue;
                    if (attributesToBind.size() > 0) {
                        sql.append(", ");
                    }
                    attributesToBind.add(attributeName);
                    sql.append(indexElement.getSqliteColumnName());
                }
                if (tableSchema.getGsiList() != null) {
                    List<List<SQLiteIndexElement>> uniqueGSITableIndexes = tableSchema.getUniqueGSIIndexes();
                    for (List list : uniqueGSITableIndexes) {
                        for (SQLiteIndexElement indexElement : list) {
                            String attributeName = indexElement.getDynamoDBAttribute().getAttributeName();
                            if (record.get(attributeName) == null || attributesToBind.contains(attributeName)) continue;
                            if (attributesToBind.size() > 0) {
                                sql.append(", ");
                            }
                            attributesToBind.add(attributeName);
                            sql.append(indexElement.getSqliteColumnName());
                        }
                    }
                }
                if (rangeKey != null) {
                    sql.append(", rangeValue");
                    if (tableSchema.getGsiList() != null) {
                        sql.append(", hashRangeValue");
                    }
                }
                sql.append(", hashValue, itemSize, ObjectJSON) VALUES (");
                int i = 0;
                while (i < attributesToBind.size()) {
                    if (i > 0) {
                        sql.append(", ");
                    }
                    sql.append("?");
                    ++i;
                }
                if (rangeKey != null) {
                    sql.append(", ?");
                    if (tableSchema.getGsiList() != null) {
                        sql.append(", ?");
                    }
                }
                sql.append(", ?, ?, ?);");
                logger.debug((Object)sql.toString());
                SQLiteStatement statement = this.getPreparedStatement(sql.toString());
                boolean bl = false;
                while (var6_9 < attributesToBind.size()) {
                    byte[] value = SQLiteDBAccess.this.translateKeyAttributeValue((AttributeValue)record.get(attributesToBind.get((int)var6_9)));
                    statement.bind((int)(var6_9 + true), value);
                    ++var6_9;
                }
                if (rangeKey != null) {
                    void var6_10;
                    statement.bind((int)(++var6_10), LocalDBUtils.getHashValue(rangeKey));
                    if (tableSchema.getGsiList() != null) {
                        void var6_11;
                        statement.bind((int)(++var6_11), LocalDBUtils.getHashValue(hashKey, rangeKey));
                    }
                }
                statement.bind((int)(++var6_12), LocalDBUtils.getHashValue(hashKey));
                statement.bind((int)(++var6_13), LocalDBUtils.getItemSizeBytes(record));
                statement.bind((int)(var6_13 + true), MAPPER.writeValueAsBytes(record));
                sql.append(";");
                statement.step();
                return null;
            }
        })).get();
    }

    @Override
    public QueryResultInfo queryRecords(final String tableName, final String indexName, final Map<String, Condition> conditions, final Map<String, AttributeValue> exclusiveStartKey, final Long limit, Map<String, Condition> segmentCondition, final boolean ascending, final byte[] beginHash, final byte[] endHash, final boolean isScan, final boolean isGSIIndex) {
        return (QueryResultInfo)(this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<QueryResultInfo>(){

            @Override
            public QueryResultInfo doWork() throws JsonParseException, JsonMappingException, IOException, SQLiteException {
                String querySQL;
                String nestedQuerySQL;
                String index = indexName == null ? SQLiteDBAccess.PRIMARY_KEY_INDEX_NAME : indexName;
                TableSchemaInfo tableSchema = this.getTableSchemaInfo(tableName);
                List<SQLiteIndexElement> indexes = tableSchema.getSqliteIndex().get(index);
                StringBuilder indexColumns = new StringBuilder(SQLiteDBAccess.PRIMARY_KEY_INDEX_NAME);
                StringBuilder orderByCols = new StringBuilder(SQLiteDBAccess.PRIMARY_KEY_INDEX_NAME);
                String orderString = ascending ? "ASC" : "DESC";
                StringBuilder indexColumnsNotNullClause = new StringBuilder(SQLiteDBAccess.PRIMARY_KEY_INDEX_NAME);
                StringBuilder indexConditionsWhereClause = new StringBuilder(SQLiteDBAccess.PRIMARY_KEY_INDEX_NAME);
                ArrayList<byte[]> indexConditionsBinds = new ArrayList<byte[]>();
                boolean conditionAdded = false;
                int i = 0;
                while (i < indexes.size()) {
                    Condition condition;
                    SQLiteIndexElement element = indexes.get(i);
                    String columnName = element.getSqliteColumnName();
                    if (i > 0) {
                        indexColumns.append(", ");
                        orderByCols.append(", ");
                        indexColumnsNotNullClause.append(" AND ");
                    }
                    indexColumns.append(columnName);
                    orderByCols.append(String.valueOf(columnName) + " " + orderString);
                    indexColumnsNotNullClause.append(String.format("%s IS NOT NULL", columnName));
                    if (conditions != null && (condition = (Condition)conditions.get(element.getDynamoDBAttribute().getAttributeName())) != null) {
                        if (conditionAdded && i > 0) {
                            indexConditionsWhereClause.append(" AND ");
                            conditionAdded = false;
                        }
                        ComparisonOperator comparisonOperator = ComparisonOperator.fromValue((String)condition.getComparisonOperator());
                        StringBuilder operatorClause = new StringBuilder(columnName);
                        byte[] data = SQLiteDBAccess.this.translateKeyAttributeValue((AttributeValue)condition.getAttributeValueList().get(0));
                        switch (comparisonOperator) {
                            case EQ: {
                                operatorClause.append(" = ?");
                                break;
                            }
                            case LT: {
                                operatorClause.append(" < ?");
                                break;
                            }
                            case GT: {
                                operatorClause.append(" > ?");
                                break;
                            }
                            case LE: {
                                operatorClause.append(" <= ?");
                                break;
                            }
                            case GE: {
                                operatorClause.append(" >= ?");
                                break;
                            }
                            case BEGINS_WITH: {
                                operatorClause.append(" LIKE ?");
                                data = Arrays.copyOf(data, data.length + 1);
                                data[data.length - 1] = 37;
                                break;
                            }
                            case BETWEEN: {
                                operatorClause.append(" BETWEEN ? AND ?");
                                indexConditionsBinds.add(data);
                                data = SQLiteDBAccess.this.translateKeyAttributeValue((AttributeValue)condition.getAttributeValueList().get(1));
                                break;
                            }
                            default: {
                                throw new LocalDBAccessException(LocalDBAccessExceptionType.VALIDATION_EXCEPTION, "Unsupported comparison operator for query: " + comparisonOperator.toString());
                            }
                        }
                        if (indexConditionsWhereClause.length() == 0) {
                            indexConditionsWhereClause = new StringBuilder("WHERE ");
                        }
                        indexConditionsWhereClause.append((CharSequence)operatorClause);
                        indexConditionsBinds.add(data);
                        conditionAdded = true;
                    }
                    ++i;
                }
                String trailingHashColName = null;
                if (indexName != null && !isGSIIndex) {
                    indexColumns.append(", rangeValue");
                    orderByCols.append(", rangeValue " + orderString);
                } else if (isGSIIndex && (trailingHashColName = SQLiteDBAccess.this.getTrailingHashColumnName(tableSchema.getRangeKeyDefinition(), tableSchema.getSqliteIndex().get(indexName))) != null) {
                    indexColumns.append(", " + trailingHashColName);
                    orderByCols.append(", " + trailingHashColName + " " + orderString);
                }
                String indexColumnsAndObjectData = "ObjectJSON, " + indexColumns;
                StringBuilder exclusiveStartKeyClause = new StringBuilder(SQLiteDBAccess.PRIMARY_KEY_INDEX_NAME);
                ArrayList<byte[]> exclusiveStartKeyBinds = new ArrayList<byte[]>();
                if (exclusiveStartKey != null) {
                    AttributeDefinition rangeKeyDef;
                    if (!isScan) {
                        String direction = ascending ? ">" : "<";
                        AttributeDefinition hashKeyDef = tableSchema.getHashKeyDefinition();
                        if (indexName == null || !isGSIIndex) {
                            exclusiveStartKeyClause.append(String.format("AND (%s %s ?", SQLiteDBAccess.HASH_KEY_COLUMN_NAME, direction));
                            exclusiveStartKeyBinds.add(SQLiteDBAccess.this.translateKeyAttributeValue((AttributeValue)exclusiveStartKey.get(hashKeyDef.getAttributeName())));
                        }
                        rangeKeyDef = tableSchema.getRangeKeyDefinition();
                        if (indexName == null) {
                            if (rangeKeyDef != null) {
                                exclusiveStartKeyClause.append(String.format(" OR (%s = ? AND %s %s ?)", SQLiteDBAccess.HASH_KEY_COLUMN_NAME, SQLiteDBAccess.RANGE_KEY_COLUMN_NAME, direction));
                                exclusiveStartKeyBinds.add(SQLiteDBAccess.this.translateKeyAttributeValue((AttributeValue)exclusiveStartKey.get(hashKeyDef.getAttributeName())));
                                exclusiveStartKeyBinds.add(SQLiteDBAccess.this.translateKeyAttributeValue((AttributeValue)exclusiveStartKey.get(rangeKeyDef.getAttributeName())));
                            }
                        } else if (!isGSIIndex) {
                            String indexKeyName = tableSchema.getLSIRangeIndexElement(indexName).getSqliteColumnName();
                            String indexKeyDynamoDBName = SQLiteDBAccess.this.getLSIIndexKeyDynamoDBName(tableSchema, indexName);
                            exclusiveStartKeyClause.append(String.format(" OR (%s = ? AND %s %s ?)", SQLiteDBAccess.HASH_KEY_COLUMN_NAME, indexKeyName, direction));
                            exclusiveStartKeyBinds.add(SQLiteDBAccess.this.translateKeyAttributeValue((AttributeValue)exclusiveStartKey.get(hashKeyDef.getAttributeName())));
                            exclusiveStartKeyBinds.add(SQLiteDBAccess.this.translateKeyAttributeValue((AttributeValue)exclusiveStartKey.get(indexKeyDynamoDBName)));
                            exclusiveStartKeyClause.append(String.format(" OR (%s = ? AND %s = ? AND %s %s ?)", SQLiteDBAccess.HASH_KEY_COLUMN_NAME, indexKeyName, SQLiteDBAccess.RANGE_VALUE_COLUMN_NAME, direction));
                            exclusiveStartKeyBinds.add(SQLiteDBAccess.this.translateKeyAttributeValue((AttributeValue)exclusiveStartKey.get(hashKeyDef.getAttributeName())));
                            exclusiveStartKeyBinds.add(SQLiteDBAccess.this.translateKeyAttributeValue((AttributeValue)exclusiveStartKey.get(indexKeyDynamoDBName)));
                            exclusiveStartKeyBinds.add(LocalDBUtils.getHashValue((AttributeValue)exclusiveStartKey.get(rangeKeyDef.getAttributeName())));
                        } else {
                            byte[] trailHash = null;
                            if (trailingHashColName != null) {
                                trailHash = trailingHashColName.equals(SQLiteDBAccess.HASH_VALUE_COLUMN_NAME) ? LocalDBUtils.getHashValue((AttributeValue)exclusiveStartKey.get(hashKeyDef.getAttributeName())) : (trailingHashColName.equals(SQLiteDBAccess.RANGE_VALUE_COLUMN_NAME) ? LocalDBUtils.getHashValue((AttributeValue)exclusiveStartKey.get(rangeKeyDef.getAttributeName())) : LocalDBUtils.getHashValue((AttributeValue)exclusiveStartKey.get(hashKeyDef.getAttributeName()), (AttributeValue)exclusiveStartKey.get(rangeKeyDef.getAttributeName())));
                            }
                            String gsiHashKey = tableSchema.getGSIHashIndexElement(indexName).getSqliteColumnName();
                            String gsiHashKeyDynamoDBName = SQLiteDBAccess.this.getGSIKeyDynamoDBName(tableSchema, indexName, KeyType.HASH.toString());
                            exclusiveStartKeyClause.append(String.format(" AND (%s %s ?", gsiHashKey, direction));
                            exclusiveStartKeyBinds.add(SQLiteDBAccess.this.translateKeyAttributeValue((AttributeValue)exclusiveStartKey.get(gsiHashKeyDynamoDBName)));
                            String gsiRangeKey = null;
                            String gsiRangeKeyDynamoDBName = null;
                            if (tableSchema.getGSIRangeIndexElement(indexName) != null) {
                                gsiRangeKey = tableSchema.getGSIRangeIndexElement(indexName).getSqliteColumnName();
                                gsiRangeKeyDynamoDBName = SQLiteDBAccess.this.getGSIKeyDynamoDBName(tableSchema, indexName, KeyType.RANGE.toString());
                                exclusiveStartKeyClause.append(String.format(" OR (%s = ? AND %s %s ?)", gsiHashKey, gsiRangeKey, direction));
                                exclusiveStartKeyBinds.add(SQLiteDBAccess.this.translateKeyAttributeValue((AttributeValue)exclusiveStartKey.get(gsiHashKeyDynamoDBName)));
                                exclusiveStartKeyBinds.add(SQLiteDBAccess.this.translateKeyAttributeValue((AttributeValue)exclusiveStartKey.get(gsiRangeKeyDynamoDBName)));
                                if (trailingHashColName != null) {
                                    exclusiveStartKeyClause.append(String.format(" OR (%s = ? AND %s = ? AND %s %s ?)", gsiHashKey, gsiRangeKey, trailingHashColName, direction));
                                    exclusiveStartKeyBinds.add(SQLiteDBAccess.this.translateKeyAttributeValue((AttributeValue)exclusiveStartKey.get(gsiHashKeyDynamoDBName)));
                                    exclusiveStartKeyBinds.add(SQLiteDBAccess.this.translateKeyAttributeValue((AttributeValue)exclusiveStartKey.get(gsiRangeKeyDynamoDBName)));
                                    exclusiveStartKeyBinds.add(trailHash);
                                }
                            } else if (trailingHashColName != null) {
                                exclusiveStartKeyClause.append(String.format(" OR (%s = ? AND %s %s ?)", gsiHashKey, trailingHashColName, direction));
                                exclusiveStartKeyBinds.add(SQLiteDBAccess.this.translateKeyAttributeValue((AttributeValue)exclusiveStartKey.get(gsiHashKeyDynamoDBName)));
                                exclusiveStartKeyBinds.add(trailHash);
                            }
                        }
                    } else {
                        AttributeDefinition hashKeyDef = tableSchema.getHashKeyDefinition();
                        String direction = ">";
                        exclusiveStartKeyClause.append(String.format("AND (%s %s ?", SQLiteDBAccess.HASH_VALUE_COLUMN_NAME, direction));
                        exclusiveStartKeyBinds.add(LocalDBUtils.getHashValue((AttributeValue)exclusiveStartKey.get(hashKeyDef.getAttributeName())));
                        rangeKeyDef = tableSchema.getRangeKeyDefinition();
                        if (rangeKeyDef != null) {
                            exclusiveStartKeyClause.append(String.format(" OR (%s = ? AND %s %s ?)", SQLiteDBAccess.HASH_VALUE_COLUMN_NAME, SQLiteDBAccess.RANGE_KEY_COLUMN_NAME, direction));
                            exclusiveStartKeyBinds.add(LocalDBUtils.getHashValue((AttributeValue)exclusiveStartKey.get(hashKeyDef.getAttributeName())));
                            exclusiveStartKeyBinds.add(SQLiteDBAccess.this.translateKeyAttributeValue((AttributeValue)exclusiveStartKey.get(rangeKeyDef.getAttributeName())));
                        }
                    }
                    exclusiveStartKeyClause.append(")");
                }
                if (!isScan) {
                    nestedQuerySQL = String.format("SELECT %s FROM %s WHERE %s %s ORDER BY %s ", indexColumnsAndObjectData, SQLiteDBAccess.escapedTableName(tableName), indexColumnsNotNullClause.toString(), exclusiveStartKeyClause.toString(), orderByCols);
                    querySQL = String.format("SELECT %s FROM (%s) %s ORDER BY %s LIMIT ?;", SQLiteDBAccess.OBJECT_COLUMN_NAME, nestedQuerySQL, indexConditionsWhereClause.toString(), orderByCols);
                } else {
                    String segmentSQL;
                    String rangeKeyColName;
                    String string = rangeKeyColName = tableSchema.getRangeKeyDefinition() == null ? SQLiteDBAccess.PRIMARY_KEY_INDEX_NAME : " , rangeKey";
                    if (beginHash != null) {
                        StringBuilder segmentWhereClause = new StringBuilder(SQLiteDBAccess.PRIMARY_KEY_INDEX_NAME);
                        segmentWhereClause.append("hashValue >= ? AND hashValue <= ?");
                        segmentSQL = String.format("SELECT %s FROM %s WHERE %s ORDER BY %s %s", "hashValue, " + indexColumnsAndObjectData, SQLiteDBAccess.escapedTableName(tableName), segmentWhereClause.toString(), SQLiteDBAccess.HASH_VALUE_COLUMN_NAME, rangeKeyColName);
                    } else {
                        segmentSQL = String.format("SELECT %s FROM %s ORDER BY %s %s", "hashValue, " + indexColumnsAndObjectData, SQLiteDBAccess.escapedTableName(tableName), SQLiteDBAccess.HASH_VALUE_COLUMN_NAME, rangeKeyColName);
                    }
                    nestedQuerySQL = String.format("SELECT %s FROM (%s) WHERE %s %s", indexColumnsAndObjectData, segmentSQL, indexColumnsNotNullClause.toString(), exclusiveStartKeyClause.toString());
                    querySQL = String.format("SELECT %s FROM (%s) %s LIMIT ?;", SQLiteDBAccess.OBJECT_COLUMN_NAME, nestedQuerySQL, indexConditionsWhereClause.toString());
                    logger.debug((Object)("Segment SQL: " + nestedQuerySQL));
                }
                logger.debug((Object)("nested: " + nestedQuerySQL));
                logger.debug((Object)("queryS: " + querySQL));
                SQLiteStatement statement = this.getPreparedStatement(querySQL);
                int i2 = 1;
                if (beginHash != null) {
                    statement.bind(i2, beginHash);
                    statement.bind(++i2, endHash);
                    ++i2;
                }
                i2 = SQLiteDBAccess.this.applyBinds(statement, i2, exclusiveStartKeyBinds);
                i2 = SQLiteDBAccess.this.applyBinds(statement, i2, indexConditionsBinds);
                long lim = limit == null ? -1L : limit;
                statement.bind(i2, lim);
                logger.debug((Object)("\tbinding " + i2 + ":\t" + lim));
                ++i2;
                ArrayList<Map<String, AttributeValue>> ret = new ArrayList<Map<String, AttributeValue>>();
                while (statement.step()) {
                    Map record = (Map)MAPPER.readValue(statement.columnBlob(0), DynamoDBObjectMapper.ITEM_TYPE);
                    logger.debug((Object)("queryRecords: " + record.toString()));
                    ret.add(record);
                }
                Map lastEvaluatedItem = null;
                if (lim > 0L && (long)ret.size() == lim) {
                    lastEvaluatedItem = (Map)ret.get(ret.size() - 1);
                }
                return new QueryResultInfo(ret, lastEvaluatedItem);
            }
        })).get();
    }

    @Override
    public long getTableItemCount(final String tableName) {
        return (Long)(this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<Long>(){

            @Override
            public Long doWork() throws SQLiteException {
                String tableSizeSQL = "SELECT COUNT(1) FROM " + SQLiteDBAccess.escapedTableName(tableName) + ";";
                SQLiteStatement statement = this.getPreparedStatement(tableSizeSQL);
                statement.step();
                return statement.columnLong(0);
            }
        })).get();
    }

    @Override
    public long getLSIItemCount(final String tableName, final String indexName) {
        return (Long)(this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<Long>(){

            @Override
            public Long doWork() throws JsonParseException, JsonMappingException, SQLiteException, IOException {
                TableSchemaInfo tableSchema = this.getTableSchemaInfo(tableName);
                String columnName = tableSchema.getLSIRangeIndexElement(indexName).getSqliteColumnName();
                String tableSizeSQL = "SELECT COUNT(" + columnName + ") FROM " + SQLiteDBAccess.escapedTableName(tableName) + ";";
                SQLiteStatement statement = this.getPreparedStatement(tableSizeSQL);
                statement.step();
                return statement.columnLong(0);
            }
        })).get();
    }

    @Override
    public long getGSIItemCount(final String tableName, final String indexName) {
        return (Long)(this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<Long>(){

            @Override
            public Long doWork() throws JsonParseException, JsonMappingException, SQLiteException, IOException {
                TableSchemaInfo tableSchema = this.getTableSchemaInfo(tableName);
                String columnName = tableSchema.getGSIHashIndexElement(indexName).getSqliteColumnName();
                String tableSizeSQL = "SELECT COUNT(" + columnName + ") FROM " + SQLiteDBAccess.escapedTableName(tableName) + ";";
                SQLiteStatement statement = this.getPreparedStatement(tableSizeSQL);
                statement.step();
                return statement.columnLong(0);
            }
        })).get();
    }

    @Override
    public TableSchemaInfo getTableSchemaInfo(String tableName) {
        final String metadataSelectSQL = "SELECT TableInfo FROM dm WHERE TableName = " + SQLiteDBAccess.escapedTableName(tableName) + ";";
        logger.debug((Object)metadataSelectSQL);
        return (TableSchemaInfo)(this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<TableSchemaInfo>(){

            @Override
            public TableSchemaInfo doWork() throws SQLiteException, JsonParseException, JsonMappingException, IOException {
                TableSchemaInfo ret = null;
                SQLiteStatement statement = this.getPreparedStatement(metadataSelectSQL);
                if (statement.step()) {
                    ret = (TableSchemaInfo)MAPPER.readValue(statement.columnBlob(0), TableSchemaInfo.class);
                }
                return ret;
            }
        })).get();
    }

    @Override
    public TableInfo getTableInfo(final String tableName) {
        final String metadataSelectSQL = "SELECT CreationDateTime, LastDecreaseDate, LastIncreaseDate, NumberOfDecreasesToday, ReadCapacityUnits, WriteCapacityUnits, TableInfo FROM dm WHERE TableName = " + SQLiteDBAccess.escapedTableName(tableName) + ";";
        logger.debug((Object)metadataSelectSQL);
        return (TableInfo)(this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<TableInfo>(){

            @Override
            public TableInfo doWork() throws SQLiteException, JsonParseException, JsonMappingException, IOException {
                TableInfo ret = null;
                SQLiteStatement statement = this.getPreparedStatement(metadataSelectSQL);
                if (statement.step()) {
                    Long creationDateTime = statement.columnLong(0);
                    Long lastDecreaseDateTime = statement.columnLong(1);
                    Long lastIncreaseDateTime = statement.columnLong(2);
                    Long numDecreasesToday = statement.columnLong(3);
                    Long readCapacityUnits = statement.columnLong(4);
                    Long writeCapacityUnits = statement.columnLong(5);
                    TableSchemaInfo tableSchema = (TableSchemaInfo)MAPPER.readValue(statement.columnBlob(6), TableSchemaInfo.class);
                    ret = new TableInfo(tableName, tableSchema.getHashKeyDefinition(), tableSchema.getRangeKeyDefinition(), tableSchema.getAttributes(), tableSchema.getLsiList(), tableSchema.getGsiList(), new ProvisionedThroughput().withReadCapacityUnits(readCapacityUnits).withWriteCapacityUnits(writeCapacityUnits));
                    ret.setCreationDateTime(creationDateTime);
                }
                return ret;
            }
        })).get();
    }

    @Override
    public ListTablesResultInfo listTables(String exclusiveStartTableName, Long limit) {
        String excStart = exclusiveStartTableName == null ? PRIMARY_KEY_INDEX_NAME : exclusiveStartTableName;
        final long lim = limit == null || limit < 0L ? -1L : limit + 1L;
        final String sql = String.format("SELECT %s FROM %s WHERE %s > %s ORDER BY %s ASC LIMIT %d;", TABLE_NAME, METADATA_TABLE_NAME, TABLE_NAME, SQLiteDBAccess.escapedTableName(excStart), TABLE_NAME, lim);
        logger.debug((Object)sql);
        return (ListTablesResultInfo)(this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<ListTablesResultInfo>(){

            @Override
            protected ListTablesResultInfo doWork() throws Throwable {
                SQLiteStatement statement = this.getPreparedStatement(sql);
                ArrayList<String> ret = new ArrayList<String>();
                while (statement.step()) {
                    ret.add(statement.columnString(0));
                }
                String lastEvaluatedTableName = null;
                if (lim > 0L && (long)ret.size() == lim) {
                    ret.remove(ret.size() - 1);
                    lastEvaluatedTableName = (String)ret.get(ret.size() - 1);
                }
                return new ListTablesResultInfo(ret, lastEvaluatedTableName);
            }
        })).get();
    }

    @Override
    public long getTableByteSize(String tableName) {
        final String sql = String.format("SELECT SUM(%s) FROM %s;", ITEM_SIZE_COLUMN_NAME, SQLiteDBAccess.escapedTableName(tableName));
        return (Long)(this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<Long>(){

            @Override
            protected Long doWork() throws Throwable {
                SQLiteStatement statement = this.getPreparedStatement(sql);
                statement.step();
                return statement.columnLong(0);
            }
        })).get();
    }

    @Override
    public long getLSIByteSize(final String tableName, final String indexName) {
        return (Long)(this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<Long>(){

            @Override
            protected Long doWork() throws Throwable {
                TableSchemaInfo tableSchema = this.getTableSchemaInfo(tableName);
                String indexColumnName = tableSchema.getLSIRangeIndexElement(indexName).getSqliteColumnName();
                String sql = String.format("SELECT SUM(%s) FROM %s WHERE %s IS NOT NULL;", SQLiteDBAccess.ITEM_SIZE_COLUMN_NAME, SQLiteDBAccess.escapedTableName(tableName), indexColumnName);
                SQLiteStatement statement = this.getPreparedStatement(sql);
                statement.step();
                return statement.columnLong(0);
            }
        })).get();
    }

    @Override
    public long getGSIByteSize(final String tableName, final String indexName) {
        return (Long)(this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<Long>(){

            @Override
            protected Long doWork() throws Throwable {
                TableSchemaInfo tableSchema = this.getTableSchemaInfo(tableName);
                String hashColumnName = tableSchema.getGSIHashIndexElement(indexName).getSqliteColumnName();
                String sql = null;
                if (tableSchema.getGSIRangeIndexElement(indexName) != null) {
                    String rangeColumnName = tableSchema.getGSIRangeIndexElement(indexName).getSqliteColumnName();
                    sql = String.format("SELECT SUM(%s) FROM %s WHERE %s IS NOT NULL OR %s IS NOT NULL;", SQLiteDBAccess.ITEM_SIZE_COLUMN_NAME, SQLiteDBAccess.escapedTableName(tableName), hashColumnName, rangeColumnName);
                } else {
                    sql = String.format("SELECT SUM(%s) FROM %s WHERE %s IS NOT NULL;", SQLiteDBAccess.ITEM_SIZE_COLUMN_NAME, SQLiteDBAccess.escapedTableName(tableName), hashColumnName);
                }
                SQLiteStatement statement = this.getPreparedStatement(sql);
                statement.step();
                return statement.columnLong(0);
            }
        })).get();
    }

    @Override
    public synchronized ReadWriteLock getLockForTable(String tableName) {
        ReadWriteLock lock = this.rowLockTable.get(tableName);
        if (lock == null) {
            lock = new ReentrantReadWriteLock();
            this.rowLockTable.put(tableName, lock);
        }
        return lock;
    }

    public static String escapedTableName(String s) {
        return "\"" + s + "\"";
    }

    private byte[] translateKeyAttributeValue(AttributeValue attributeValue) {
        if (attributeValue.getB() != null) {
            return attributeValue.getB().array();
        }
        if (attributeValue.getN() != null) {
            return PaddingNumberEncoder.encodeBigDecimal(new BigDecimal(attributeValue.getN()));
        }
        if (attributeValue.getS() != null) {
            return attributeValue.getS().getBytes(LocalDBUtils.UTF8);
        }
        throw new IllegalArgumentException("Unknown AttributeValue type: " + attributeValue.toString());
    }

    private String constructIndexWhereClause(List<SQLiteIndexElement> indexes) {
        StringBuilder ret = new StringBuilder();
        int i = 0;
        while (i < indexes.size()) {
            ret.append(String.valueOf(indexes.get(i).getSqliteColumnName()) + " = ?");
            if (i < indexes.size() - 1) {
                ret.append(" AND ");
            }
            ++i;
        }
        return ret.toString();
    }

    private void applyKeyBinds(SQLiteStatement statement, List<SQLiteIndexElement> indexElements, Map<String, AttributeValue> key) throws SQLiteException {
        int i = 0;
        while (i < indexElements.size()) {
            String attributeName = indexElements.get(i).getDynamoDBAttribute().getAttributeName();
            byte[] value = this.translateKeyAttributeValue(key.get(attributeName));
            statement.bind(i + 1, value);
            ++i;
        }
    }

    private String getLSIIndexKeyDynamoDBName(TableSchemaInfo tableSchema, String indexName) {
        List<LocalSecondaryIndex> lsiList = tableSchema.getLsiList();
        for (LocalSecondaryIndex lsi : lsiList) {
            if (!lsi.getIndexName().equals(indexName)) continue;
            List keySchema = lsi.getKeySchema();
            for (KeySchemaElement kse : keySchema) {
                if (!kse.getKeyType().equals(KeyType.RANGE.toString())) continue;
                return kse.getAttributeName();
            }
        }
        return null;
    }

    private String getGSIKeyDynamoDBName(TableSchemaInfo tableSchema, String indexName, String keyType) {
        List<GlobalSecondaryIndex> gsiList = tableSchema.getGsiList();
        for (GlobalSecondaryIndex gsi : gsiList) {
            if (!gsi.getIndexName().equals(indexName)) continue;
            List keySchema = gsi.getKeySchema();
            for (KeySchemaElement kse : keySchema) {
                if (!kse.getKeyType().equals(keyType)) continue;
                return kse.getAttributeName();
            }
        }
        return null;
    }

    protected int applyBinds(SQLiteStatement statement, int startBind, List<byte[]> bindData) throws SQLiteException {
        int endBind = startBind;
        LocalDBUtils.ldAccessAssertTrue(startBind > 0, LocalDBAccessExceptionType.UNEXPECTED_EXCEPTION, "SQL construction issue, binding at location 0.", new Object[0]);
        LocalDBUtils.ldAccessAssertTrue(endBind + bindData.size() - 1 <= statement.getBindParameterCount(), LocalDBAccessExceptionType.UNEXPECTED_EXCEPTION, "SQL construction issue, invalid number of binds.", new Object[0]);
        int j = 0;
        while (j < bindData.size()) {
            statement.bind(endBind, bindData.get(j));
            ++j;
            ++endBind;
        }
        return endBind;
    }
}

