/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

public class PropertyName {
    public static final PropertyName USE_DEFAULT = new PropertyName("", null);
    public static final PropertyName NO_NAME = new PropertyName(new String("#disabled"), null);
    protected final String _simpleName;
    protected final String _namespace;

    public PropertyName(String simpleName) {
        this(simpleName, null);
    }

    public PropertyName(String simpleName, String namespace) {
        this._simpleName = simpleName == null ? "" : simpleName;
        this._namespace = namespace;
    }

    public static PropertyName construct(String simpleName, String ns) {
        if (simpleName == null) {
            simpleName = "";
        }
        if (ns == null && simpleName.length() == 0) {
            return USE_DEFAULT;
        }
        return new PropertyName(simpleName, ns);
    }

    public PropertyName withSimpleName(String simpleName) {
        if (simpleName == null) {
            simpleName = "";
        }
        if (simpleName.equals(this._simpleName)) {
            return this;
        }
        return new PropertyName(simpleName, this._namespace);
    }

    public PropertyName withNamespace(String ns) {
        if (ns == null ? this._namespace == null : ns.equals(this._namespace)) {
            return this;
        }
        return new PropertyName(this._simpleName, ns);
    }

    public String getSimpleName() {
        return this._simpleName;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public boolean hasSimpleName() {
        return this._simpleName.length() > 0;
    }

    public boolean hasNamespace() {
        return this._namespace != null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != PropertyName.class) {
            return false;
        }
        if (USE_DEFAULT == o) {
            return this == USE_DEFAULT;
        }
        PropertyName other = this;
        if (this._simpleName == null ? other._simpleName != null : !this._simpleName.equals(other._simpleName)) {
            return false;
        }
        if (this._namespace == null) {
            return null == other._namespace;
        }
        return this._namespace.equals(other._namespace);
    }

    public int hashCode() {
        if (this._namespace == null) {
            return this._simpleName.hashCode();
        }
        return this._namespace.hashCode() ^ this._simpleName.hashCode();
    }

    public String toString() {
        if (this._namespace == null) {
            return this._simpleName;
        }
        return "{" + this._namespace + "}" + this._simpleName;
    }
}

