/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.generator;

import java.nio.ByteBuffer;
import org.eclipse.jetty.spdy.ByteBufferPool;
import org.eclipse.jetty.spdy.SessionException;
import org.eclipse.jetty.spdy.api.SessionStatus;
import org.eclipse.jetty.spdy.frames.ControlFrame;
import org.eclipse.jetty.spdy.frames.SynReplyFrame;
import org.eclipse.jetty.spdy.generator.ControlFrameGenerator;
import org.eclipse.jetty.spdy.generator.HeadersBlockGenerator;

public class SynReplyGenerator
extends ControlFrameGenerator {
    private final HeadersBlockGenerator headersBlockGenerator;

    public SynReplyGenerator(ByteBufferPool bufferPool, HeadersBlockGenerator headersBlockGenerator) {
        super(bufferPool);
        this.headersBlockGenerator = headersBlockGenerator;
    }

    @Override
    public ByteBuffer generate(ControlFrame frame) {
        SynReplyFrame synReply = (SynReplyFrame)frame;
        short version = synReply.getVersion();
        ByteBuffer headersBuffer = this.headersBlockGenerator.generate(version, synReply.getHeaders());
        int frameBodyLength = this.getFrameDataLength(version);
        int frameLength = frameBodyLength + headersBuffer.remaining();
        if (frameLength > 0xFFFFFF) {
            throw new SessionException(SessionStatus.PROTOCOL_ERROR, "Too many headers");
        }
        int totalLength = 8 + frameLength;
        ByteBuffer buffer = this.getByteBufferPool().acquire(totalLength, true);
        this.generateControlFrameHeader(synReply, frameLength, buffer);
        buffer.putInt(synReply.getStreamId() & Integer.MAX_VALUE);
        this.writeAdditional(version, buffer);
        buffer.put(headersBuffer);
        buffer.flip();
        return buffer;
    }

    private int getFrameDataLength(short version) {
        switch (version) {
            case 2: {
                return 6;
            }
            case 3: {
                return 4;
            }
        }
        throw new IllegalStateException();
    }

    private void writeAdditional(short version, ByteBuffer buffer) {
        switch (version) {
            case 2: {
                buffer.putShort((short)0);
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }
}

