/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodel;

import com.amazonaws.services.dynamodbv2.datamodel.DocumentNodeHelper;
import com.amazonaws.services.dynamodbv2.datamodel.DocumentNodeType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public enum TypeSet {
    STRING_BINARY_NUMBER(DocumentNodeType.STRING, DocumentNodeType.NUMBER, DocumentNodeType.BINARY),
    ATOM_TYPES(DocumentNodeType.STRING, DocumentNodeType.NUMBER, DocumentNodeType.BINARY, DocumentNodeType.STRING_SET, DocumentNodeType.NUMBER_SET, DocumentNodeType.BINARY_SET, DocumentNodeType.NULL, DocumentNodeType.BOOLEAN),
    ALL_TYPES(DocumentNodeType.STRING, DocumentNodeType.NUMBER, DocumentNodeType.BINARY, DocumentNodeType.STRING_SET, DocumentNodeType.NUMBER_SET, DocumentNodeType.BINARY_SET, DocumentNodeType.NULL, DocumentNodeType.BOOLEAN, DocumentNodeType.LIST, DocumentNodeType.MAP),
    STRING_BINARY(DocumentNodeType.STRING, DocumentNodeType.BINARY),
    NUMBER(DocumentNodeType.NUMBER),
    BOOLEAN(DocumentNodeType.BOOLEAN),
    LIST(DocumentNodeType.LIST),
    SET_NUMBER(DocumentNodeType.NUMBER, DocumentNodeType.STRING_SET, DocumentNodeType.NUMBER_SET, DocumentNodeType.BINARY_SET),
    SET(DocumentNodeType.STRING_SET, DocumentNodeType.NUMBER_SET, DocumentNodeType.BINARY_SET),
    ITERABLE(DocumentNodeType.STRING, DocumentNodeType.BINARY, DocumentNodeType.STRING_SET, DocumentNodeType.NUMBER_SET, DocumentNodeType.BINARY_SET, DocumentNodeType.LIST, DocumentNodeType.MAP);

    private final Collection<DocumentNodeType> resultingTypes;
    private final String symbolStr;
    private final Set<String> symbolSet;

    private TypeSet(DocumentNodeType ... types) {
        this.resultingTypes = Collections.unmodifiableSet(new HashSet<DocumentNodeType>(Arrays.asList(types)));
        this.symbolStr = DocumentNodeHelper.createTypeSymbolsString(this.resultingTypes);
        this.symbolSet = DocumentNodeHelper.createTypeSymbolsSet(this.resultingTypes);
    }

    public String getSymbolStr() {
        return this.symbolStr;
    }

    public Set<String> getSymbolSet() {
        return this.symbolSet;
    }

    public boolean contains(DocumentNodeType type) {
        return this.resultingTypes.contains((Object)type);
    }

    public boolean containsAny(TypeSet typeSet) {
        return !Collections.disjoint(this.resultingTypes, typeSet.getDocumentNodeTypes());
    }

    public Collection<DocumentNodeType> getDocumentNodeTypes() {
        return this.resultingTypes;
    }
}

