/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.embedded;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.local.embedded.DDBExceptionMappingInvocationHandler;
import com.amazonaws.services.dynamodbv2.local.shared.access.LocalDBClient;
import com.amazonaws.services.dynamodbv2.local.shared.access.sqlite.SQLiteDBAccess;
import com.amazonaws.services.dynamodbv2.local.shared.jobs.JobsRegister;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class DynamoDBEmbedded {
    public static final String SQLITE4JAVA_PKG = "com.almworks.sqlite4java";

    private static void silenceLog(String path) {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        AbstractConfiguration configuration = (AbstractConfiguration)context.getConfiguration();
        if (configuration.getLogger(path) != null) {
            LoggerConfig config = configuration.getLoggerConfig(path);
            config.setLevel(Level.OFF);
        } else {
            LoggerConfig config = new LoggerConfig(path, Level.OFF, true);
            configuration.addLogger(path, config);
        }
        context.updateLoggers((Configuration)configuration);
    }

    public static AmazonDynamoDB create() {
        return DynamoDBEmbedded.create(null);
    }

    public static AmazonDynamoDB create(File file) {
        JobsRegister jobs = new JobsRegister(Executors.newFixedThreadPool(10), false);
        DynamoDBEmbedded.silenceLog("com.amazonaws.services.dynamodbv2.local");
        LocalDBClient impl = new LocalDBClient(file == null ? new SQLiteDBAccess() : new SQLiteDBAccess(file), jobs);
        return (AmazonDynamoDB)Proxy.newProxyInstance(AmazonDynamoDB.class.getClassLoader(), new Class[]{AmazonDynamoDB.class}, (InvocationHandler)new DDBExceptionMappingInvocationHandler(impl));
    }

    static {
        Logger.getLogger(SQLITE4JAVA_PKG).setLevel(java.util.logging.Level.OFF);
    }
}

