/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.shared.access.sqlite;

import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteJob;
import com.almworks.sqlite4java.SQLiteQueue;
import com.almworks.sqlite4java.SQLiteStatement;
import com.amazonaws.services.dynamodbv2.exceptions.AWSExceptionFactory;
import com.amazonaws.services.dynamodbv2.exceptions.AmazonServiceExceptionType;
import com.amazonaws.services.dynamodbv2.exceptions.DynamoDBLocalServiceException;
import com.amazonaws.services.dynamodbv2.local.shared.access.ListTablesResultInfo;
import com.amazonaws.services.dynamodbv2.local.shared.access.LocalDBAccess;
import com.amazonaws.services.dynamodbv2.local.shared.access.LocalDBUtils;
import com.amazonaws.services.dynamodbv2.local.shared.access.PaddingNumberEncoder;
import com.amazonaws.services.dynamodbv2.local.shared.access.QueryResultInfo;
import com.amazonaws.services.dynamodbv2.local.shared.access.TableInfo;
import com.amazonaws.services.dynamodbv2.local.shared.access.sqlite.AmazonDynamoDBOfflineSQLiteJob;
import com.amazonaws.services.dynamodbv2.local.shared.access.sqlite.SQLiteDBAccessJob;
import com.amazonaws.services.dynamodbv2.local.shared.access.sqlite.SQLiteDBAccessUtils;
import com.amazonaws.services.dynamodbv2.local.shared.access.sqlite.SQLiteIndexElement;
import com.amazonaws.services.dynamodbv2.local.shared.access.sqlite.TableSchemaInfo;
import com.amazonaws.services.dynamodbv2.local.shared.exceptions.LocalDBAccessException;
import com.amazonaws.services.dynamodbv2.local.shared.exceptions.LocalDBAccessExceptionType;
import com.amazonaws.services.dynamodbv2.local.shared.exceptions.LocalDBClientExceptionMessage;
import com.amazonaws.services.dynamodbv2.local.shared.mapper.DynamoDBObjectMapper;
import com.amazonaws.services.dynamodbv2.local.shared.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.local.shared.model.Condition;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.IndexStatus;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.util.StringUtils;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SQLiteDBAccess
implements LocalDBAccess {
    public static final String HASH_VALUE_COLUMN_NAME = "hashValue";
    public static final String RANGE_VALUE_COLUMN_NAME = "rangeValue";
    public static final String HASH_RANGE_VALUE_COLUMN_NAME = "hashRangeValue";
    public static final String HASH_KEY_COLUMN_NAME = "hashKey";
    public static final String RANGE_KEY_COLUMN_NAME = "rangeKey";
    public static final String INDEX_KEY_COLUMN_NAME = "indexKey_";
    public static final String INDEX_ATTR_SQLITE_COLUMN_FORMAT = "indexKey_\\d+";
    public static final String ITEM_SIZE_COLUMN_NAME = "itemSize";
    public static final String OBJECT_COLUMN_NAME = "ObjectJSON";
    public static final String PRIMARY_KEY_INDEX_NAME = "";
    public static final String CONFIG_VERSION_COLUMN_NAME = "version";
    public static final String CURRENT_VERSION = "v2.1.1";
    public static final String CONFIG_TABLE = "cf";
    public static final String METADATA_TABLE_NAME = "dm";
    public static final String TABLE_NAME = "TableName";
    public static final String CREATION_DATE_TIME = "CreationDateTime";
    public static final String LAST_DECREASE_DATE = "LastDecreaseDate";
    public static final String LAST_INCREASE_DATE = "LastIncreaseDate";
    public static final String NUM_DECREASES_TODAY = "NumberOfDecreasesToday";
    public static final String READ_CAPACITY_UNITS = "ReadCapacityUnits";
    public static final String WRITE_CAPACITY_UNITS = "WriteCapacityUnits";
    public static final String TABLE_INFO = "TableInfo";
    public static final int VERY_LARGE_NUMBER_SQLITE_COLUMNS = 1000;
    private static final Logger logger = LogManager.getLogger();
    private ConcurrentHashMap<String, ReentrantReadWriteLock> rowLockTable = new ConcurrentHashMap();
    private static final String INDEX_DELIMITER = "*";
    private static final String HASH_VALUE_INDEX_NAME_PREFIX = "*HVI";
    private static Set<File> openedFiles = new HashSet<File>();
    private final File databaseFile;
    protected SQLiteQueue queue;
    private static final DynamoDBObjectMapper MAPPER = new DynamoDBObjectMapper();

    public SQLiteDBAccess() {
        this((File)null);
    }

    public SQLiteDBAccess(String pathToFile) {
        this(new File(pathToFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLiteDBAccess(File databaseFile) {
        this.databaseFile = databaseFile;
        if (this.databaseFile != null) {
            Set<File> set = openedFiles;
            synchronized (set) {
                if (openedFiles.contains(this.databaseFile)) {
                    throw new IllegalArgumentException("Database specified by path already in use: " + this.databaseFile.getAbsolutePath());
                }
                openedFiles.add(this.databaseFile);
            }
        }
        LocalDBUtils.setLog4jToUtilsLogging("com.almworks.sqlite4java");
        LocalDBUtils.setLog4jToUtilsLogging("com.almworks.sqlite4java.Internal");
        this.queue = new SQLiteQueue(this.databaseFile);
        this.queue.start();
        this.initializeMetadataTables();
    }

    protected void initializeMetadataTables() {
        final AtomicBoolean isErr = new AtomicBoolean(false);
        (this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<Void>(){

            @Override
            public Void doWork() throws SQLiteException {
                boolean mdExists;
                boolean cfExists = SQLiteDBAccess.doesTableExist(SQLiteDBAccess.CONFIG_TABLE, this);
                if (cfExists != (mdExists = SQLiteDBAccess.doesTableExist(SQLiteDBAccess.METADATA_TABLE_NAME, this))) {
                    isErr.set(true);
                    return null;
                }
                if (!cfExists) {
                    String configTableCreationSQL = "CREATE TABLE IF NOT EXISTS cf (version TEXT);";
                    this.getPreparedStatement(configTableCreationSQL).step();
                    String insertSQL = "INSERT INTO cf VALUES('v2.1.1');";
                    this.getPreparedStatement(insertSQL).step();
                } else {
                    String getVersionSQL = "SELECT version FROM cf";
                    SQLiteStatement statement = this.getPreparedStatement(getVersionSQL);
                    if (!statement.step() || !statement.columnString(0).equals(SQLiteDBAccess.CURRENT_VERSION)) {
                        isErr.set(true);
                        return null;
                    }
                }
                if (!mdExists) {
                    String metadataTableCreationSQL = "CREATE TABLE IF NOT EXISTS dm (TableName TEXT, CreationDateTime INTEGER, LastDecreaseDate INTEGER, LastIncreaseDate INTEGER, NumberOfDecreasesToday INTEGER, ReadCapacityUnits INTEGER, WriteCapacityUnits INTEGER, TableInfo BLOB, PRIMARY KEY(TableName));";
                    this.getPreparedStatement(metadataTableCreationSQL).step();
                }
                return null;
            }
        })).get();
        if (isErr.get()) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.STALE_DATABASE.getMessage());
        }
    }

    @Override
    public void createTable(final String tableName, AttributeDefinition hashKey, AttributeDefinition baseTableRangeKey, List<AttributeDefinition> allAttributes, List<LocalSecondaryIndex> lsiIndexes, List<GlobalSecondaryIndex> gsiIndexes, final ProvisionedThroughput throughput) {
        List<List<SQLiteIndexElement>> uniqueGSIIndexes;
        final TableSchemaInfo tableSchema = new TableSchemaInfo(hashKey, baseTableRangeKey, allAttributes, lsiIndexes, LocalDBUtils.getGsiDescListFrom(gsiIndexes));
        StringBuilder createTableSQLBuilder = new StringBuilder("CREATE TABLE " + SQLiteDBAccessUtils.escapedTableName(tableName) + " (");
        List<SQLiteIndexElement> uniqueRangeKeyIndexes = tableSchema.getUniqueIndexes();
        final ArrayList<String> secondaryIndexCreationSQL = new ArrayList<String>();
        HashSet<String> columnsAdded = new HashSet<String>();
        for (SQLiteIndexElement indexElement : uniqueRangeKeyIndexes) {
            createTableSQLBuilder.append(indexElement.getSqliteColumnName() + " " + indexElement.getSqliteDataType().getSQLiteType() + " DEFAULT NULL, ");
            columnsAdded.add(indexElement.getSqliteColumnName());
            if (indexElement.getSqliteColumnName().equals(HASH_KEY_COLUMN_NAME) || indexElement.getSqliteColumnName().equals(RANGE_KEY_COLUMN_NAME)) continue;
            String createIndexSQLForLSI = "CREATE INDEX " + SQLiteDBAccess.sqliteIndexNameForLSI(tableName, indexElement.getDynamoDBAttribute().getAttributeName()) + " ON " + SQLiteDBAccess.escapedTableName(tableName) + " (" + HASH_KEY_COLUMN_NAME + ", " + indexElement.getSqliteColumnName() + ", " + RANGE_VALUE_COLUMN_NAME + ");";
            secondaryIndexCreationSQL.add(createIndexSQLForLSI);
            logger.debug(createIndexSQLForLSI);
        }
        createTableSQLBuilder.append("hashValue BLOB NOT NULL, ");
        if (baseTableRangeKey != null) {
            createTableSQLBuilder.append("rangeValue BLOB NOT NULL, ");
        }
        createTableSQLBuilder.append("itemSize INTEGER DEFAULT 0, ObjectJSON BLOB NOT NULL, ");
        createTableSQLBuilder.append("PRIMARY KEY(" + tableSchema.getHashKeyIndex().getSqliteColumnName());
        if (baseTableRangeKey != null) {
            createTableSQLBuilder.append(", " + tableSchema.getRangeKeyIndex().getSqliteColumnName());
        }
        createTableSQLBuilder.append("));");
        final String createTableSQL = createTableSQLBuilder.toString();
        logger.debug(createTableSQL);
        String hashKeyIndexSQL = "CREATE INDEX " + SQLiteDBAccess.escapedTableName(tableName + HASH_VALUE_INDEX_NAME_PREFIX) + " ON " + SQLiteDBAccess.escapedTableName(tableName) + " (" + HASH_VALUE_COLUMN_NAME + ");";
        secondaryIndexCreationSQL.add(hashKeyIndexSQL);
        logger.debug("Index on Hash Value: " + hashKeyIndexSQL);
        boolean baseTableRangeKeyExists = baseTableRangeKey != null;
        final ArrayList<String> sqlStatementsRelatedToGSI = new ArrayList<String>();
        if (tableSchema.getGsiDescList() != null && tableSchema.getGsiDescList().size() > 0 && baseTableRangeKeyExists && !columnsAdded.contains(HASH_RANGE_VALUE_COLUMN_NAME)) {
            sqlStatementsRelatedToGSI.add("ALTER TABLE " + SQLiteDBAccess.escapedTableName(tableName) + " ADD COLUMN " + HASH_RANGE_VALUE_COLUMN_NAME + " BLOB NOT NULL DEFAULT 0;");
            columnsAdded.add(HASH_RANGE_VALUE_COLUMN_NAME);
        }
        if ((uniqueGSIIndexes = tableSchema.getUniqueGSIIndexes()) != null) {
            for (List<SQLiteIndexElement> gsiIndexElements : uniqueGSIIndexes) {
                sqlStatementsRelatedToGSI.addAll(this.buildSQLStatementsForGSI(tableName, this.findMatchingGSIDesc(gsiIndexElements, tableSchema.getGsiDescList()).getIndexName(), columnsAdded, gsiIndexElements, baseTableRangeKeyExists));
            }
        }
        final String metadataUpdateSQL = String.format("INSERT INTO \"%s\" (\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\") VALUES (?,?,?,?,?,?,?,?)", METADATA_TABLE_NAME, TABLE_NAME, CREATION_DATE_TIME, LAST_DECREASE_DATE, LAST_INCREASE_DATE, NUM_DECREASES_TODAY, READ_CAPACITY_UNITS, WRITE_CAPACITY_UNITS, TABLE_INFO);
        logger.debug(metadataUpdateSQL);
        (this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<Void>(){

            @Override
            public Void doWork() throws SQLiteException, IOException {
                long now = System.currentTimeMillis();
                this.getPreparedStatement(createTableSQL).step();
                for (String sql : sqlStatementsRelatedToGSI) {
                    this.getPreparedStatement(sql).step();
                }
                for (String sql : secondaryIndexCreationSQL) {
                    this.getPreparedStatement(sql).step();
                }
                int i = 1;
                this.getPreparedStatement(metadataUpdateSQL).bind(i++, tableName).bind(i++, now).bind(i++, 0).bind(i++, 0).bind(i++, 0).bind(i++, throughput.getReadCapacityUnits().longValue()).bind(i++, throughput.getWriteCapacityUnits().longValue()).bind(i++, MAPPER.writeValueAsBytes(tableSchema)).step();
                return null;
            }
        })).get();
    }

    @Override
    public void createGSIColumns(String tableName, String indexName) {
        TableSchemaInfo tableSchemaInfo = this.getTableSchemaInfo(tableName);
        List<SQLiteIndexElement> gsiIndexElements = tableSchemaInfo.getSqliteIndex().get(indexName);
        if (gsiIndexElements == null) {
            throw new DynamoDBLocalServiceException("Did not find the GSI metadata when attempting to create columns for it");
        }
        Set<String> columnsAdded = this.allSqliteColumnNames(tableName);
        boolean baseTableRangeKeyExists = tableSchemaInfo.getRangeKeyDefinition() != null;
        final ArrayList<String> sqlStatementsForGSI = new ArrayList<String>();
        if (tableSchemaInfo.getGsiDescList().size() > 0 && baseTableRangeKeyExists && !columnsAdded.contains(HASH_RANGE_VALUE_COLUMN_NAME)) {
            sqlStatementsForGSI.add("ALTER TABLE " + SQLiteDBAccess.escapedTableName(tableName) + " ADD COLUMN " + HASH_RANGE_VALUE_COLUMN_NAME + " BLOB NOT NULL DEFAULT 0;");
            columnsAdded.add(HASH_RANGE_VALUE_COLUMN_NAME);
        }
        sqlStatementsForGSI.addAll(this.buildSQLStatementsForGSI(tableName, indexName, columnsAdded, gsiIndexElements, baseTableRangeKeyExists));
        (this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<Void>(){

            @Override
            public Void doWork() throws SQLiteException, JsonProcessingException {
                for (String sql : sqlStatementsForGSI) {
                    this.getPreparedStatement(sql).step();
                }
                return null;
            }
        })).get();
    }

    private GlobalSecondaryIndexDescription findMatchingGSIDesc(List<SQLiteIndexElement> gsiIndexElements, List<GlobalSecondaryIndexDescription> gsiDescList) {
        if (gsiDescList != null) {
            for (GlobalSecondaryIndexDescription desc : gsiDescList) {
                if (!LocalDBUtils.isEqual(desc.getKeySchema(), gsiIndexElements)) continue;
                return desc;
            }
        }
        return null;
    }

    public Set<String> allSqliteColumnNames(final String tableName) {
        return (Set)(this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<Set<String>>(){

            @Override
            public Set<String> doWork() throws SQLiteException, JsonProcessingException {
                HashSet<String> result = new HashSet<String>();
                SQLiteStatement listColumnsStatement = this.getPreparedStatement("PRAGMA table_info(" + SQLiteDBAccess.escapedTableName(tableName) + ")");
                while (listColumnsStatement.step()) {
                    result.add(listColumnsStatement.columnString(1));
                }
                if (result.size() > 1000) {
                    logger.warn("There are large number of sqlite columns representing a DynamoDB table. It is recommended to run optimizeDBBeforeStartup. Please check help command for more information.");
                }
                return result;
            }
        })).get();
    }

    private Set<String> allSqliteColumnNamesRelevant(String tableName) {
        TableSchemaInfo tableSchemaInfo = this.getTableSchemaInfo(tableName);
        HashSet<String> columnsToCopyOver = new HashSet<String>();
        for (Map.Entry<String, List<SQLiteIndexElement>> entry : tableSchemaInfo.getSqliteIndex().entrySet()) {
            for (SQLiteIndexElement element : entry.getValue()) {
                columnsToCopyOver.add(element.getSqliteColumnName());
            }
        }
        boolean doesBaseTableRangeKeyExist = tableSchemaInfo.getRangeKeyDefinition() != null;
        boolean areThereAnyGSIs = tableSchemaInfo.getGsiDescList().size() > 0;
        columnsToCopyOver.add(HASH_VALUE_COLUMN_NAME);
        if (doesBaseTableRangeKeyExist) {
            columnsToCopyOver.add(RANGE_VALUE_COLUMN_NAME);
        }
        columnsToCopyOver.add(ITEM_SIZE_COLUMN_NAME);
        columnsToCopyOver.add(OBJECT_COLUMN_NAME);
        if (doesBaseTableRangeKeyExist && areThereAnyGSIs) {
            columnsToCopyOver.add(HASH_RANGE_VALUE_COLUMN_NAME);
        }
        return columnsToCopyOver;
    }

    private List<String> buildSQLStatementsForGSI(String tableName, String indexName, Set<String> columnsAdded, List<SQLiteIndexElement> gsiIndexElements, boolean baseTableRangeKeyExists) {
        ArrayList<String> sqlStatementsRelatedToThisGSI = new ArrayList<String>();
        for (SQLiteIndexElement gsiIndexElement : gsiIndexElements) {
            if (columnsAdded.contains(gsiIndexElement.getSqliteColumnName())) continue;
            String addColumnSQL = "ALTER TABLE " + SQLiteDBAccess.escapedTableName(tableName) + " ADD COLUMN " + gsiIndexElement.getSqliteColumnName() + " " + gsiIndexElement.getSqliteDataType().getSQLiteType() + " DEFAULT NULL;";
            logger.debug(addColumnSQL);
            sqlStatementsRelatedToThisGSI.add(addColumnSQL);
            columnsAdded.add(gsiIndexElement.getSqliteColumnName());
        }
        String indexSql = this.buildCreateIndexSQLForGSI(tableName, gsiIndexElements, indexName, this.getTrailingHashColumnName(baseTableRangeKeyExists, gsiIndexElements));
        sqlStatementsRelatedToThisGSI.add(indexSql);
        logger.debug(indexSql);
        return sqlStatementsRelatedToThisGSI;
    }

    private String buildCreateIndexSQLForGSI(String tableName, List<SQLiteIndexElement> gsiIndexElements, String indexName, String trailingHashColumnName) {
        String gsiHashKeyColumnName = gsiIndexElements.get(0).getSqliteColumnName();
        StringBuilder builder = new StringBuilder("CREATE INDEX " + SQLiteDBAccess.sqliteIndexNameForGSI(tableName, indexName) + " ON " + SQLiteDBAccess.escapedTableName(tableName) + " (" + gsiHashKeyColumnName);
        if (gsiIndexElements.size() == 2) {
            String gsiRangeKeyColumnName = gsiIndexElements.get(1).getSqliteColumnName();
            builder.append(", ").append(gsiRangeKeyColumnName);
        }
        if (trailingHashColumnName != null) {
            builder.append(", ").append(trailingHashColumnName);
        }
        builder.append(");");
        return builder.toString();
    }

    private String getTrailingHashColumnName(boolean baseTableRangeKeyExists, List<SQLiteIndexElement> indexElementList) {
        HashSet<String> indexAttributes = new HashSet<String>();
        for (SQLiteIndexElement indexElement : indexElementList) {
            indexAttributes.add(indexElement.getSqliteColumnName());
        }
        if (indexAttributes.contains(HASH_KEY_COLUMN_NAME)) {
            if (baseTableRangeKeyExists) {
                if (!indexAttributes.contains(RANGE_KEY_COLUMN_NAME)) {
                    return RANGE_VALUE_COLUMN_NAME;
                }
                return null;
            }
        } else {
            if (baseTableRangeKeyExists) {
                if (!indexAttributes.contains(RANGE_KEY_COLUMN_NAME)) {
                    return HASH_RANGE_VALUE_COLUMN_NAME;
                }
                return HASH_VALUE_COLUMN_NAME;
            }
            return HASH_VALUE_COLUMN_NAME;
        }
        return null;
    }

    @Override
    public void deleteTable(String tableName) {
        final String dropTableSQL = "DROP TABLE " + SQLiteDBAccess.escapedTableName(tableName) + ";";
        logger.debug(dropTableSQL);
        final String updateMetadataSQL = "DELETE FROM dm WHERE TableName = " + SQLiteDBAccess.escapedTableName(tableName) + ";";
        logger.debug(updateMetadataSQL);
        (this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<Void>(){

            @Override
            public Void doWork() throws SQLiteException {
                this.getPreparedStatement(dropTableSQL).step();
                this.getPreparedStatement(updateMetadataSQL).step();
                return null;
            }
        })).get();
    }

    public TableSchemaInfo updateMetadataTable(final String tableName, final ProvisionedThroughput provisionedThroughput, List<AttributeDefinition> updatedAttributeDefinitions, List<GlobalSecondaryIndexDescription> updatedGSIDescList) {
        final TableSchemaInfo tableSchema = this.getTableSchemaInfo(tableName);
        List<GlobalSecondaryIndexDescription> oldGSIList = tableSchema.getGsiDescList();
        tableSchema.setAttributes(updatedAttributeDefinitions);
        tableSchema.setGsiDescList(updatedGSIDescList);
        int nextColumnIndex = this.nextColumnIndex(this.allSqliteColumnNames(tableName), this.collectSQLiteColumnNames(tableSchema.getSqliteIndex()));
        tableSchema.addGSIColumnMappings(SQLiteDBAccess.gsiThatIsGoingToCreatingStatusInThisUpdate(oldGSIList, updatedGSIDescList), nextColumnIndex);
        tableSchema.removeGSIColumnMappings(LocalDBUtils.getGSIsByIndexStatus(updatedGSIDescList, IndexStatus.DELETING));
        final String updateMetadataSQL = String.format("UPDATE %s SET %s=?, %s=?, %s=? WHERE %s=?;", METADATA_TABLE_NAME, READ_CAPACITY_UNITS, WRITE_CAPACITY_UNITS, TABLE_INFO, TABLE_NAME);
        (this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<Void>(){

            @Override
            public Void doWork() throws SQLiteException, JsonProcessingException {
                this.getPreparedStatement(updateMetadataSQL).bind(1, provisionedThroughput.getReadCapacityUnits().longValue()).bind(2, provisionedThroughput.getWriteCapacityUnits().longValue()).bind(3, MAPPER.writeValueAsBytes(tableSchema)).bind(4, tableName).step();
                return null;
            }
        })).get();
        return tableSchema;
    }

    public int nextColumnIndex(Collection<String> persistedSqliteColumnNames, Collection<String> inMemorySqliteColumnNames) {
        int maxIndexAsPerSQLiteTable = this.highestIndexNumberedColumn(persistedSqliteColumnNames);
        int maxIndexAsPerInMemoryMapping = this.highestIndexNumberedColumn(inMemorySqliteColumnNames);
        return Math.max(maxIndexAsPerSQLiteTable, maxIndexAsPerInMemoryMapping) + 1;
    }

    public int highestIndexNumberedColumn(Collection<String> sqliteColumnNames) {
        if (sqliteColumnNames.isEmpty()) {
            return -1;
        }
        String highestIndexColumnName = Collections.max(sqliteColumnNames, new Comparator<String>(){

            @Override
            public int compare(String column1, String column2) {
                return this.getColumnIndex(column1) - this.getColumnIndex(column2);
            }

            private int getColumnIndex(String columnName) {
                if (columnName.matches(SQLiteDBAccess.INDEX_ATTR_SQLITE_COLUMN_FORMAT)) {
                    return Integer.parseInt(columnName.replace(SQLiteDBAccess.INDEX_KEY_COLUMN_NAME, SQLiteDBAccess.PRIMARY_KEY_INDEX_NAME));
                }
                return -1;
            }
        });
        return highestIndexColumnName.matches(INDEX_ATTR_SQLITE_COLUMN_FORMAT) ? Integer.parseInt(highestIndexColumnName.replace(INDEX_KEY_COLUMN_NAME, PRIMARY_KEY_INDEX_NAME)) : -1;
    }

    private List<String> collectSQLiteColumnNames(Map<String, List<SQLiteIndexElement>> sqliteIndexMappings) {
        ArrayList<String> sqliteColumnNames = new ArrayList<String>();
        if (sqliteIndexMappings == null) {
            return sqliteColumnNames;
        }
        for (List<SQLiteIndexElement> elements : sqliteIndexMappings.values()) {
            for (SQLiteIndexElement element : elements) {
                sqliteColumnNames.add(element.getSqliteColumnName());
            }
        }
        return sqliteColumnNames;
    }

    private static List<GlobalSecondaryIndexDescription> gsiThatIsGoingToCreatingStatusInThisUpdate(List<GlobalSecondaryIndexDescription> oldList, List<GlobalSecondaryIndexDescription> newList) {
        HashSet<String> oldGSINames = new HashSet<String>();
        if (oldList != null) {
            for (GlobalSecondaryIndexDescription desc : oldList) {
                oldGSINames.add(desc.getIndexName());
            }
        }
        ArrayList<GlobalSecondaryIndexDescription> result = new ArrayList<GlobalSecondaryIndexDescription>();
        for (GlobalSecondaryIndexDescription newGSI : newList) {
            if (!IndexStatus.CREATING.toString().equals(newGSI.getIndexStatus()) || oldGSINames.contains(newGSI.getIndexName())) continue;
            result.add(newGSI);
        }
        return result;
    }

    @Override
    public void updateTable(String tableName, ProvisionedThroughput provisionedThroughput, List<AttributeDefinition> updatedAttributeDefinitions, List<GlobalSecondaryIndexDescription> gsiDescList) {
        this.updateMetadataTable(tableName, provisionedThroughput, updatedAttributeDefinitions, gsiDescList);
    }

    @Override
    public void deleteGSI(final String tableName, final String indexName) {
        final TableSchemaInfo tableSchema = this.getTableSchemaInfo(tableName);
        (this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<Void>(){

            @Override
            protected Void doWork() throws Throwable {
                this.dropIndices();
                return null;
            }

            private void dropIndices() throws SQLiteException {
                String sqliteIndexName = this.sqliteIndexNamePerNewConvention();
                if (this.doesIndexExist(sqliteIndexName)) {
                    this.dropGSISQLiteIndex(sqliteIndexName);
                } else {
                    String sqliteIndexToBeDeleted = this.sqliteIndexNamePerOldConvention();
                    if (sqliteIndexToBeDeleted != null) {
                        this.dropGSISQLiteIndex(sqliteIndexToBeDeleted);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private String sqliteIndexNamePerOldConvention() throws SQLiteException {
                ArrayList<String> indexColumnNames = new ArrayList<String>();
                List<SQLiteIndexElement> indexElements = tableSchema.getSqliteIndex().get(indexName);
                if (indexElements != null) {
                    for (SQLiteIndexElement indexElement : indexElements) {
                        indexColumnNames.add(indexElement.getSqliteColumnName());
                    }
                }
                String describeIndexSQL = "SELECT * FROM sqlite_master WHERE type = \"index\";";
                SQLiteStatement describeIndexStatement = this.getPreparedStatement("SELECT * FROM sqlite_master WHERE type = \"index\";");
                try {
                    logger.debug("SELECT * FROM sqlite_master WHERE type = \"index\";");
                    while (describeIndexStatement.step()) {
                        String indexName2 = describeIndexStatement.columnString(1);
                        int rowLength = describeIndexStatement.columnCount();
                        String createIndexSQLcmd = describeIndexStatement.columnString(rowLength - 1);
                        if (createIndexSQLcmd == null) continue;
                        boolean deleteThisIndex = true;
                        for (String indexColumnName : indexColumnNames) {
                            deleteThisIndex = deleteThisIndex && createIndexSQLcmd.contains(indexColumnName);
                        }
                        if (!deleteThisIndex) continue;
                        String string = indexName2;
                        return string;
                    }
                }
                finally {
                    describeIndexStatement.dispose();
                }
                return null;
            }

            private void dropGSISQLiteIndex(String indexName2) throws SQLiteException {
                String dropIndexSQL = "DROP INDEX %s;";
                logger.debug(String.format(dropIndexSQL, indexName2));
                this.getPreparedStatement(String.format(dropIndexSQL, indexName2)).step();
            }

            private boolean doesIndexExist(String indexName2) throws SQLiteException {
                String describeIndexSQL = String.format("SELECT * FROM sqlite_master WHERE type = \"index\" AND  name = %s;", indexName2);
                SQLiteStatement describeIndexNameStatement = this.getPreparedStatement(describeIndexSQL);
                describeIndexNameStatement.step();
                logger.debug(describeIndexSQL);
                boolean result = describeIndexNameStatement.hasRow();
                describeIndexNameStatement.dispose();
                return result;
            }

            private String sqliteIndexNamePerNewConvention() {
                return SQLiteDBAccess.sqliteIndexNameForGSI(tableName, indexName);
            }
        })).get();
        TableInfo tableInfo = this.getTableInfo(tableName);
        ArrayList<GlobalSecondaryIndexDescription> updatedGSIDescriptions = new ArrayList<GlobalSecondaryIndexDescription>();
        for (GlobalSecondaryIndexDescription desc : tableInfo.getGSIDescriptions()) {
            if (desc.getIndexName().equals(indexName)) continue;
            updatedGSIDescriptions.add(desc);
        }
        this.updateTable(tableName, tableInfo.getThroughput(), tableInfo.getAttributeDefinitions(), updatedGSIDescriptions);
    }

    @Override
    public synchronized int numberOfSubscriberWideInflightOnlineCreateIndexesOperations() {
        int count = 0;
        for (String tableName : this.listTables(null, null).getTableNames()) {
            TableInfo tableInfo = this.getTableInfo(tableName);
            if (!tableInfo.hasGSIs()) continue;
            for (GlobalSecondaryIndexDescription desc : tableInfo.getGSIDescriptions()) {
                if (!IndexStatus.CREATING.toString().equals(desc.getIndexStatus())) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public void optimizeDBBeforeStartup() {
        logger.info("Optimize phase starting now");
        for (String tableName : this.listTables(null, null).getTableNames()) {
            logger.info("Optimizing " + tableName + "....");
            this.optimizeTable(tableName);
            logger.info("Optimizing " + tableName + "....Done");
        }
        logger.info("Optimize phase complete!");
    }

    private void optimizeTable(String tableName) {
        String newTable = tableName + "=new";
        String oldTable = tableName;
        final String createNewTableSQL = "CREATE TABLE " + SQLiteDBAccess.escapedTableName(newTable) + " AS SELECT " + StringUtils.join((String)", ", (String[])this.allSQLiteColumnNamesThatAreRelevant(tableName)) + " FROM " + SQLiteDBAccess.escapedTableName(oldTable);
        final String dropOldTableSQL = "DROP TABLE " + SQLiteDBAccess.escapedIndexName(oldTable);
        final String renameTempTableToActualTableSQL = "ALTER TABLE " + SQLiteDBAccess.escapedTableName(newTable) + " RENAME TO " + SQLiteDBAccess.escapedTableName(tableName);
        final List<String> createIndexSQLs = this.sqliteCreateIndexSQLsForTable(tableName);
        (this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<Void>(){

            @Override
            public Void doWork() throws SQLiteException {
                this.getPreparedStatement(createNewTableSQL).step();
                logger.debug(createNewTableSQL);
                this.getPreparedStatement(dropOldTableSQL).step();
                logger.debug(dropOldTableSQL);
                this.getPreparedStatement(renameTempTableToActualTableSQL).step();
                logger.debug(renameTempTableToActualTableSQL);
                for (String createIndexSQL : createIndexSQLs) {
                    this.getPreparedStatement(createIndexSQL).step();
                    logger.debug(createIndexSQL);
                }
                return null;
            }
        })).get();
    }

    private List<String> sqliteCreateIndexSQLsForTable(final String tableName) {
        return (List)(this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<List<String>>(){

            @Override
            public List<String> doWork() throws SQLiteException, JsonProcessingException {
                ArrayList<String> result = new ArrayList<String>();
                String listIndicesSQL = "SELECT sql FROM sqlite_master WHERE type='index' AND name LIKE '" + tableName + "%'";
                SQLiteStatement listIndicesStatement = this.getPreparedStatement(listIndicesSQL);
                logger.debug(listIndicesSQL);
                while (listIndicesStatement.step()) {
                    result.add(listIndicesStatement.columnString(0));
                }
                return result;
            }
        })).get();
    }

    private String[] allSQLiteColumnNamesThatAreRelevant(String tableName) {
        Set<String> columnsToCopyOver = this.allSqliteColumnNamesRelevant(tableName);
        return columnsToCopyOver.toArray(new String[columnsToCopyOver.size()]);
    }

    @Override
    public Map<String, AttributeValue> getRecord(final String tableName, final Map<String, AttributeValue> primaryKey) {
        return (Map)(this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<Map<String, AttributeValue>>(){

            @Override
            public Map<String, AttributeValue> doWork() throws SQLiteException, JsonParseException, JsonMappingException, IOException {
                TableSchemaInfo tableSchema = this.getTableSchemaInfo2(tableName);
                return this.getRecordInternal(tableSchema, tableName, primaryKey);
            }
        })).get();
    }

    @Override
    public boolean deleteRecord(final String tableName, final Map<String, AttributeValue> primaryKey) {
        Map<String, AttributeValue> record = this.getRecord(tableName, primaryKey);
        if (record == null) {
            return false;
        }
        (this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<Void>(){

            @Override
            public Void doWork() throws JsonParseException, JsonMappingException, SQLiteException, IOException {
                TableSchemaInfo tableSchema = this.getTableSchemaInfo2(tableName);
                List<SQLiteIndexElement> relevantIndexes = tableSchema.getSqliteIndex().get(SQLiteDBAccess.PRIMARY_KEY_INDEX_NAME);
                StringBuilder sql = new StringBuilder(String.format("DELETE FROM %s WHERE ", SQLiteDBAccess.escapedTableName(tableName)));
                sql.append(SQLiteDBAccess.this.constructIndexWhereClause(relevantIndexes));
                sql.append(";");
                logger.debug(sql.toString());
                SQLiteStatement statement = this.getPreparedStatement(sql.toString());
                SQLiteDBAccess.this.applyKeyBinds(statement, relevantIndexes, primaryKey);
                statement.step();
                return null;
            }
        })).get();
        return true;
    }

    @Override
    public void putRecord(final String tableName, final Map<String, AttributeValue> record, final AttributeValue hashKey, final AttributeValue rangeKey, boolean isUpdate) {
        (this.queue.execute((SQLiteJob)new PutItemSQLiteDBAccessJob<Void>(){

            @Override
            public Void doWork() throws SQLiteException, IOException {
                this.doPutItem(tableName, SQLiteDBAccess.this.sqliteColumnBindingsForAllAttributes(record, this.getTableSchemaInfo2(tableName), hashKey, rangeKey), LocalDBUtils.getItemSizeBytes(record));
                return null;
            }
        })).get();
    }

    @Override
    public void backfillGSI(final String tableName, final String indexName) {
        final TableSchemaInfo tableSchemaInfo = this.getTableSchemaInfo(tableName);
        final SQLiteIndexElement hashKeyIndex = tableSchemaInfo.getHashKeyIndex();
        final SQLiteIndexElement rangeKeyIndex = tableSchemaInfo.getRangeKeyIndex();
        final ArrayList itemsToBackfill = new ArrayList();
        (this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<Void>(){

            @Override
            public Void doWork() throws SQLiteException, IOException {
                String queryAllRows = "SELECT ObjectJSON FROM " + SQLiteDBAccess.escapedTableName(tableName) + ";";
                SQLiteStatement allRowsStatement = this.getPreparedStatement(queryAllRows);
                logger.debug(queryAllRows);
                while (allRowsStatement.step()) {
                    Map item = (Map)MAPPER.readValue(allRowsStatement.columnBlob(0), DynamoDBObjectMapper.ITEM_TYPE);
                    if (!this.itemHasAnyGSIAttributes(item)) continue;
                    itemsToBackfill.add(item);
                }
                return null;
            }

            private boolean itemHasAnyGSIAttributes(Map<String, AttributeValue> item) {
                if (rangeKeyIndex != null) {
                    return item.containsKey(hashKeyIndex.getDynamoDBAttribute().getAttributeName()) || item.containsKey(rangeKeyIndex.getDynamoDBAttribute().getAttributeName());
                }
                return item.containsKey(hashKeyIndex.getDynamoDBAttribute().getAttributeName());
            }
        })).get();
        (this.queue.execute((SQLiteJob)new PutItemSQLiteDBAccessJob<Void>(){

            @Override
            public Void doWork() throws SQLiteException, IOException {
                for (Map item : itemsToBackfill) {
                    this.doBackfillItem(tableName, SQLiteDBAccess.this.sqliteColumnBindingsForGSIAttributes(item, tableSchemaInfo, indexName), item, rangeKeyIndex, hashKeyIndex);
                }
                return null;
            }
        })).get();
    }

    private String[] repeat(String str, int times) {
        String[] array = new String[times];
        for (int i = 0; i < times; ++i) {
            array[i] = str;
        }
        return array;
    }

    private Map<String, byte[]> sqliteColumnBindingsForAllAttributes(Map<String, AttributeValue> record, TableSchemaInfo tableSchema, AttributeValue hashKey, AttributeValue rangeKey) throws JsonProcessingException {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        result.putAll(this.getColumnNameToValueMap(record, tableSchema.getUniqueIndexes()));
        if (tableSchema.hasGSIs()) {
            for (List<SQLiteIndexElement> gsiIndex : tableSchema.getUniqueGSIIndexes()) {
                result.putAll(this.getColumnNameToValueMap(record, gsiIndex));
            }
        }
        result.put(HASH_VALUE_COLUMN_NAME, LocalDBUtils.getHashValue(hashKey));
        if (rangeKey != null) {
            result.put(RANGE_VALUE_COLUMN_NAME, LocalDBUtils.getHashValue(rangeKey));
            if (tableSchema.hasGSIs()) {
                result.put(HASH_RANGE_VALUE_COLUMN_NAME, LocalDBUtils.getHashValue(hashKey, rangeKey));
            }
        }
        result.put(OBJECT_COLUMN_NAME, MAPPER.writeValueAsBytes(record));
        return result;
    }

    protected static boolean doesTableExist(String tableName, AmazonDynamoDBOfflineSQLiteJob<?> job) throws SQLiteException {
        String configSQL = "SELECT name FROM sqlite_master WHERE type='table' AND name='" + tableName + "';";
        SQLiteStatement configStatement = job.getPreparedStatement(configSQL);
        return configStatement.step();
    }

    private Map<String, byte[]> sqliteColumnBindingsForGSIAttributes(Map<String, AttributeValue> item, TableSchemaInfo tableSchemaInfo, String indexName) {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        result.putAll(this.getColumnNameToValueMap(item, tableSchemaInfo.getSqliteIndex().get(indexName)));
        if (tableSchemaInfo.getRangeKeyDefinition() != null) {
            AttributeValue hashKey = item.get(tableSchemaInfo.getHashKeyDefinition().getAttributeName());
            AttributeValue rangeKey = item.get(tableSchemaInfo.getRangeKeyDefinition().getAttributeName());
            result.put(HASH_RANGE_VALUE_COLUMN_NAME, LocalDBUtils.getHashValue(hashKey, rangeKey));
        }
        return result;
    }

    private Map<String, byte[]> getColumnNameToValueMap(Map<String, AttributeValue> item, List<SQLiteIndexElement> indexElements) {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        for (SQLiteIndexElement indexElement : indexElements) {
            String attributeName = indexElement.getDynamoDBAttribute().getAttributeName();
            if (item.get(attributeName) == null) continue;
            result.put(indexElement.getSqliteColumnName(), this.translateKeyAttributeValue(item.get(attributeName)));
        }
        return result;
    }

    @Override
    public QueryResultInfo queryRecords(final String tableName, final String indexName, final Map<String, Condition> conditions, final Map<String, AttributeValue> exclusiveStartKey, final Long limit, final boolean ascending, final byte[] beginHash, final byte[] endHash, final boolean isScan, final boolean isGSIIndex) {
        return (QueryResultInfo)(this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<QueryResultInfo>(){

            @Override
            public QueryResultInfo doWork() throws IOException, SQLiteException {
                String querySQL;
                String nestedQuerySQL;
                String index = indexName == null ? SQLiteDBAccess.PRIMARY_KEY_INDEX_NAME : indexName;
                TableSchemaInfo tableSchema = this.getTableSchemaInfo2(tableName);
                List<SQLiteIndexElement> indexes = tableSchema.getSqliteIndex().get(index);
                StringBuilder indexColumns = new StringBuilder(SQLiteDBAccess.PRIMARY_KEY_INDEX_NAME);
                StringBuilder orderByCols = new StringBuilder(SQLiteDBAccess.PRIMARY_KEY_INDEX_NAME);
                String orderString = ascending ? "ASC" : "DESC";
                StringBuilder indexColumnsNotNullClause = new StringBuilder(SQLiteDBAccess.PRIMARY_KEY_INDEX_NAME);
                StringBuilder indexConditionsWhereClause = new StringBuilder(SQLiteDBAccess.PRIMARY_KEY_INDEX_NAME);
                ArrayList<byte[]> indexConditionsBinds = new ArrayList<byte[]>();
                boolean conditionAdded = false;
                for (int i = 0; i < indexes.size(); ++i) {
                    Condition condition;
                    SQLiteIndexElement element = indexes.get(i);
                    String columnName = element.getSqliteColumnName();
                    if (i > 0) {
                        indexColumns.append(", ");
                        orderByCols.append(", ");
                        indexColumnsNotNullClause.append(" AND ");
                    }
                    indexColumns.append(columnName);
                    orderByCols.append(columnName + " " + orderString);
                    indexColumnsNotNullClause.append(String.format("%s IS NOT NULL", columnName));
                    if (conditions == null || (condition = (Condition)conditions.get(element.getDynamoDBAttribute().getAttributeName())) == null) continue;
                    if (conditionAdded && i > 0) {
                        indexConditionsWhereClause.append(" AND ");
                        conditionAdded = false;
                    }
                    ComparisonOperator comparisonOperator = ComparisonOperator.fromValue((String)condition.getComparisonOperator());
                    StringBuilder operatorClause = new StringBuilder(columnName);
                    byte[] data = SQLiteDBAccess.this.translateKeyAttributeValue(condition.getAttributeValueList().get(0));
                    switch (comparisonOperator) {
                        case EQ: {
                            operatorClause.append(" = ?");
                            break;
                        }
                        case LT: {
                            operatorClause.append(" < ?");
                            break;
                        }
                        case GT: {
                            operatorClause.append(" > ?");
                            break;
                        }
                        case LE: {
                            operatorClause.append(" <= ?");
                            break;
                        }
                        case GE: {
                            operatorClause.append(" >= ?");
                            break;
                        }
                        case BEGINS_WITH: {
                            operatorClause.append(" LIKE ?");
                            data = Arrays.copyOf(data, data.length + 1);
                            data[data.length - 1] = 37;
                            break;
                        }
                        case BETWEEN: {
                            operatorClause.append(" BETWEEN ? AND ?");
                            indexConditionsBinds.add(data);
                            data = SQLiteDBAccess.this.translateKeyAttributeValue(condition.getAttributeValueList().get(1));
                            break;
                        }
                        default: {
                            throw new LocalDBAccessException(LocalDBAccessExceptionType.VALIDATION_EXCEPTION, "Unsupported comparison operator for query: " + comparisonOperator.toString());
                        }
                    }
                    if (indexConditionsWhereClause.length() == 0) {
                        indexConditionsWhereClause = new StringBuilder("WHERE ");
                    }
                    indexConditionsWhereClause.append((CharSequence)operatorClause);
                    indexConditionsBinds.add(data);
                    conditionAdded = true;
                }
                String trailingHashColName = null;
                if (indexName != null && !isGSIIndex) {
                    indexColumns.append(", rangeValue");
                    orderByCols.append(", rangeValue " + orderString);
                } else if (isGSIIndex && (trailingHashColName = SQLiteDBAccess.this.getTrailingHashColumnName(tableSchema.getRangeKeyDefinition() != null, tableSchema.getSqliteIndex().get(indexName))) != null) {
                    indexColumns.append(", " + trailingHashColName);
                    orderByCols.append(", " + trailingHashColName + " " + orderString);
                }
                String indexColumnsAndObjectData = "ObjectJSON, " + indexColumns;
                StringBuilder exclusiveStartKeyClause = new StringBuilder(SQLiteDBAccess.PRIMARY_KEY_INDEX_NAME);
                ArrayList<byte[]> exclusiveStartKeyBinds = new ArrayList<byte[]>();
                if (exclusiveStartKey != null) {
                    if (!isScan) {
                        String direction = ascending ? ">" : "<";
                        AttributeDefinition hashKeyDef = tableSchema.getHashKeyDefinition();
                        if (indexName == null || !isGSIIndex) {
                            exclusiveStartKeyClause.append(String.format("AND (%s %s ?", SQLiteDBAccess.HASH_KEY_COLUMN_NAME, direction));
                            exclusiveStartKeyBinds.add(SQLiteDBAccessUtils.translateKeyAttributeValue((AttributeValue)exclusiveStartKey.get(hashKeyDef.getAttributeName())));
                        }
                        AttributeDefinition rangeKeyDef = tableSchema.getRangeKeyDefinition();
                        if (indexName == null) {
                            if (rangeKeyDef != null) {
                                exclusiveStartKeyClause.append(String.format(" OR (%s = ? AND %s %s ?)", SQLiteDBAccess.HASH_KEY_COLUMN_NAME, SQLiteDBAccess.RANGE_KEY_COLUMN_NAME, direction));
                                exclusiveStartKeyBinds.add(SQLiteDBAccessUtils.translateKeyAttributeValue((AttributeValue)exclusiveStartKey.get(hashKeyDef.getAttributeName())));
                                exclusiveStartKeyBinds.add(SQLiteDBAccessUtils.translateKeyAttributeValue((AttributeValue)exclusiveStartKey.get(rangeKeyDef.getAttributeName())));
                            }
                        } else if (!isGSIIndex) {
                            String indexKeyName = tableSchema.getLSIRangeIndexElement(indexName).getSqliteColumnName();
                            String indexKeyDynamoDBName = SQLiteDBAccessUtils.getLSIIndexKeyDynamoDBName(tableSchema, indexName);
                            exclusiveStartKeyClause.append(String.format(" OR (%s = ? AND %s %s ?)", SQLiteDBAccess.HASH_KEY_COLUMN_NAME, indexKeyName, direction));
                            exclusiveStartKeyBinds.add(SQLiteDBAccessUtils.translateKeyAttributeValue((AttributeValue)exclusiveStartKey.get(hashKeyDef.getAttributeName())));
                            exclusiveStartKeyBinds.add(SQLiteDBAccessUtils.translateKeyAttributeValue((AttributeValue)exclusiveStartKey.get(indexKeyDynamoDBName)));
                            exclusiveStartKeyClause.append(String.format(" OR (%s = ? AND %s = ? AND %s %s ?)", SQLiteDBAccess.HASH_KEY_COLUMN_NAME, indexKeyName, SQLiteDBAccess.RANGE_VALUE_COLUMN_NAME, direction));
                            exclusiveStartKeyBinds.add(SQLiteDBAccessUtils.translateKeyAttributeValue((AttributeValue)exclusiveStartKey.get(hashKeyDef.getAttributeName())));
                            exclusiveStartKeyBinds.add(SQLiteDBAccessUtils.translateKeyAttributeValue((AttributeValue)exclusiveStartKey.get(indexKeyDynamoDBName)));
                            exclusiveStartKeyBinds.add(LocalDBUtils.getHashValue((AttributeValue)exclusiveStartKey.get(rangeKeyDef.getAttributeName())));
                        } else {
                            byte[] trailHash = null;
                            if (trailingHashColName != null) {
                                trailHash = trailingHashColName.equals(SQLiteDBAccess.HASH_VALUE_COLUMN_NAME) ? LocalDBUtils.getHashValue((AttributeValue)exclusiveStartKey.get(hashKeyDef.getAttributeName())) : (trailingHashColName.equals(SQLiteDBAccess.RANGE_VALUE_COLUMN_NAME) ? LocalDBUtils.getHashValue((AttributeValue)exclusiveStartKey.get(rangeKeyDef.getAttributeName())) : LocalDBUtils.getHashValue((AttributeValue)exclusiveStartKey.get(hashKeyDef.getAttributeName()), (AttributeValue)exclusiveStartKey.get(rangeKeyDef.getAttributeName())));
                            }
                            String gsiHashKey = tableSchema.getGSIHashIndexElement(indexName).getSqliteColumnName();
                            String gsiHashKeyDynamoDBName = SQLiteDBAccessUtils.getGSIKeyDynamoDBName(tableSchema, indexName, KeyType.HASH.toString());
                            exclusiveStartKeyClause.append(String.format(" AND (%s %s ?", gsiHashKey, direction));
                            exclusiveStartKeyBinds.add(SQLiteDBAccessUtils.translateKeyAttributeValue((AttributeValue)exclusiveStartKey.get(gsiHashKeyDynamoDBName)));
                            String gsiRangeKey = null;
                            String gsiRangeKeyDynamoDBName = null;
                            if (tableSchema.getGSIRangeIndexElement(indexName) != null) {
                                gsiRangeKey = tableSchema.getGSIRangeIndexElement(indexName).getSqliteColumnName();
                                gsiRangeKeyDynamoDBName = SQLiteDBAccessUtils.getGSIKeyDynamoDBName(tableSchema, indexName, KeyType.RANGE.toString());
                                exclusiveStartKeyClause.append(String.format(" OR (%s = ? AND %s %s ?)", gsiHashKey, gsiRangeKey, direction));
                                exclusiveStartKeyBinds.add(SQLiteDBAccessUtils.translateKeyAttributeValue((AttributeValue)exclusiveStartKey.get(gsiHashKeyDynamoDBName)));
                                exclusiveStartKeyBinds.add(SQLiteDBAccessUtils.translateKeyAttributeValue((AttributeValue)exclusiveStartKey.get(gsiRangeKeyDynamoDBName)));
                                if (trailingHashColName != null) {
                                    exclusiveStartKeyClause.append(String.format(" OR (%s = ? AND %s = ? AND %s %s ?)", gsiHashKey, gsiRangeKey, trailingHashColName, direction));
                                    exclusiveStartKeyBinds.add(SQLiteDBAccessUtils.translateKeyAttributeValue((AttributeValue)exclusiveStartKey.get(gsiHashKeyDynamoDBName)));
                                    exclusiveStartKeyBinds.add(SQLiteDBAccessUtils.translateKeyAttributeValue((AttributeValue)exclusiveStartKey.get(gsiRangeKeyDynamoDBName)));
                                    exclusiveStartKeyBinds.add(trailHash);
                                }
                            } else if (trailingHashColName != null) {
                                exclusiveStartKeyClause.append(String.format(" OR (%s = ? AND %s %s ?)", gsiHashKey, trailingHashColName, direction));
                                exclusiveStartKeyBinds.add(SQLiteDBAccessUtils.translateKeyAttributeValue((AttributeValue)exclusiveStartKey.get(gsiHashKeyDynamoDBName)));
                                exclusiveStartKeyBinds.add(trailHash);
                            }
                        }
                        exclusiveStartKeyClause.append(")");
                    } else {
                        if (isScan) {
                            LocalDBUtils.ldAccessAssertTrue(ascending, LocalDBAccessExceptionType.UNEXPECTED_EXCEPTION, "Scan should always use ascending order.", new Object[0]);
                        }
                        SQLiteDBAccess.this.prepareKeyColumnsWithExclusiveStartKey(tableSchema, indexName, exclusiveStartKey, ascending, isGSIIndex, trailingHashColName, exclusiveStartKeyClause, exclusiveStartKeyBinds);
                    }
                }
                if (!isScan) {
                    nestedQuerySQL = String.format("SELECT %s FROM %s WHERE %s %s ", indexColumnsAndObjectData, SQLiteDBAccessUtils.escapedTableName(tableName), indexColumnsNotNullClause.toString(), exclusiveStartKeyClause.toString());
                    querySQL = String.format("SELECT %s FROM (%s) %s ORDER BY %s LIMIT ?;", SQLiteDBAccess.OBJECT_COLUMN_NAME, nestedQuerySQL, indexConditionsWhereClause.toString(), orderByCols);
                } else {
                    String segmentSQL;
                    String segmentWhereClause;
                    String rangeKeyColName = SQLiteDBAccess.PRIMARY_KEY_INDEX_NAME;
                    if (tableSchema.getRangeKeyDefinition() != null) {
                        rangeKeyColName = ", rangeKey";
                    }
                    String string = segmentWhereClause = beginHash == null ? SQLiteDBAccess.PRIMARY_KEY_INDEX_NAME : " WHERE hashValue >= ? AND hashValue <= ?";
                    if (indexName == null) {
                        segmentSQL = String.format("SELECT %s FROM %s %s ORDER BY %s %s", "hashValue, " + indexColumnsAndObjectData, SQLiteDBAccessUtils.escapedTableName(tableName), segmentWhereClause, SQLiteDBAccess.HASH_VALUE_COLUMN_NAME, rangeKeyColName);
                    } else if (!isGSIIndex) {
                        String indexRangeKeyColName = SQLiteDBAccess.PRIMARY_KEY_INDEX_NAME;
                        SQLiteIndexElement indexElement = tableSchema.getLSIRangeIndexElement(indexName);
                        if (indexElement != null) {
                            indexRangeKeyColName = ", " + indexElement.getSqliteColumnName();
                        }
                        segmentSQL = String.format("SELECT %s FROM %s %s ORDER BY %s %s %s", "hashValue, " + indexColumnsAndObjectData + rangeKeyColName, SQLiteDBAccessUtils.escapedTableName(tableName), segmentWhereClause, SQLiteDBAccess.HASH_VALUE_COLUMN_NAME, indexRangeKeyColName, rangeKeyColName);
                    } else {
                        segmentSQL = String.format("SELECT %s FROM %s %s ORDER BY %s", "hashValue, " + indexColumnsAndObjectData, SQLiteDBAccessUtils.escapedTableName(tableName), segmentWhereClause, orderByCols);
                    }
                    nestedQuerySQL = String.format("SELECT %s FROM (%s) WHERE %s %s", indexColumnsAndObjectData, segmentSQL, indexColumnsNotNullClause.toString(), exclusiveStartKeyClause.toString());
                    querySQL = String.format("SELECT %s FROM (%s) %s LIMIT ?;", SQLiteDBAccess.OBJECT_COLUMN_NAME, nestedQuerySQL, indexConditionsWhereClause.toString());
                }
                logger.debug("querySQL: " + querySQL);
                SQLiteStatement statement = this.getPreparedStatement(querySQL);
                int i = 1;
                if (beginHash != null) {
                    statement.bind(i, beginHash);
                    statement.bind(++i, endHash);
                    ++i;
                }
                i = SQLiteDBAccessUtils.applyBinds(statement, i, exclusiveStartKeyBinds);
                i = SQLiteDBAccessUtils.applyBinds(statement, i, indexConditionsBinds);
                long lim = limit == null ? -1L : limit;
                statement.bind(i, lim);
                logger.debug("\tbinding " + i + ":\t" + lim);
                ++i;
                ArrayList<Map<String, AttributeValue>> ret = new ArrayList<Map<String, AttributeValue>>();
                while (statement.step()) {
                    Map record = (Map)MAPPER.readValue(statement.columnBlob(0), DynamoDBObjectMapper.ITEM_TYPE);
                    logger.debug("queryRecords: " + record.toString());
                    ret.add(record);
                }
                Map lastEvaluatedItem = null;
                if (lim > 0L && (long)ret.size() == lim) {
                    lastEvaluatedItem = (Map)ret.get(ret.size() - 1);
                }
                return new QueryResultInfo(ret, lastEvaluatedItem);
            }
        })).get();
    }

    @Override
    public long getTableItemCount(final String tableName) {
        return (Long)(this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<Long>(){

            @Override
            public Long doWork() throws SQLiteException {
                String tableSizeSQL = "SELECT COUNT(1) FROM " + SQLiteDBAccessUtils.escapedTableName(tableName) + ";";
                SQLiteStatement statement = this.getPreparedStatement(tableSizeSQL);
                statement.step();
                return statement.columnLong(0);
            }
        })).get();
    }

    @Override
    public long getLSIItemCount(final String tableName, final String indexName) {
        return (Long)(this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<Long>(){

            @Override
            public Long doWork() throws JsonParseException, JsonMappingException, SQLiteException, IOException {
                TableSchemaInfo tableSchema = this.getTableSchemaInfo2(tableName);
                String columnName = tableSchema.getLSIRangeIndexElement(indexName).getSqliteColumnName();
                String tableSizeSQL = "SELECT COUNT(" + columnName + ") FROM " + SQLiteDBAccessUtils.escapedTableName(tableName) + ";";
                SQLiteStatement statement = this.getPreparedStatement(tableSizeSQL);
                statement.step();
                return statement.columnLong(0);
            }
        })).get();
    }

    @Override
    public long getGSIItemCount(final String tableName, final String indexName) {
        return (Long)(this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<Long>(){

            @Override
            public Long doWork() throws JsonParseException, JsonMappingException, SQLiteException, IOException {
                TableSchemaInfo tableSchema = this.getTableSchemaInfo2(tableName);
                String hashKeyColumnName = tableSchema.getGSIHashIndexElement(indexName).getSqliteColumnName();
                String tableSizeSQL = null;
                if (tableSchema.getGSIRangeIndexElement(indexName) != null) {
                    String gsiRangeKeyColName = tableSchema.getGSIRangeIndexElement(indexName).getSqliteColumnName();
                    tableSizeSQL = String.format("SELECT COUNT(%s) FROM %s WHERE %s IS NOT NULL AND %s IS NOT NULL;", hashKeyColumnName, SQLiteDBAccess.escapedTableName(tableName), hashKeyColumnName, gsiRangeKeyColName);
                } else {
                    tableSizeSQL = String.format("SELECT COUNT(%s) FROM %s WHERE %s IS NOT NULL;", hashKeyColumnName, SQLiteDBAccess.escapedTableName(tableName), hashKeyColumnName);
                }
                SQLiteStatement statement = this.getPreparedStatement(tableSizeSQL);
                statement.step();
                return statement.columnLong(0);
            }
        })).get();
    }

    private TableSchemaInfo getTableSchemaInfo(String tableName) {
        final String metadataSelectSQL = "SELECT TableInfo FROM dm WHERE TableName = " + SQLiteDBAccess.escapedTableName(tableName) + ";";
        logger.debug(metadataSelectSQL);
        return (TableSchemaInfo)(this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<TableSchemaInfo>(){

            @Override
            public TableSchemaInfo doWork() throws SQLiteException, JsonParseException, JsonMappingException, IOException {
                TableSchemaInfo ret = null;
                SQLiteStatement statement = this.getPreparedStatement(metadataSelectSQL);
                if (statement.step()) {
                    ret = (TableSchemaInfo)MAPPER.readValue(statement.columnBlob(0), TableSchemaInfo.class);
                }
                return ret;
            }
        })).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.queue.stop(true);
        if (this.databaseFile != null) {
            Set<File> set = openedFiles;
            synchronized (set) {
                openedFiles.remove(this.databaseFile);
            }
        }
    }

    @Override
    public TableInfo getTableInfo(final String tableName) {
        final String metadataSelectSQL = "SELECT CreationDateTime, LastDecreaseDate, LastIncreaseDate, NumberOfDecreasesToday, ReadCapacityUnits, WriteCapacityUnits, TableInfo FROM dm WHERE TableName = " + SQLiteDBAccess.escapedTableName(tableName) + ";";
        logger.debug(metadataSelectSQL);
        return (TableInfo)(this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<TableInfo>(){

            @Override
            public TableInfo doWork() throws SQLiteException, JsonParseException, JsonMappingException, IOException {
                TableInfo ret = null;
                SQLiteStatement statement = this.getPreparedStatement(metadataSelectSQL);
                if (statement.step()) {
                    Long creationDateTime = statement.columnLong(0);
                    Long lastDecreaseDateTime = statement.columnLong(1);
                    Long lastIncreaseDateTime = statement.columnLong(2);
                    Long numDecreasesToday = statement.columnLong(3);
                    Long readCapacityUnits = statement.columnLong(4);
                    Long writeCapacityUnits = statement.columnLong(5);
                    TableSchemaInfo tableSchema = (TableSchemaInfo)MAPPER.readValue(statement.columnBlob(6), TableSchemaInfo.class);
                    ret = new TableInfo(tableName, tableSchema.getHashKeyDefinition(), tableSchema.getRangeKeyDefinition(), tableSchema.getAttributes(), tableSchema.getLsiList(), tableSchema.getGsiDescList(), new ProvisionedThroughput().withReadCapacityUnits(readCapacityUnits).withWriteCapacityUnits(writeCapacityUnits), creationDateTime, lastDecreaseDateTime, lastIncreaseDateTime, numDecreasesToday);
                    ret.setCreationDateTime(creationDateTime);
                }
                return ret;
            }
        })).get();
    }

    @Override
    public ListTablesResultInfo listTables(String exclusiveStartTableName, Long limit) {
        String excStart = exclusiveStartTableName == null ? PRIMARY_KEY_INDEX_NAME : exclusiveStartTableName;
        final long lim = limit == null || limit < 0L ? -1L : limit + 1L;
        final String sql = String.format("SELECT %s FROM %s WHERE %s > %s ORDER BY %s ASC LIMIT %d;", TABLE_NAME, METADATA_TABLE_NAME, TABLE_NAME, SQLiteDBAccessUtils.escapedTableName(excStart), TABLE_NAME, lim);
        logger.debug(sql);
        return (ListTablesResultInfo)(this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<ListTablesResultInfo>(){

            @Override
            protected ListTablesResultInfo doWork() throws Throwable {
                SQLiteStatement statement = this.getPreparedStatement(sql);
                ArrayList<String> ret = new ArrayList<String>();
                while (statement.step()) {
                    ret.add(statement.columnString(0));
                }
                String lastEvaluatedTableName = null;
                if (lim > 0L && (long)ret.size() == lim) {
                    ret.remove(ret.size() - 1);
                    lastEvaluatedTableName = (String)ret.get(ret.size() - 1);
                }
                return new ListTablesResultInfo(ret, lastEvaluatedTableName);
            }
        })).get();
    }

    @Override
    public long getTableByteSize(String tableName) {
        final String sql = String.format("SELECT SUM(%s) FROM %s;", ITEM_SIZE_COLUMN_NAME, SQLiteDBAccessUtils.escapedTableName(tableName));
        return (Long)(this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<Long>(){

            @Override
            protected Long doWork() throws Throwable {
                SQLiteStatement statement = this.getPreparedStatement(sql);
                statement.step();
                return statement.columnLong(0);
            }
        })).get();
    }

    @Override
    public long getLSIByteSize(final String tableName, final String indexName) {
        return (Long)(this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<Long>(){

            @Override
            protected Long doWork() throws Throwable {
                TableSchemaInfo tableSchema = this.getTableSchemaInfo2(tableName);
                String indexColumnName = tableSchema.getLSIRangeIndexElement(indexName).getSqliteColumnName();
                String sql = String.format("SELECT SUM(%s) FROM %s WHERE %s IS NOT NULL;", SQLiteDBAccess.ITEM_SIZE_COLUMN_NAME, SQLiteDBAccessUtils.escapedTableName(tableName), indexColumnName);
                SQLiteStatement statement = this.getPreparedStatement(sql);
                statement.step();
                return statement.columnLong(0);
            }
        })).get();
    }

    @Override
    public long getGSIByteSize(final String tableName, final String indexName) {
        return (Long)(this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<Long>(){

            @Override
            protected Long doWork() throws Throwable {
                TableSchemaInfo tableSchema = this.getTableSchemaInfo2(tableName);
                String hashColumnName = tableSchema.getGSIHashIndexElement(indexName).getSqliteColumnName();
                String sql = null;
                if (tableSchema.getGSIRangeIndexElement(indexName) != null) {
                    String rangeColumnName = tableSchema.getGSIRangeIndexElement(indexName).getSqliteColumnName();
                    sql = String.format("SELECT SUM(%s) FROM %s WHERE %s IS NOT NULL OR %s IS NOT NULL;", SQLiteDBAccess.ITEM_SIZE_COLUMN_NAME, SQLiteDBAccessUtils.escapedTableName(tableName), hashColumnName, rangeColumnName);
                } else {
                    sql = String.format("SELECT SUM(%s) FROM %s WHERE %s IS NOT NULL;", SQLiteDBAccess.ITEM_SIZE_COLUMN_NAME, SQLiteDBAccessUtils.escapedTableName(tableName), hashColumnName);
                }
                SQLiteStatement statement = this.getPreparedStatement(sql);
                statement.step();
                return statement.columnLong(0);
            }
        })).get();
    }

    @Override
    public synchronized ReentrantReadWriteLock getLockForTable(String tableName) {
        ReentrantReadWriteLock lock = this.rowLockTable.get(tableName);
        if (lock == null) {
            lock = new ReentrantReadWriteLock();
            this.rowLockTable.put(tableName, lock);
        }
        return lock;
    }

    @Override
    public Map<String, List<GlobalSecondaryIndexDescription>> getGSIsByStatusFromAllTables(final IndexStatus status, final Boolean backfilling) {
        String listAllTableInfo = "SELECT TableName, TableInfo FROM dm;";
        logger.debug("SELECT TableName, TableInfo FROM dm;");
        return (Map)(this.queue.execute((SQLiteJob)new SQLiteDBAccessJob<Map<String, List<GlobalSecondaryIndexDescription>>>(){

            @Override
            public Map<String, List<GlobalSecondaryIndexDescription>> doWork() throws SQLiteException, IOException {
                HashMap<String, List<GlobalSecondaryIndexDescription>> ret = new HashMap<String, List<GlobalSecondaryIndexDescription>>();
                SQLiteStatement statement = this.getPreparedStatement("SELECT TableName, TableInfo FROM dm;");
                while (statement.step()) {
                    String tableName = statement.columnString(0);
                    TableSchemaInfo tableSchema = (TableSchemaInfo)MAPPER.readValue(statement.columnBlob(1), TableSchemaInfo.class);
                    ret.put(tableName, tableSchema.getGSIsByIndexStatus(status, backfilling));
                }
                return ret;
            }
        })).get();
    }

    public static String escapedTableName(String s) {
        return "\"" + s + "\"";
    }

    public static String escapedIndexName(String s) {
        return SQLiteDBAccess.escapedTableName(s);
    }

    private static String sqliteIndexNameForLSI(String tableName, String lsiRangeKeyAttrName) {
        return SQLiteDBAccess.escapedIndexName(tableName + INDEX_DELIMITER + "LSI" + INDEX_DELIMITER + lsiRangeKeyAttrName);
    }

    public static String sqliteIndexNameForGSI(String tableName, String indexName) {
        return SQLiteDBAccess.escapedIndexName(tableName + INDEX_DELIMITER + indexName);
    }

    private byte[] translateKeyAttributeValue(AttributeValue attributeValue) {
        if (attributeValue.getB() != null) {
            return attributeValue.getB().array();
        }
        if (attributeValue.getN() != null) {
            return PaddingNumberEncoder.encodeBigDecimal(new BigDecimal(attributeValue.getN()));
        }
        if (attributeValue.getS() != null) {
            return attributeValue.getS().getBytes(LocalDBUtils.UTF8);
        }
        throw new IllegalArgumentException("Unknown AttributeValue type: " + attributeValue.toString());
    }

    private String constructIndexWhereClause(List<SQLiteIndexElement> indexes) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < indexes.size(); ++i) {
            ret.append(indexes.get(i).getSqliteColumnName() + " = ?");
            if (i >= indexes.size() - 1) continue;
            ret.append(" AND ");
        }
        return ret.toString();
    }

    private void applyKeyBinds(SQLiteStatement statement, List<SQLiteIndexElement> indexElements, Map<String, AttributeValue> key) throws SQLiteException {
        for (int i = 0; i < indexElements.size(); ++i) {
            String attributeName = indexElements.get(i).getDynamoDBAttribute().getAttributeName();
            byte[] value = this.translateKeyAttributeValue(key.get(attributeName));
            statement.bind(i + 1, value);
        }
    }

    protected int applyBinds(SQLiteStatement statement, int startBind, List<byte[]> bindData) throws SQLiteException {
        int endBind = startBind;
        LocalDBUtils.ldAccessAssertTrue(startBind > 0, LocalDBAccessExceptionType.UNEXPECTED_EXCEPTION, "SQL construction issue, binding at location 0.", new Object[0]);
        LocalDBUtils.ldAccessAssertTrue(endBind + bindData.size() - 1 <= statement.getBindParameterCount(), LocalDBAccessExceptionType.UNEXPECTED_EXCEPTION, "SQL construction issue, invalid number of binds.", new Object[0]);
        int j = 0;
        while (j < bindData.size()) {
            statement.bind(endBind, bindData.get(j));
            ++j;
            ++endBind;
        }
        return endBind;
    }

    private void prepareKeyColumnsWithExclusiveStartKey(TableSchemaInfo tableSchema, String indexName, Map<String, AttributeValue> exclusiveStartKey, boolean ascending, boolean isGSIIndex, String trailingHashColName, StringBuilder exclusiveStartKeyClause, List<byte[]> exclusiveStartKeyBinds) {
        if (exclusiveStartKey == null) {
            return;
        }
        String direction = ascending ? ">" : "<";
        AttributeDefinition hashKeyDef = tableSchema.getHashKeyDefinition();
        AttributeDefinition rangeKeyDef = tableSchema.getRangeKeyDefinition();
        ArrayList<String> keyColumns = new ArrayList<String>();
        ArrayList<byte[]> keyBinds = new ArrayList<byte[]>();
        if (indexName == null) {
            keyColumns.add(HASH_VALUE_COLUMN_NAME);
            keyBinds.add(LocalDBUtils.getHashValue(exclusiveStartKey.get(hashKeyDef.getAttributeName())));
            if (rangeKeyDef != null) {
                keyColumns.add(RANGE_KEY_COLUMN_NAME);
                keyBinds.add(SQLiteDBAccessUtils.translateKeyAttributeValue(exclusiveStartKey.get(rangeKeyDef.getAttributeName())));
            }
        } else if (isGSIIndex) {
            String gsiHashKey = tableSchema.getGSIHashIndexElement(indexName).getSqliteColumnName();
            String gsiHashKeyDynamoDBName = SQLiteDBAccessUtils.getGSIKeyDynamoDBName(tableSchema, indexName, KeyType.HASH.toString());
            keyColumns.add(gsiHashKey);
            keyBinds.add(SQLiteDBAccessUtils.translateKeyAttributeValue(exclusiveStartKey.get(gsiHashKeyDynamoDBName)));
            if (tableSchema.getGSIRangeIndexElement(indexName) != null) {
                String gsiRangeKey = tableSchema.getGSIRangeIndexElement(indexName).getSqliteColumnName();
                String gsiRangeKeyDynamoDBName = SQLiteDBAccessUtils.getGSIKeyDynamoDBName(tableSchema, indexName, KeyType.RANGE.toString());
                keyColumns.add(gsiRangeKey);
                keyBinds.add(SQLiteDBAccessUtils.translateKeyAttributeValue(exclusiveStartKey.get(gsiRangeKeyDynamoDBName)));
            }
            if (trailingHashColName != null) {
                keyColumns.add(trailingHashColName);
                byte[] trailHash = null;
                if (trailingHashColName != null) {
                    trailHash = trailingHashColName.equals(HASH_VALUE_COLUMN_NAME) ? LocalDBUtils.getHashValue(exclusiveStartKey.get(hashKeyDef.getAttributeName())) : (trailingHashColName.equals(RANGE_VALUE_COLUMN_NAME) ? LocalDBUtils.getHashValue(exclusiveStartKey.get(rangeKeyDef.getAttributeName())) : LocalDBUtils.getHashValue(exclusiveStartKey.get(hashKeyDef.getAttributeName()), exclusiveStartKey.get(rangeKeyDef.getAttributeName())));
                }
                keyBinds.add(trailHash);
            }
        } else {
            keyColumns.add(HASH_VALUE_COLUMN_NAME);
            keyBinds.add(LocalDBUtils.getHashValue(exclusiveStartKey.get(hashKeyDef.getAttributeName())));
            keyColumns.add(tableSchema.getLSIRangeIndexElement(indexName).getSqliteColumnName());
            String indexKeyDynamoDBName = SQLiteDBAccessUtils.getLSIIndexKeyDynamoDBName(tableSchema, indexName);
            keyBinds.add(SQLiteDBAccessUtils.translateKeyAttributeValue(exclusiveStartKey.get(indexKeyDynamoDBName)));
            if (rangeKeyDef != null) {
                keyColumns.add(RANGE_KEY_COLUMN_NAME);
                keyBinds.add(SQLiteDBAccessUtils.translateKeyAttributeValue(exclusiveStartKey.get(rangeKeyDef.getAttributeName())));
            }
        }
        LocalDBUtils.ldAccessAssertTrue(keyColumns.size() == keyBinds.size(), LocalDBAccessExceptionType.UNEXPECTED_EXCEPTION, "Key columns size should be the same as key binding size for exclusive start key SQL clause.", new Object[0]);
        exclusiveStartKeyClause.append(" AND (");
        for (int i = 0; i < keyColumns.size(); ++i) {
            if (i != 0) {
                exclusiveStartKeyClause.append(" OR (");
            }
            for (int j = 0; j < i; ++j) {
                exclusiveStartKeyClause.append((String)keyColumns.get(j) + " = ? AND ");
                exclusiveStartKeyBinds.add((byte[])keyBinds.get(j));
            }
            exclusiveStartKeyClause.append((String)keyColumns.get(i) + " " + direction + " ?");
            exclusiveStartKeyBinds.add((byte[])keyBinds.get(i));
            if (i == 0) continue;
            exclusiveStartKeyClause.append(") ");
        }
        exclusiveStartKeyClause.append(")");
    }

    private abstract class PutItemSQLiteDBAccessJob<T>
    extends SQLiteDBAccessJob<T> {
        private PutItemSQLiteDBAccessJob() {
        }

        protected void doPutItem(String tableName, Map<String, byte[]> columnNameToValueMap, long itemSizeBytes) throws SQLiteException {
            String[] listOfSQLiteColumns = columnNameToValueMap.keySet().toArray(new String[columnNameToValueMap.size()]);
            String sql = this.buildPutRecordSQL(tableName, columnNameToValueMap, listOfSQLiteColumns);
            logger.debug(sql);
            SQLiteStatement statement = this.getPreparedStatement(sql);
            int i = 1;
            for (String columnName : listOfSQLiteColumns) {
                statement.bind(i, columnNameToValueMap.get(columnName));
                ++i;
            }
            statement.bind(i, itemSizeBytes);
            statement.step();
        }

        protected void doBackfillItem(String tableName, Map<String, byte[]> columnNameToValueMap, Map<String, AttributeValue> item, SQLiteIndexElement rangeKeyIndex, SQLiteIndexElement hashKeyIndex) throws SQLiteException {
            if (columnNameToValueMap.size() == 0) {
                return;
            }
            String[] listOfSQLiteColumns = columnNameToValueMap.keySet().toArray(new String[columnNameToValueMap.size()]);
            boolean hasRangeKey = rangeKeyIndex != null;
            String sql = "UPDATE " + SQLiteDBAccess.escapedTableName(tableName) + " SET " + StringUtils.join((String)", ", (String[])this.appendEachWith(" = ? ", listOfSQLiteColumns)) + " WHERE " + (hashKeyIndex.getSqliteColumnName() + " = ? ") + (hasRangeKey ? " AND " + rangeKeyIndex.getSqliteColumnName() + " = ? " : SQLiteDBAccess.PRIMARY_KEY_INDEX_NAME) + ";";
            logger.debug(sql);
            SQLiteStatement statement = this.getPreparedStatement(sql);
            int i = 1;
            for (String columnName : listOfSQLiteColumns) {
                statement.bind(i, columnNameToValueMap.get(columnName));
                ++i;
            }
            statement.bind(i++, SQLiteDBAccess.this.translateKeyAttributeValue(item.get(hashKeyIndex.getDynamoDBAttribute().getAttributeName())));
            if (hasRangeKey) {
                statement.bind(i++, SQLiteDBAccess.this.translateKeyAttributeValue(item.get(rangeKeyIndex.getDynamoDBAttribute().getAttributeName())));
            }
            statement.step();
        }

        private String[] appendEachWith(String suffix, String[] list) {
            String[] result = new String[list.length];
            for (int i = 0; i < list.length; ++i) {
                result[i] = list[i] + suffix;
            }
            return result;
        }

        private String buildPutRecordSQL(String tableName, Map<String, byte[]> columnNameToValueMap, String[] listOfSQLiteColumns) {
            return "INSERT OR REPLACE INTO " + SQLiteDBAccess.escapedTableName(tableName) + " (" + StringUtils.join((String)", ", (String[])listOfSQLiteColumns) + ",itemSize" + ") VALUES (" + StringUtils.join((String)", ", (String[])SQLiteDBAccess.this.repeat("?", columnNameToValueMap.size())) + ",?);";
        }
    }
}

