/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.shared.access.sqlite;

import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import com.amazonaws.services.dynamodbv2.local.shared.access.LocalDBUtils;
import com.amazonaws.services.dynamodbv2.local.shared.access.sqlite.AmazonDynamoDBOfflineSQLiteJob;
import com.amazonaws.services.dynamodbv2.local.shared.access.sqlite.SQLiteDBAccessUtils;
import com.amazonaws.services.dynamodbv2.local.shared.access.sqlite.SQLiteIndexElement;
import com.amazonaws.services.dynamodbv2.local.shared.access.sqlite.TableSchemaInfo;
import com.amazonaws.services.dynamodbv2.local.shared.exceptions.LocalDBAccessException;
import com.amazonaws.services.dynamodbv2.local.shared.exceptions.LocalDBAccessExceptionType;
import com.amazonaws.services.dynamodbv2.local.shared.mapper.DynamoDBObjectMapper;
import com.amazonaws.services.dynamodbv2.local.shared.model.AttributeValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SQLiteDBAccessJob<T>
extends AmazonDynamoDBOfflineSQLiteJob<T> {
    private static final Logger logger = LogManager.getLogger();
    private static final DynamoDBObjectMapper MAPPER = new DynamoDBObjectMapper();

    protected TableSchemaInfo getTableSchemaInfo2(String tableName) throws SQLiteException, JsonParseException, JsonMappingException, IOException {
        String sql = String.format("SELECT %s FROM %s WHERE %s = %s;", "TableInfo", "dm", "TableName", SQLiteDBAccessUtils.escapedTableName(tableName));
        SQLiteStatement statement = this.getPreparedStatement(sql);
        if (!statement.step()) {
            throw new LocalDBAccessException(LocalDBAccessExceptionType.TABLE_NOT_FOUND);
        }
        return (TableSchemaInfo)MAPPER.readValue(statement.columnBlob(0), TableSchemaInfo.class);
    }

    protected Map<String, AttributeValue> getRecordInternal(TableSchemaInfo tableSchemaInfo, String tableName, Map<String, AttributeValue> primaryKey) throws SQLiteException, IOException {
        Map ret = null;
        List<SQLiteIndexElement> relevantIndexes = tableSchemaInfo.getSqliteIndex().get("");
        StringBuilder sql = new StringBuilder(String.format("SELECT %s FROM %s WHERE ", "ObjectJSON", SQLiteDBAccessUtils.escapedTableName(tableName))).append(SQLiteDBAccessUtils.constructIndexWhereClause(relevantIndexes)).append(";");
        logger.debug(sql.toString());
        SQLiteStatement statement = this.getPreparedStatement(sql.toString());
        SQLiteDBAccessUtils.applyKeyBinds(statement, relevantIndexes, primaryKey);
        if (statement.step()) {
            ret = (Map)MAPPER.readValue(statement.columnBlob(0), DynamoDBObjectMapper.ITEM_TYPE);
        }
        if (statement.step()) {
            LocalDBUtils.ldAccessFail(LocalDBAccessExceptionType.DATA_CORRUPTION, "Given key conditions were not unique. Returned: [%s] and [%s].", ret.toString(), MAPPER.readValue(statement.columnBlob(0), DynamoDBObjectMapper.ITEM_TYPE).toString());
        }
        return ret;
    }
}

