/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.shared.jobs;

import com.amazonaws.services.dynamodbv2.local.shared.jobs.NamedJob;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;

public class JobsRegister {
    private final ExecutorService threadPool;
    private boolean delayTransientStatuses;
    private final Map<String, NamedJob> jobs = new ConcurrentHashMap<String, NamedJob>();

    public JobsRegister(ExecutorService executorService, boolean delayTransientStatuses) {
        this.threadPool = executorService;
        this.delayTransientStatuses = delayTransientStatuses;
    }

    public void schedule(NamedJob job) {
        this.jobs.put(job.name(), job);
        this.threadPool.submit(job);
    }

    public void remove(String jobName) {
        this.jobs.remove(jobName);
    }

    public boolean isRunning(String jobName) {
        return this.jobs.containsKey(jobName);
    }

    public void shutdown() {
        this.threadPool.shutdown();
        for (NamedJob job : this.jobs.values()) {
            job.cancel();
        }
    }

    public boolean shouldDelayTransientStatuses() {
        return this.delayTransientStatuses;
    }
}

