/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.DisableMetricsCollectionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DisableMetricsCollectionRequestMarshaller
implements Marshaller<Request<DisableMetricsCollectionRequest>, DisableMetricsCollectionRequest> {
    @Override
    public Request<DisableMetricsCollectionRequest> marshall(DisableMetricsCollectionRequest disableMetricsCollectionRequest) {
        if (disableMetricsCollectionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DisableMetricsCollectionRequest> request = new DefaultRequest<DisableMetricsCollectionRequest>(disableMetricsCollectionRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DisableMetricsCollection");
        request.addParameter("Version", "2011-01-01");
        if (disableMetricsCollectionRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(disableMetricsCollectionRequest.getAutoScalingGroupName()));
        }
        List<String> metricsList = disableMetricsCollectionRequest.getMetrics();
        int metricsListIndex = 1;
        for (String metricsListValue : metricsList) {
            if (metricsListValue != null) {
                request.addParameter("Metrics.member." + metricsListIndex, StringUtils.fromString(metricsListValue));
            }
            ++metricsListIndex;
        }
        return request;
    }
}

