/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.codedeploy.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RemoveTagsFromOnPremisesInstancesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<Tag> tags;
    private ListWithAutoConstructFlag<String> instanceNames;

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ListWithAutoConstructFlag();
            this.tags.setAutoConstruct(true);
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public RemoveTagsFromOnPremisesInstancesRequest withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public RemoveTagsFromOnPremisesInstancesRequest withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public List<String> getInstanceNames() {
        if (this.instanceNames == null) {
            this.instanceNames = new ListWithAutoConstructFlag();
            this.instanceNames.setAutoConstruct(true);
        }
        return this.instanceNames;
    }

    public void setInstanceNames(Collection<String> instanceNames) {
        if (instanceNames == null) {
            this.instanceNames = null;
            return;
        }
        ListWithAutoConstructFlag instanceNamesCopy = new ListWithAutoConstructFlag(instanceNames.size());
        instanceNamesCopy.addAll(instanceNames);
        this.instanceNames = instanceNamesCopy;
    }

    public RemoveTagsFromOnPremisesInstancesRequest withInstanceNames(String ... instanceNames) {
        if (this.getInstanceNames() == null) {
            this.setInstanceNames(new ArrayList<String>(instanceNames.length));
        }
        for (String value : instanceNames) {
            this.getInstanceNames().add(value);
        }
        return this;
    }

    public RemoveTagsFromOnPremisesInstancesRequest withInstanceNames(Collection<String> instanceNames) {
        if (instanceNames == null) {
            this.instanceNames = null;
        } else {
            ListWithAutoConstructFlag instanceNamesCopy = new ListWithAutoConstructFlag(instanceNames.size());
            instanceNamesCopy.addAll(instanceNames);
            this.instanceNames = instanceNamesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags() + ",");
        }
        if (this.getInstanceNames() != null) {
            sb.append("InstanceNames: " + this.getInstanceNames());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceNames() == null ? 0 : this.getInstanceNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveTagsFromOnPremisesInstancesRequest)) {
            return false;
        }
        RemoveTagsFromOnPremisesInstancesRequest other = (RemoveTagsFromOnPremisesInstancesRequest)obj;
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getInstanceNames() == null ^ this.getInstanceNames() == null) {
            return false;
        }
        return other.getInstanceNames() == null || other.getInstanceNames().equals(this.getInstanceNames());
    }

    @Override
    public RemoveTagsFromOnPremisesInstancesRequest clone() {
        return (RemoveTagsFromOnPremisesInstancesRequest)super.clone();
    }
}

