/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.codedeploy.model.EC2TagFilter;
import com.amazonaws.services.codedeploy.model.TagFilter;
import com.amazonaws.services.codedeploy.model.UpdateDeploymentGroupRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class UpdateDeploymentGroupRequestMarshaller
implements Marshaller<Request<UpdateDeploymentGroupRequest>, UpdateDeploymentGroupRequest> {
    @Override
    public Request<UpdateDeploymentGroupRequest> marshall(UpdateDeploymentGroupRequest updateDeploymentGroupRequest) {
        if (updateDeploymentGroupRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateDeploymentGroupRequest> request = new DefaultRequest<UpdateDeploymentGroupRequest>(updateDeploymentGroupRequest, "AmazonCodeDeploy");
        String target = "CodeDeploy_20141006.UpdateDeploymentGroup";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag autoScalingGroupsList;
            ListWithAutoConstructFlag onPremisesInstanceTagFiltersList;
            ListWithAutoConstructFlag ec2TagFiltersList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (updateDeploymentGroupRequest.getApplicationName() != null) {
                jsonWriter.key("applicationName").value(updateDeploymentGroupRequest.getApplicationName());
            }
            if (updateDeploymentGroupRequest.getCurrentDeploymentGroupName() != null) {
                jsonWriter.key("currentDeploymentGroupName").value(updateDeploymentGroupRequest.getCurrentDeploymentGroupName());
            }
            if (updateDeploymentGroupRequest.getNewDeploymentGroupName() != null) {
                jsonWriter.key("newDeploymentGroupName").value(updateDeploymentGroupRequest.getNewDeploymentGroupName());
            }
            if (updateDeploymentGroupRequest.getDeploymentConfigName() != null) {
                jsonWriter.key("deploymentConfigName").value(updateDeploymentGroupRequest.getDeploymentConfigName());
            }
            if (!((ec2TagFiltersList = (ListWithAutoConstructFlag)updateDeploymentGroupRequest.getEc2TagFilters()) == null || ec2TagFiltersList.isAutoConstruct() && ec2TagFiltersList.isEmpty())) {
                jsonWriter.key("ec2TagFilters");
                jsonWriter.array();
                for (EC2TagFilter ec2TagFiltersListValue : ec2TagFiltersList) {
                    if (ec2TagFiltersListValue == null) continue;
                    jsonWriter.object();
                    if (ec2TagFiltersListValue.getKey() != null) {
                        jsonWriter.key("Key").value(ec2TagFiltersListValue.getKey());
                    }
                    if (ec2TagFiltersListValue.getValue() != null) {
                        jsonWriter.key("Value").value(ec2TagFiltersListValue.getValue());
                    }
                    if (ec2TagFiltersListValue.getType() != null) {
                        jsonWriter.key("Type").value(ec2TagFiltersListValue.getType());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (!((onPremisesInstanceTagFiltersList = (ListWithAutoConstructFlag)updateDeploymentGroupRequest.getOnPremisesInstanceTagFilters()) == null || onPremisesInstanceTagFiltersList.isAutoConstruct() && onPremisesInstanceTagFiltersList.isEmpty())) {
                jsonWriter.key("onPremisesInstanceTagFilters");
                jsonWriter.array();
                for (TagFilter onPremisesInstanceTagFiltersListValue : onPremisesInstanceTagFiltersList) {
                    if (onPremisesInstanceTagFiltersListValue == null) continue;
                    jsonWriter.object();
                    if (onPremisesInstanceTagFiltersListValue.getKey() != null) {
                        jsonWriter.key("Key").value(onPremisesInstanceTagFiltersListValue.getKey());
                    }
                    if (onPremisesInstanceTagFiltersListValue.getValue() != null) {
                        jsonWriter.key("Value").value(onPremisesInstanceTagFiltersListValue.getValue());
                    }
                    if (onPremisesInstanceTagFiltersListValue.getType() != null) {
                        jsonWriter.key("Type").value(onPremisesInstanceTagFiltersListValue.getType());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (!((autoScalingGroupsList = (ListWithAutoConstructFlag)updateDeploymentGroupRequest.getAutoScalingGroups()) == null || autoScalingGroupsList.isAutoConstruct() && autoScalingGroupsList.isEmpty())) {
                jsonWriter.key("autoScalingGroups");
                jsonWriter.array();
                for (String autoScalingGroupsListValue : autoScalingGroupsList) {
                    if (autoScalingGroupsListValue == null) continue;
                    jsonWriter.value(autoScalingGroupsListValue);
                }
                jsonWriter.endArray();
            }
            if (updateDeploymentGroupRequest.getServiceRoleArn() != null) {
                jsonWriter.key("serviceRoleArn").value(updateDeploymentGroupRequest.getServiceRoleArn());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

