/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.LaunchSpecification;
import com.amazonaws.services.ec2.model.SpotInstanceType;
import com.amazonaws.services.ec2.model.transform.RequestSpotInstancesRequestMarshaller;
import java.io.Serializable;
import java.util.Date;

public class RequestSpotInstancesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<RequestSpotInstancesRequest> {
    private String spotPrice;
    private Integer instanceCount;
    private String type;
    private Date validFrom;
    private Date validUntil;
    private String launchGroup;
    private String availabilityZoneGroup;
    private LaunchSpecification launchSpecification;

    public RequestSpotInstancesRequest() {
    }

    public RequestSpotInstancesRequest(String spotPrice) {
        this.setSpotPrice(spotPrice);
    }

    public String getSpotPrice() {
        return this.spotPrice;
    }

    public void setSpotPrice(String spotPrice) {
        this.spotPrice = spotPrice;
    }

    public RequestSpotInstancesRequest withSpotPrice(String spotPrice) {
        this.spotPrice = spotPrice;
        return this;
    }

    public Integer getInstanceCount() {
        return this.instanceCount;
    }

    public void setInstanceCount(Integer instanceCount) {
        this.instanceCount = instanceCount;
    }

    public RequestSpotInstancesRequest withInstanceCount(Integer instanceCount) {
        this.instanceCount = instanceCount;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public RequestSpotInstancesRequest withType(String type) {
        this.type = type;
        return this;
    }

    public void setType(SpotInstanceType type) {
        this.type = type.toString();
    }

    public RequestSpotInstancesRequest withType(SpotInstanceType type) {
        this.type = type.toString();
        return this;
    }

    public Date getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(Date validFrom) {
        this.validFrom = validFrom;
    }

    public RequestSpotInstancesRequest withValidFrom(Date validFrom) {
        this.validFrom = validFrom;
        return this;
    }

    public Date getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(Date validUntil) {
        this.validUntil = validUntil;
    }

    public RequestSpotInstancesRequest withValidUntil(Date validUntil) {
        this.validUntil = validUntil;
        return this;
    }

    public String getLaunchGroup() {
        return this.launchGroup;
    }

    public void setLaunchGroup(String launchGroup) {
        this.launchGroup = launchGroup;
    }

    public RequestSpotInstancesRequest withLaunchGroup(String launchGroup) {
        this.launchGroup = launchGroup;
        return this;
    }

    public String getAvailabilityZoneGroup() {
        return this.availabilityZoneGroup;
    }

    public void setAvailabilityZoneGroup(String availabilityZoneGroup) {
        this.availabilityZoneGroup = availabilityZoneGroup;
    }

    public RequestSpotInstancesRequest withAvailabilityZoneGroup(String availabilityZoneGroup) {
        this.availabilityZoneGroup = availabilityZoneGroup;
        return this;
    }

    public LaunchSpecification getLaunchSpecification() {
        return this.launchSpecification;
    }

    public void setLaunchSpecification(LaunchSpecification launchSpecification) {
        this.launchSpecification = launchSpecification;
    }

    public RequestSpotInstancesRequest withLaunchSpecification(LaunchSpecification launchSpecification) {
        this.launchSpecification = launchSpecification;
        return this;
    }

    @Override
    public Request<RequestSpotInstancesRequest> getDryRunRequest() {
        Request<RequestSpotInstancesRequest> request = new RequestSpotInstancesRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSpotPrice() != null) {
            sb.append("SpotPrice: " + this.getSpotPrice() + ",");
        }
        if (this.getInstanceCount() != null) {
            sb.append("InstanceCount: " + this.getInstanceCount() + ",");
        }
        if (this.getType() != null) {
            sb.append("Type: " + this.getType() + ",");
        }
        if (this.getValidFrom() != null) {
            sb.append("ValidFrom: " + this.getValidFrom() + ",");
        }
        if (this.getValidUntil() != null) {
            sb.append("ValidUntil: " + this.getValidUntil() + ",");
        }
        if (this.getLaunchGroup() != null) {
            sb.append("LaunchGroup: " + this.getLaunchGroup() + ",");
        }
        if (this.getAvailabilityZoneGroup() != null) {
            sb.append("AvailabilityZoneGroup: " + this.getAvailabilityZoneGroup() + ",");
        }
        if (this.getLaunchSpecification() != null) {
            sb.append("LaunchSpecification: " + this.getLaunchSpecification());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSpotPrice() == null ? 0 : this.getSpotPrice().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceCount() == null ? 0 : this.getInstanceCount().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getValidFrom() == null ? 0 : this.getValidFrom().hashCode());
        hashCode = 31 * hashCode + (this.getValidUntil() == null ? 0 : this.getValidUntil().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchGroup() == null ? 0 : this.getLaunchGroup().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZoneGroup() == null ? 0 : this.getAvailabilityZoneGroup().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchSpecification() == null ? 0 : this.getLaunchSpecification().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestSpotInstancesRequest)) {
            return false;
        }
        RequestSpotInstancesRequest other = (RequestSpotInstancesRequest)obj;
        if (other.getSpotPrice() == null ^ this.getSpotPrice() == null) {
            return false;
        }
        if (other.getSpotPrice() != null && !other.getSpotPrice().equals(this.getSpotPrice())) {
            return false;
        }
        if (other.getInstanceCount() == null ^ this.getInstanceCount() == null) {
            return false;
        }
        if (other.getInstanceCount() != null && !other.getInstanceCount().equals(this.getInstanceCount())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getValidFrom() == null ^ this.getValidFrom() == null) {
            return false;
        }
        if (other.getValidFrom() != null && !other.getValidFrom().equals(this.getValidFrom())) {
            return false;
        }
        if (other.getValidUntil() == null ^ this.getValidUntil() == null) {
            return false;
        }
        if (other.getValidUntil() != null && !other.getValidUntil().equals(this.getValidUntil())) {
            return false;
        }
        if (other.getLaunchGroup() == null ^ this.getLaunchGroup() == null) {
            return false;
        }
        if (other.getLaunchGroup() != null && !other.getLaunchGroup().equals(this.getLaunchGroup())) {
            return false;
        }
        if (other.getAvailabilityZoneGroup() == null ^ this.getAvailabilityZoneGroup() == null) {
            return false;
        }
        if (other.getAvailabilityZoneGroup() != null && !other.getAvailabilityZoneGroup().equals(this.getAvailabilityZoneGroup())) {
            return false;
        }
        if (other.getLaunchSpecification() == null ^ this.getLaunchSpecification() == null) {
            return false;
        }
        return other.getLaunchSpecification() == null || other.getLaunchSpecification().equals(this.getLaunchSpecification());
    }

    @Override
    public RequestSpotInstancesRequest clone() {
        return (RequestSpotInstancesRequest)super.clone();
    }
}

