/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeNetworkAclsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeNetworkAclsRequestMarshaller
implements Marshaller<Request<DescribeNetworkAclsRequest>, DescribeNetworkAclsRequest> {
    @Override
    public Request<DescribeNetworkAclsRequest> marshall(DescribeNetworkAclsRequest describeNetworkAclsRequest) {
        if (describeNetworkAclsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeNetworkAclsRequest> request = new DefaultRequest<DescribeNetworkAclsRequest>(describeNetworkAclsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeNetworkAcls");
        request.addParameter("Version", "2015-03-01");
        List<String> networkAclIdsList = describeNetworkAclsRequest.getNetworkAclIds();
        int networkAclIdsListIndex = 1;
        for (String networkAclIdsListValue : networkAclIdsList) {
            if (networkAclIdsListValue != null) {
                request.addParameter("NetworkAclId." + networkAclIdsListIndex, StringUtils.fromString(networkAclIdsListValue));
            }
            ++networkAclIdsListIndex;
        }
        List<Filter> filtersList = describeNetworkAclsRequest.getFilters();
        int filtersListIndex = 1;
        for (Filter filtersListValue : filtersList) {
            Filter filterMember = filtersListValue;
            if (filterMember != null) {
                if (filterMember.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(filterMember.getName()));
                }
                List<String> valuesList = filterMember.getValues();
                int valuesListIndex = 1;
                for (String valuesListValue : valuesList) {
                    if (valuesListValue != null) {
                        request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                    }
                    ++valuesListIndex;
                }
            }
            ++filtersListIndex;
        }
        return request;
    }
}

