/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.ClientData;
import com.amazonaws.services.ec2.model.ImageDiskContainer;
import com.amazonaws.services.ec2.model.ImportImageRequest;
import com.amazonaws.services.ec2.model.UserBucket;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class ImportImageRequestMarshaller
implements Marshaller<Request<ImportImageRequest>, ImportImageRequest> {
    @Override
    public Request<ImportImageRequest> marshall(ImportImageRequest importImageRequest) {
        ClientData clientDataClientData;
        if (importImageRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ImportImageRequest> request = new DefaultRequest<ImportImageRequest>(importImageRequest, "AmazonEC2");
        request.addParameter("Action", "ImportImage");
        request.addParameter("Version", "2015-03-01");
        if (importImageRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(importImageRequest.getDescription()));
        }
        List<ImageDiskContainer> diskContainersList = importImageRequest.getDiskContainers();
        int diskContainersListIndex = 1;
        for (ImageDiskContainer diskContainersListValue : diskContainersList) {
            ImageDiskContainer imageDiskContainerMember = diskContainersListValue;
            if (imageDiskContainerMember != null) {
                UserBucket userBucketUserBucket;
                if (imageDiskContainerMember.getDescription() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".Description", StringUtils.fromString(imageDiskContainerMember.getDescription()));
                }
                if (imageDiskContainerMember.getFormat() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".Format", StringUtils.fromString(imageDiskContainerMember.getFormat()));
                }
                if (imageDiskContainerMember.getUrl() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".Url", StringUtils.fromString(imageDiskContainerMember.getUrl()));
                }
                if ((userBucketUserBucket = imageDiskContainerMember.getUserBucket()) != null) {
                    if (userBucketUserBucket.getS3Bucket() != null) {
                        request.addParameter("DiskContainer." + diskContainersListIndex + ".UserBucket.S3Bucket", StringUtils.fromString(userBucketUserBucket.getS3Bucket()));
                    }
                    if (userBucketUserBucket.getS3Key() != null) {
                        request.addParameter("DiskContainer." + diskContainersListIndex + ".UserBucket.S3Key", StringUtils.fromString(userBucketUserBucket.getS3Key()));
                    }
                }
                if (imageDiskContainerMember.getDeviceName() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".DeviceName", StringUtils.fromString(imageDiskContainerMember.getDeviceName()));
                }
                if (imageDiskContainerMember.getSnapshotId() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".SnapshotId", StringUtils.fromString(imageDiskContainerMember.getSnapshotId()));
                }
            }
            ++diskContainersListIndex;
        }
        if (importImageRequest.getLicenseType() != null) {
            request.addParameter("LicenseType", StringUtils.fromString(importImageRequest.getLicenseType()));
        }
        if (importImageRequest.getHypervisor() != null) {
            request.addParameter("Hypervisor", StringUtils.fromString(importImageRequest.getHypervisor()));
        }
        if (importImageRequest.getArchitecture() != null) {
            request.addParameter("Architecture", StringUtils.fromString(importImageRequest.getArchitecture()));
        }
        if (importImageRequest.getPlatform() != null) {
            request.addParameter("Platform", StringUtils.fromString(importImageRequest.getPlatform()));
        }
        if ((clientDataClientData = importImageRequest.getClientData()) != null) {
            if (clientDataClientData.getUploadStart() != null) {
                request.addParameter("ClientData.UploadStart", StringUtils.fromDate(clientDataClientData.getUploadStart()));
            }
            if (clientDataClientData.getUploadEnd() != null) {
                request.addParameter("ClientData.UploadEnd", StringUtils.fromDate(clientDataClientData.getUploadEnd()));
            }
            if (clientDataClientData.getUploadSize() != null) {
                request.addParameter("ClientData.UploadSize", StringUtils.fromDouble(clientDataClientData.getUploadSize()));
            }
            if (clientDataClientData.getComment() != null) {
                request.addParameter("ClientData.Comment", StringUtils.fromString(clientDataClientData.getComment()));
            }
        }
        if (importImageRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString(importImageRequest.getClientToken()));
        }
        if (importImageRequest.getRoleName() != null) {
            request.addParameter("RoleName", StringUtils.fromString(importImageRequest.getRoleName()));
        }
        return request;
    }
}

