/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.ModifyVpcAttributeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyVpcAttributeRequestMarshaller
implements Marshaller<Request<ModifyVpcAttributeRequest>, ModifyVpcAttributeRequest> {
    @Override
    public Request<ModifyVpcAttributeRequest> marshall(ModifyVpcAttributeRequest modifyVpcAttributeRequest) {
        if (modifyVpcAttributeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyVpcAttributeRequest> request = new DefaultRequest<ModifyVpcAttributeRequest>(modifyVpcAttributeRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyVpcAttribute");
        request.addParameter("Version", "2015-03-01");
        if (modifyVpcAttributeRequest.getVpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString(modifyVpcAttributeRequest.getVpcId()));
        }
        if (modifyVpcAttributeRequest.isEnableDnsSupport() != null) {
            request.addParameter("EnableDnsSupport.Value", StringUtils.fromBoolean(modifyVpcAttributeRequest.isEnableDnsSupport()));
        }
        if (modifyVpcAttributeRequest.isEnableDnsHostnames() != null) {
            request.addParameter("EnableDnsHostnames.Value", StringUtils.fromBoolean(modifyVpcAttributeRequest.isEnableDnsHostnames()));
        }
        return request;
    }
}

