/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.ReportInstanceStatusRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class ReportInstanceStatusRequestMarshaller
implements Marshaller<Request<ReportInstanceStatusRequest>, ReportInstanceStatusRequest> {
    @Override
    public Request<ReportInstanceStatusRequest> marshall(ReportInstanceStatusRequest reportInstanceStatusRequest) {
        if (reportInstanceStatusRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ReportInstanceStatusRequest> request = new DefaultRequest<ReportInstanceStatusRequest>(reportInstanceStatusRequest, "AmazonEC2");
        request.addParameter("Action", "ReportInstanceStatus");
        request.addParameter("Version", "2015-03-01");
        List<String> instancesList = reportInstanceStatusRequest.getInstances();
        int instancesListIndex = 1;
        for (String instancesListValue : instancesList) {
            if (instancesListValue != null) {
                request.addParameter("InstanceId." + instancesListIndex, StringUtils.fromString(instancesListValue));
            }
            ++instancesListIndex;
        }
        if (reportInstanceStatusRequest.getStatus() != null) {
            request.addParameter("Status", StringUtils.fromString(reportInstanceStatusRequest.getStatus()));
        }
        if (reportInstanceStatusRequest.getStartTime() != null) {
            request.addParameter("StartTime", StringUtils.fromDate(reportInstanceStatusRequest.getStartTime()));
        }
        if (reportInstanceStatusRequest.getEndTime() != null) {
            request.addParameter("EndTime", StringUtils.fromDate(reportInstanceStatusRequest.getEndTime()));
        }
        List<String> reasonCodesList = reportInstanceStatusRequest.getReasonCodes();
        int reasonCodesListIndex = 1;
        for (String reasonCodesListValue : reasonCodesList) {
            if (reasonCodesListValue != null) {
                request.addParameter("ReasonCode." + reasonCodesListIndex, StringUtils.fromString(reasonCodesListValue));
            }
            ++reasonCodesListIndex;
        }
        if (reportInstanceStatusRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(reportInstanceStatusRequest.getDescription()));
        }
        return request;
    }
}

