/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.workspaces.model.RebuildRequest;
import com.amazonaws.services.workspaces.model.RebuildWorkspacesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class RebuildWorkspacesRequestMarshaller
implements Marshaller<Request<RebuildWorkspacesRequest>, RebuildWorkspacesRequest> {
    @Override
    public Request<RebuildWorkspacesRequest> marshall(RebuildWorkspacesRequest rebuildWorkspacesRequest) {
        if (rebuildWorkspacesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RebuildWorkspacesRequest> request = new DefaultRequest<RebuildWorkspacesRequest>(rebuildWorkspacesRequest, "AmazonWorkspaces");
        String target = "WorkspacesService.RebuildWorkspaces";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            ListWithAutoConstructFlag rebuildWorkspaceRequestsList = (ListWithAutoConstructFlag)rebuildWorkspacesRequest.getRebuildWorkspaceRequests();
            if (!(rebuildWorkspaceRequestsList == null || rebuildWorkspaceRequestsList.isAutoConstruct() && rebuildWorkspaceRequestsList.isEmpty())) {
                jsonWriter.key("RebuildWorkspaceRequests");
                jsonWriter.array();
                for (RebuildRequest rebuildWorkspaceRequestsListValue : rebuildWorkspaceRequestsList) {
                    if (rebuildWorkspaceRequestsListValue == null) continue;
                    jsonWriter.object();
                    if (rebuildWorkspaceRequestsListValue.getWorkspaceId() != null) {
                        jsonWriter.key("WorkspaceId").value(rebuildWorkspaceRequestsListValue.getWorkspaceId());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

