var tutorial;

tutorial = {
  number: -1,
  start: function() {
    this.number = -1;
    this.next();
    Sandboss.outputAce("");
    return Sandboss.startNavBar(this.content.length);
  },
  next: function() {
    var isFirst, isLast, lessonObj;
    if (this.number === this.content.length - 1) {
      return this.output("You have reached the end of the tutorial", "<p></p>", false, false, false);
    } else {
      this.number++;
      lessonObj = this.content[this.number];
      isFirst = this.number === 0;
      isLast = this.number === (this.content.length - 1);
      this.output(lessonObj.title, lessonObj.console, true, isFirst, isLast);
      if (lessonObj.editor !== "") {
        return Sandboss.outputAce(lessonObj.editor);
      }
    }
  },
  prev: function() {
    var isFirst, isLast, lessonObj;
    if (this.number <= 0) {
      this.output("You are out of the bounds of the tutorial", "<p><img src='images/dog.jpg' alt='Amazon dog'/></p>", false, false, false);
      return;
    }
    this.number--;
    lessonObj = this.content[this.number];
    isFirst = this.number === 0;
    isLast = this.number === (this.content.length - 1);
    this.output(lessonObj.title, lessonObj.console, true, isFirst, isLast);
    if (lessonObj.editor !== "") {
      return Sandboss.outputAce(lessonObj.editor);
    }
  },
  steps: function() {
    var key, output;
    output = '<ol>';
    for (key in this.content) {
      output += "<li><a onclick=\"REPLIT.jsrepl.eval('tutorial.step(" + (key * 1 + 1) + ")')\">" + this.content[key].title + "</a></li>";
    }
    output += '</ol>';
    return this.output("Table of Contents", output);
  },
  step: function(key) {
    var stepContent;
    key -= 1;
    if (key < 0 || key >= this.content.length) {
      stepContent = "<div class=\"alert alert-icon\"><a class=\"close\" data-dismiss=\"alert\" href=\"#\">×</a><h3>Invalid Lesson Number!</h3><p>Please select a number from <strong>0 - (@content.length -1)</strong></p></div>";
      return Sandboss.dumpHtml(stepContent);
    } else {
      this.number = key - 1;
      return this.next();
    }
  },
  output: function(title, content, isLesson, isFirst, isLast) {
    var out;
    out = "<div class=\"tutorial\"><h2>" + title + "</h2>" + content + "</div>";
    return Sandboss.dumpHtml(out);
  },
  help: function() {
    var helpContent;
    helpContent = "<p>The following tutorial will help you get started with DynamoDB. During the tutorial you will have the directions and results displayed on the right terminal and write the code on the left editor.<br><br>Use the following commands to go through the tutorial:</p><ul><li><span class='code'>tutorial.start()</span>: Starts to the beginning of the tutorial</li><li><span class='code'>tutorial.next()</span>: Goes to the next step of the tutorial</li><li><span class='code'>tutorial.prev()</span>: Goes to the previous step of the tutorial</li><li><span class='code'>tutorial.steps()</span>: Lists the tutorial's table of contents</li><li><span class='code'>tutorial.step(number)</span>: Jumps to a specific step in the tutorial</li><li><span class='code'>tutorial.help()</span></li></ul>";
    return this.output('Tutorial Help', helpContent);
  },
  content: [
    {
      title: "Getting Started",
      console: "<p>Let's get started with <a href='http://aws.amazon.com/dynamodb/'>Amazon DynamoDB</a> and the shell by taking a quick tour. We'll create some sample tables, load them with data, and perform some queries. For a more in-depth introduction, visit the <a href='http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Introduction.html'>Amazon DynamoDB Developer Guide</a>. A documentation link will always be below at the foot of the page.<br>To go to the next step in the tutorial, type <span class='code'>tutorial.next()</span>. You can also type <span class='code'>tutorial.help()</span> for a listing of available commands, or <span class='code'>tutorial.steps()</span> to list the table of contents.</p>",
      editor: " "
    }, {
      title: "Using the Shell",
      console: "<p>If this is your first time using the JavaScript Shell, here's a basic overview of how to use it: <ul><li>The window on the right is your shell. Every time you press <span class='code'>Enter</span>, your JavaScript code is executed.</li><li>The window on your left is your code editor. To run the code in the editor, you can press the <i class='icon-play' aria-label='play' role='img'></i> button or press <span class='code'>Ctrl+Enter</span>.</li><li>Within the code editor, <span class='code'>Ctrl+Space</span> pulls up code snippets based on what you have typed, including shortcuts for calling the DynamoDB APIs</li><li>The <i class=\"icon-code\" aria-label=\"quote-left\" role=\"img\"></i> icon at the top of the screen shows example code templates for calling the DynamoDB APIs.</li><li>The <i class=\"icon-question-sign color-text-blue\" aria-label=\"question-sign\" role=\"img\"></i> icon at the top of the screen describes the rest of the the features and shortcuts in the shell.</li></ul>That's enough about the JavaScript Shell for now.  Let's get back to learning about Amazon DynamoDB.\n</p>",
      editor: " "
    }, {
      title: "The Image Tag Demo Application",
      console: "<p>Suppose you are building an image tagging application. With this application, users can assign tags to images, vote on their favorite images, and browse images by tag and by popularity. In this exercise, we will model the application by creating three tables:</p><br><p><img src='images/dynamodb-image-tag-demo-data-model.png' alt='DynamoDB Image Tag Demo Data Model' height='280px'/></p><ul><li><span class='code'>Image</span>: Stores each image URL and the number of votes for the image</li><li><span class='code'>Tag</span>: Stores the each tag and the number of images with that tag</li><li><span class='code'>ImageTag</span>: Stores the association between images and tags</li></ul>",
      editor: " "
    }, {
      title: "Creating the Image Table",
      console: "<p>First, we'll create the Image table. For an overview of the data model of DynamoDB, such as Tables, Items, and Attributes, see the <a href='http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html'>Data Model section of the Developer Guide.</a></p>",
      editor: " "
    }, {
      title: "CreateTable and Calling APIs",
      console: "<p>The CreateTable request is made up of a <span class='code'>params</span> object, which is then passed into the <span class='code'>createTable</span> call in the DynamoDB client. Calls to DynamoDB using the <a href='http://aws.amazon.com/sdkforbrowser/'>AWS SDK for JavaScript</a> are asynchronous, meaning that the instead of the function returning the results when the call completes, the callback that you pass into the method is executed. You can see that the <span class='code'>TableName</span> parameter is filled in. Next, we'll walk through the additional arguments</p>",
      editor: "// This CreateTable request will create the Image table.\n// With DynamoDB Local, tables are created right away. If you are calling\n// a real DynamoDB endpoint, you will need to wait for the table to become\n// ACTIVE before you can use it. See also dynamodb.waitFor().\nvar params = {\n    // The name of the table to create\n    TableName: 'Image'\n\n    // ...more parameters\n};\nconsole.log(\"The CreateTable params aren't complete yet. Continue on to the next steps of the tutorial.\");\n//dynamodb.createTable(params, function(err, data) {\n//    if (err) print(err); // an error occurred\n//    else print(data); // successful response\n//    console.log(\"CreateTable returned\")\n//});"
    }, {
      title: "CreateTable: Primary Keys",
      console: "<p>Next, the <a href=\"http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_CreateTable.html\">CreateTable</a> request needs a <a href='http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModel.PrimaryKey'>primary key schema</a>. For the <span class='code'>Image</span> table, we will use the <span class='code'>Id</span> attribute as a hash-only primary key schema. This means that each item in the table is uniquely identified by its <span class='code'>Id</span> attribute. DynamoDB automatically builds an index on the primary key, allowing for efficient queries.</p>",
      editor: "// This CreateTable request will create the Image table.\n// With DynamoDB Local, tables are created right away. If you are calling\n// a real DynamoDB endpoint, you will need to wait for the table to become\n// ACTIVE before you can use it. See also dynamodb.waitFor().\nvar params = {\n    TableName: 'Image',\n    KeySchema: [\n        {\n            AttributeName: 'Id',\n            KeyType: 'HASH'\n        }\n    ],\n    AttributeDefinitions: [\n        {\n            AttributeName: 'Id',\n            AttributeType: 'S'\n        }\n    ],\n\n    // ...more parameters\n};\nconsole.log(\"The CreateTable params aren't complete yet. Continue on to the next steps of the tutorial.\");\n//dynamodb.createTable(params, function(err, data) {\n//    if (err) print(err); // an error occurred\n//    else print(data); // successful response\n//    console.log(\"CreateTable returned\")\n//});"
    }, {
      title: "CreateTable: Provisioned Throughput",
      console: "<p>Finally, when you create a table, you specify how much <a href='http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html'>provisioned throughput</a> capacity you want to reserve for reads and writes. DynamoDB will reserve the necessary machine resources to meet your throughput needs while ensuring consistent, low-latency performance. You can increase or decrease the provisioned throughput later using the <span class='code'>UpdateTable</span> API or using the <a href='https://console.aws.amazon.com/dynamodb/home'>DynamoDB Console</a>. Read and write capacity units translate roughly to how many read and write requests you'll be able to make to your table per-second, varying based on the size of the items in your request. For now, we've filled in the minimum of 1 read and write capacity unit.</p>",
      editor: "// This CreateTable request will create the Image table.\n// With DynamoDB Local, tables are created right away. If you are calling\n// a real DynamoDB endpoint, you will need to wait for the table to become\n// ACTIVE before you can use it. See also dynamodb.waitFor().\nvar params = {\n    TableName: 'Image',\n    KeySchema: [\n        {\n            AttributeName: 'Id',\n            KeyType: 'HASH'\n        }\n    ],\n    AttributeDefinitions: [\n        {\n            AttributeName: 'Id',\n            AttributeType: 'S'\n        }\n    ],\n    ProvisionedThroughput:  {\n        ReadCapacityUnits: 1,\n        WriteCapacityUnits: 1\n    }\n};\nconsole.log(\"The CreateTable params aren't complete yet. Continue on to the next steps of the tutorial.\");\n//dynamodb.createTable(params, function(err, data) {\n//    if (err) print(err); // an error occurred\n//    else print(data); // successful response\n//    console.log(\"CreateTable returned\")\n//});"
    }, {
      title: "CreateTable: Putting It All Together",
      console: "<p>The CreateTable API returns the same type of information as the <span class='code'>describeTable</span> API. This information includes the table's <span class='code'>Status</span>, such as <span class='code'>CREATING</span>, <span class='code'>UPDATING</span>, or <span class='code'>ACTIVE</span>. When you create a table, you need to wait until the table becomes ACTIVE before you can use it. Since this tutorial calls DynamoDB Local, however, tables become <span class='code'>ACTIVE</span> immediately.</p></br><p>Now that you have a CreateTable request fully constructed, run it! Either click the <i class='icon-play' aria-label='play' role='img'></i> arrow between the two windows, or type <span class='code'>Ctrl+Enter</span> in the code editor window to copy over and execute the command from the text editor to the shell.</p><br>",
      editor: "// This CreateTable request will create the Image table.\n// With DynamoDB Local, tables are created right away. If you are calling\n// a real DynamoDB endpoint, you will need to wait for the table to become\n// ACTIVE before you can use it. See also dynamodb.waitFor().\nvar params = {\n    TableName: 'Image',\n    KeySchema: [\n        {\n            AttributeName: 'Id',\n            KeyType: 'HASH'\n        }\n    ],\n    AttributeDefinitions: [\n        {\n            AttributeName: 'Id',\n            AttributeType: 'S'\n        }\n    ],\n    ProvisionedThroughput:  {\n        ReadCapacityUnits: 1,\n        WriteCapacityUnits: 1\n    }\n};\nconsole.log(\"Creating the Image table\");\ndynamodb.createTable(params, function(err, data) {\n    if (err) print(err); // an error occurred\n    else print(data); // successful response\n});"
    }, {
      title: "PutItem: Adding Items to the Image Table",
      console: "<p>Now that you have a table created, you can add <a href='http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithItems.html'>items</a> to the table using the <a href='http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_PutItem.html'>PutItem API</a>. This request puts a new Image item into the Image table. An Item is a map of attribute name to attribute value. Each attribute value in an item must be one of the <a href='http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModel.DataTypes'>supported data types</a>. This example puts a new item with 3 attributes: <span class='code'>Id</span>, <span class='code'>DateAdded</span>, and <span class='code'>VoteCount</span>. You can see more details about the PutItem API in the <a href='http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithItems.html'>Working with Items</a> section of the Developer Guide.</p><br><p>Run the PutItem command now (<i class='icon-play' aria-label='play' role='img'></i>). Notice that by default, this API does not return anything.</p>",
      editor: "// The PutItem API inserts a new item into DynamoDB.\n// If an item already exists with the same primary key value,\n// the item is replaced with the new item.\n// The API has several other useful parameters not shown here, including:\n//  * Expected: DynamoDB will perform the write only if certain attributes\n//    match the values you expect them to have\n//  * ReturnValues: DynamoDB can return the value you are replacing\nvar params = {\n    TableName: 'Image',\n    Item: {\n        Id: 'dynamodb.png',\n        DateAdded: new Date().toISOString(),\n        VoteCount: 0\n    }\n};\nconsole.log(\"Calling PutItem\");\nprint(params);\ndynamodb.putItem(params, function(err, data) {\n    if (err) print(err); // an error occurred\n    else console.log(\"PutItem returned successfully\");\n});"
    }, {
      title: "GetItem: Fetching Your New Image Item",
      console: "<p>Now that we have put an item into the Image table, you can retrieve it using the <a href='http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_GetItem.html'>GetItem API</a>. This API supports retrieving an item where you know its exact primary key attribute value(s). In this case, the primary key of the <span class='code'>Image</span> table is only the <span class='code'>Id</span> attribute.</p><br><p>You can see the results of a GetItem call by executing the code with the <i class='icon-play' aria-label='play' role='img'></i> button.</p>",
      editor: "// GetItem retrieves an item by its exact primary key.\n// This API also has a ConsistentRead parameter for choosing between\n// strictly and eventually consistent read consistency.\nvar params = {\n    TableName: 'Image',\n    Key: {\n        Id: 'dynamodb.png'\n    }\n};\nconsole.log(\"Calling GetItem\");\ndynamodb.getItem(params, function(err, data) {\n    if (err) print(err); // an error occurred\n    else print(data); // successful response\n});"
    }, {
      title: "BatchWriteItem: Making Things Interesting With More Data",
      console: "<p>To make things more interesting for other examples, let’s add more items to the <span class='code'>Image</span> table. The DynamoDB <a href=\"http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_BatchWriteItem.html\">BatchWriteItem</a> API supports writing up to 25 items at a time. Each request in the BatchWriteItem call is processed separately, meaning that some can fail while others succeed. Therefore it is important to continue to call the <span class='code'>BatchWriteItem</span> API until all of the calls succeed.</p><br><p>Run the code with the <i class='icon-play' aria-label='play' role='img'></i> button to populate the table with data.</p>",
      editor: "// The BatchWriteItem takes up to 25 requests, some of which may succeed,\n// and others needing to be retried. This example program takes in a list of requests\n// that is larger than the batch size, and calls BatchWriteItem multiple times until\n// all of the items have been written.\nvar params = {\n    // RequestItems is a map of TableName to Requests\n    RequestItems: {\n        Image: [\n            {\n                PutRequest: {\n                    Item: {\n                        Id: 'sqs.png',\n                        DateAdded: new Date().toISOString(),\n                        VoteCount: 0 \n                    }\n                }\n            },\n            {\n                PutRequest: {\n                    Item: {\n                        Id: 'kinesis.png',\n                        DateAdded: new Date().toISOString(),\n                        VoteCount: 0\n                    }\n                }\n            }\n        ]\n    }\n};\n\n// Generate some more requests and add them to the params map\nvar urls = [ 'android.png', 'appstream.png', 'cli.png', 'cloudformation.png',\n    'cloudfront.png', 'cloudsearch.png', 'cloudtrail.png', 'cloudwatch.png', 'data-pipeline.png',\n    'direct-connect.png', 'dotnet.png', 'dynamodb.png', 'ec2.png', 'eclipse.png', 'elasticache.png',\n    'elastic-beanstalk.png', 'elb.png', 'emr.png', 'glacier.png', 'iam.png', 'ios.png', 'java.png',\n    'nodejs.png', 'opsworks.png', 'php.png', 'powershell.png', 'python.png', 'rds.png', 'redshift.png',\n    'route53.png', 'ruby.png', 's3.png', 'ses.png', 'sns.png', 'storage-gateway.png', 'swf.png',\n    'transcoding.png', 'visual-studio.png', 'vpc.png'\n];\n\n// Iterate over all of the additional URLs and keep kicking off batches of up to 25 items\nwhile (urls.length > 0) {\n\n    // Pull off up to 25 items from the list\n    for (var i = params.RequestItems.Image.length; i < 25; i++) {\n\n        // Nothing else to add to the batch if the input list is empty\n        if (urls.length === 0) {\n            break;\n        }\n\n        // Take a URL from the list and add a new PutRequest to the list of requests\n        // targeted at the Image table\n        url = urls.pop();\n        params.RequestItems.Image.push(\n            {\n                PutRequest: {\n                    Item: {\n                        Id: url,\n                        DateAdded: new Date().toISOString(),\n                        VoteCount: 0\n                    }\n                }\n            }\n        );\n    }\n    // Kick off this batch of requests\n    console.log(\"Calling BatchWriteItem with a new batch of \"\n            + params.RequestItems.Image.length + \" items\");\n    dynamodb.batchWriteItem(params, doBatchWriteItem);\n\n    // Initialize a new blank params variable\n    params = {\n        RequestItems: {\n            Image: []\n        }\n    };\n}\n\n// A callback that repeatedly calls BatchWriteItem until all of the writes have completed\nfunction doBatchWriteItem(err, data) {\n    if (err) {\n        print(err); // an error occurred\n    } else {\n        if ('UnprocessedItems' in data && 'Image' in data.UnprocessedItems) {\n            // More data. Call again with the unprocessed items.\n            var params = {\n                RequestItems: data.UnprocessedItems\n            };\n            console.log(\"Calling BatchWriteItem again to retry \"\n                + params.RequestItems.Image.length + \"UnprocessedItems\");\n            dynamodb.batchWriteItem(params, doBatchWriteItem);\n        } else {\n            console.log(\"BatchWriteItem processed all items in the batch\");\n        }\n    }\n}"
    }, {
      title: "Scan: Reading Everything Out of the Table",
      console: "<p>Now you can retrieve all of the items in the <span class='code'>Image</span> table using the <a href='http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_Scan.html'>Scan</a> API. This API is not an efficient way to query for specific items in your table, but can be useful for periodically sweeping through all of the items in a table for background processing. More information about Scan performance and best practices is available in the <a href='http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html'>Developer Guide</a>.</p><br><p>Run the Scan code with the <i class='icon-play' aria-label='play' role='img'></i> button to see the some of the data in the table.</p>",
      editor: "// Invokes the Scan API to retrieve only one \"page\" of data from the table.\n// It needs to be called repeatedly to scan the whole table (this will be shown next)\n// If you are scanning a large table, make sure to follow the best practices\n// as described in the developer guide.\nvar params = {\n    TableName: 'Image',\n    Limit: 5  // Limits the number of results per page (beyond the default 1MB limit)\n};\n\nconsole.log(\"Calling the Scan API on the Image table\");\ndynamodb.scan(params, function(err, data) {\n    if (err) {\n        print(err); // an error occurred\n    } else {\n        console.log(\"The Scan call evaluated \" + data.ScannedCount + \" items\");\n        print(data); // successful response\n    }\n});"
    }, {
      title: "Scan: Paginating Through Results",
      console: "<p>The <a href=''>Scan API</a> is a paginated API, meaning that you have to call it repeatedly in order to retrieve all of the data in your table. One call to Scan will evaluate up to 1 MB of data, or the number of items you specify in the Limit parameter. This code calls the Scan API repeatedly, each time passing in the <span class='code'>LastEvaluatedKey</span> parameter from the previous response in as the <span class='code'>ExclusiveStartKey</span> parameter in the next request.</p><br><p>Run the Scan code with the <i class='icon-play' aria-label='play' role='img'></i> button to see all of the data in the table.</p>",
      editor: "// This example repeatedly scans a number of items at a time, following the pagination token until\n// the scan reaches the end of the table.\nvar params = {\n    TableName: 'Image',\n    Limit: 15  // Limits the number of results per page\n};\n\n// A callback that paginates through an entire DynamoDB table\nfunction doScan(err, data) {\n    if (err) {\n        print(err); // an error occurred\n    } else {\n        // Print the results\n        console.log(\"Last scan processed \" + data.ScannedCount + \" items: \");\n        var images = [];\n        for (var i = 0; i < data.Items.length; i++ ) {\n            images.push(data.Items[i].Id);\n        }\n        console.log(\" \"  + images.join(\", \"));\n\n        // More data.  Keep calling scan.\n        if ('LastEvaluatedKey' in data) {\n            console.log(\"Last Scan evaluated \" + data.ScannedCount + \" items. \"\n                + \"Calling Scan again for another page of results\");\n\n            params.ExclusiveStartKey = data.LastEvaluatedKey;\n            dynamodb.scan(params, doScan);\n        } else {\n            console.log(\"*** Finished the scan ***\");\n        }\n    }\n}\n\n// Kick off the scan\nconsole.log(\"Starting a Scan of the Image table\");\ndynamodb.scan(params, doScan);"
    }, {
      title: "Scan: Easier pagination with the JavaScript SDK",
      console: "<p>Writing all that extra code to deal with pagination can be a bit tedious. Fortunately the AWS SDK for JavaScript offers a helpful pagination function that you can use on any of DynamoDB's paginated APIs.</p><br><p>Run the Scan code with the <i class='icon-play' aria-label='play' role='img'></i> button to see all of the data in the table.</p>",
      editor: "// This example repeatedly scans a number of items at a time, following the pagination token until\n// the scan reaches the end of the table.\nvar params = {\n    TableName: 'Image',\n    Limit: 15  // Limits the number of results per page\n};\n\n// Kick off the scan\nconsole.log(\"Starting a Scan of the Image table\");\ndynamodb.scan(params).eachPage(function(err, data) {\n    if (err) {\n        print(err); // an error occurred\n    } else if (data) {\n        console.log(\"Last scan processed \" + data.ScannedCount + \" items: \");\n        var images = [];\n        for (var i = 0; i < data.Items.length; i++ ) {\n            images.push(data.Items[i].Id);\n        }\n        console.log(\" \"  + images.join(\", \"));\n    } else {\n        console.log(\"*** Finished scan ***\");\n    }\n});"
    }, {
      title: "CreateTable: More Interesting Tables",
      console: "<p>Since the Image table has a Hash-only <a href=\n'http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModel.PrimaryKey'>primary key schema</a>, and does not have any secondary indexes, it behaves like a key-value store, where the only efficient and scalable operations on the table are where you know exactly what item you want to retrieve. Next, let’s create another table that will support more complex queries.</p>",
      editor: " "
    }, {
      title: "CreateTable: Tagging Images With the ImageTag Table",
      console: "<p>Storing images is useful, but this Image Tagging application also needs to support assigning tags to images, and querying for all images given a particular tag. To accomplish this, create a new table called <span class='code'>ImageTag</span> to associate each image with its corresponding tag.<br><br>The table uses a <a href='http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModel.PrimaryKey'>Hash-Range primary key schema</a>, with <span class='code'>Tag</span> as the hash key and <span class='code'>ImageId</span> as the range key. This serves as a one-to-many relationship between a Tag as an Image. Later in this tutorial, we'll show how to use the Query API to retrieve all images for a given tag.<br><br>The table also has two <a href='http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/SecondaryIndexes.html'>secondary indexes</a> to support other query patterns efficiently. The first is a <a href='http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.html'>global secondary index</a> called <span class='code'>ImageId-index</span> for querying to see what tags are attached to a particular image. The second is a <a href='http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LSI.html'>local secondary index</a> called <span class='code'>VoteCount-index</span> for querying for all images with a particular tag, but sorted by popularity.</p></br><p>Run the command in the code editor now (<i class='icon-play' aria-label='play' role='img'></i>) to create the <span class='code'>ImageTag</span> table and its secondary indexes.</p>",
      editor: "// This CreateTable request will create the ImageTag table.\nvar params = {\n    TableName: 'ImageTag',\n    KeySchema: [\n        {\n            AttributeName: 'Tag',\n            KeyType: 'HASH'\n        },\n        {\n            AttributeName: 'ImageId',\n            KeyType: 'RANGE'\n        }\n    ],\n    GlobalSecondaryIndexes: [{\n            IndexName: 'ImageId-index',\n            KeySchema: [\n                {\n                    AttributeName: 'ImageId',\n                    KeyType: 'HASH'\n                },\n                {\n                    AttributeName: 'Tag',\n                    KeyType: 'RANGE'\n                }\n            ],\n            Projection: {\n                ProjectionType: 'KEYS_ONLY'\n            },\n            ProvisionedThroughput: {\n                ReadCapacityUnits: 1,\n                WriteCapacityUnits: 1\n            }\n        }\n    ],\n    LocalSecondaryIndexes: [{\n            IndexName: 'VoteCount-index',\n            KeySchema: [\n                {\n                    AttributeName: 'Tag',\n                    KeyType: 'HASH'\n                },\n                {\n                    AttributeName: 'VoteCount',\n                    KeyType: 'RANGE'\n                }\n            ],\n            Projection: {\n                ProjectionType: 'ALL'\n            }\n        }\n    ],\n    AttributeDefinitions: [\n        {\n            AttributeName: 'Tag',\n            AttributeType: 'S'\n        },\n        {\n            AttributeName: 'ImageId',\n            AttributeType: 'S'\n        },\n        {\n            AttributeName: 'VoteCount',\n            AttributeType: 'N'\n        }\n    ],\n    ProvisionedThroughput:  {\n        ReadCapacityUnits: 1,\n        WriteCapacityUnits: 1\n    }\n};\nconsole.log(\"Creating the ImageTag table\");\ndynamodb.createTable(params, function(err, data) {\n        if (err) print(err); // an error occurred\n        else print(data); // successful response\n        console.log(\"CreateTable returned\");\n    });"
    }, {
      title: "Loading Demo Data (Tagging Images)",
      console: "<p>Now let's put some data into the <span class='code'>ImageTag</span> table.</p></br><p>You may notice that this code uses a slightly different callback API in the AWS SDK so that the request object is accessible in the callback for printing out debugging info. More information on the differences in callback APIs in the SDK is available in the <a href='http://docs.aws.amazon.com/AWSJavaScriptSDK/guide/browser-making-requests.html#The_Response_Object__AWS_Response_'>AWS SDK for JavaScript Developer Guide</a>.</p></br><p>Run this example program (<i class='icon-play' aria-label='play' role='img'></i>) to tag a bunch of images.</p>",
      editor: "// This short program will load in a bunch of example data into the ImageTag table.\n\n// A map of image id to the tags to attach to the image.\nvar images = {\n    'android.png': ['SDKs & Tools', 'Android'],\n    'appstream.png': ['Application Services', 'Amazon AppStream'],\n    'cli.png': ['SDKs & Tools', 'AWS CLI'],\n    'cloudformation.png': ['Deployment & Management', 'AWS CloudFormation'],\n    'cloudfront.png': ['Storage & CDN', 'Amazon CloudFront'],\n    'cloudsearch.png': ['Application Services', 'Amazon CloudSearch'],\n    'cloudtrail.png': ['Deployment & Management', 'AWS CloudTrail'],\n    'cloudwatch.png': ['Deployment & Management', 'Amazon CloudWatch'],\n    'data-pipeline.png': ['Analytics', 'AWS Data Pipeline'],\n    'direct-connect.png': ['Compute & Networking', 'AWS Direct Connect'],\n    'dotnet.png': ['SDKs & Tools', '.NET'],\n    'dynamodb.png': ['Database', 'Amazon DynamoDB'],\n    'ec2.png': ['Compute & Networking', 'Amazon EC2'],\n    'eclipse.png': ['SDKs & Tools', 'Eclipse'],\n    'elasticache.png': ['Database', 'Amazon ElastiCache'],\n    'elastic-beanstalk.png': ['Deployment & Management', 'AWS Elastic Beanstalk'],\n    'elb.png': ['Compute & Networking', 'Elastic Load Balancing'],\n    'emr.png': ['Analytics', 'Amazon EMR'],\n    'glacier.png': ['Storage & CDN', 'Amazon Glacier'],\n    'iam.png': ['Deployment & Management', 'AWS IAM'],\n    'ios.png': ['SDKs & Tools', 'iOS'],\n    'java.png': ['SDKs & Tools', 'Java'],\n    'kinesis.png': ['Analytics', 'Amazon Kinesis'],\n    'nodejs.png': ['SDKs & Tools', 'Node.js'],\n    'opsworks.png': ['Deployment & Management', 'AWS OpsWorks'],\n    'php.png': ['SDKs & Tools', 'PHP'],\n    'powershell.png': ['SDKs & Tools', 'PowerShell'],\n    'python.png': ['SDKs & Tools', 'Python'],\n    'rds.png': ['Database', 'Amazon RDS'],\n    'redshift.png': ['Database', 'Amazon Redshift'],\n    'route53.png': ['Compute & Networking', 'Amazon Route 53'],\n    'ruby.png': ['SDKs & Tools', 'Ruby'],\n    's3.png': ['Storage & CDN', 'Amazon S3'],\n    'ses.png': ['Application Services', 'Amazon SES'],\n    'sns.png': ['Application Services', 'Amazon SNS'],\n    'sqs.png': ['Application Services', 'Amazon SQS'],\n    'storage-gateway.png': ['Storage & CDN', 'Amazon Storage Gateway'],\n    'swf.png': ['Application Services', 'Amazon SWF'],\n    'transcoding.png': ['Application Services', 'Amazon Elastic Transcoder'],\n    'visual-studio.png': ['SDKs & Tools', 'Visual Studio'],\n    'vpc.png': ['Compute & Networking', 'Amazon VPC']\n};\n\n// Pulls off the next image to tag mapping in the above map, and\n// processes all of the tags for that image.\nfunction processImage() {\n\n    // If there aren't any images left, we're done (pending any in-flight requests)\n    if (Object.keys(images).length === 0) {\n        console.log(\"*** Finished tagging all images ***\");\n        return;\n    }\n\n    // Get the first image and its tags\n    var image = Object.keys(images)[0];\n    var tags = images[image];\n    delete images[image];\n\n    // Random vote count for each image...kind of.\n    voteCount = (\"dynamodb.png\" == image) ? 1000 : Math.floor((Math.random() * 20) + 80);\n\n    // Always tag images with 'Amazon Web Services'\n    tags.push('Amazon Web Services');\n\n    // Submit the requests in parallel and wait for them to complete\n    inFlightRequests = tags.length + 1;\n\n    // Update the Image item to include a vote count\n    dynamodb.updateItem({\n        TableName: 'Image',\n        Key: {\n            Id: image,\n        },\n        AttributeUpdates: {\n            VoteCount: {\n                Action: 'PUT',\n                Value: voteCount\n            }\n        }\n    }, function (err, data) {\n        if (err) {\n            console.log(\"ERROR with updating vote count for image \" + image + \":\");\n            console.log(err);\n        } else {\n            console.log(\"Updated VoteCount for \" + image);\n        }\n        inFlightRequests--;\n        if(inFlightRequests === 0) {\n            console.log(\"Done with writes for image \" + image);\n            processImage();\n        }\n    });\n\n    // Now insert a new tag item for each ImageTag relationship\n    for (i = 0; i < tags.length; i++) {\n        var tag = tags[i];\n        var imageId = image;\n\n        // Write the ImageTag item for this image+tag combination\n        dynamodb.putItem({\n            TableName: 'ImageTag',\n            Item: {\n                Tag: tag,\n                ImageId: imageId,\n                VoteCount: voteCount,\n            }\n        }, tagImageCallback(imageId, tag));\n    }\n}\n\nfunction tagImageCallback(imageId, tag) {\n    return function(err, data) {\n        if (err) {\n            console.log(\"ERROR with tagging \" + imageId + \" with \" + tag + \": \" + err);\n        } else {\n            console.log(\"Tagged \" + imageId + \" with \" + tag);\n        }\n        inFlightRequests--;\n        if(inFlightRequests === 0) {\n            console.log(\"Done with writes for image \" + imageId);\n            processImage();\n        }\n    }\n}\n\n// Kick off the process\nprocessImage();"
    }, {
      title: "Query: Querying Hash-Range Tables",
      console: "<p>Now you can try some <a href='http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html'>queries</a>. First, use the <a href='http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_Query.html'>Query API</a> to retrieve all images for the tag <span class='code'>Database</span>. The results will be sorted by range key (in this case image id). Notice that this code uses the <span class='code'>eachPage()</span> method to call the Query API repeatedly if there are more than one page of results.</p></br><p>Run the code (<i class='icon-play' aria-label='play' role='img'></i>) to see the Query API in action.</p>",
      editor: "// Queries for all items in the ImageTag table for images with the tag 'Database'\nvar params = {\n    TableName: 'ImageTag',\n    KeyConditions: dynamodb.Condition(\"Tag\", \"EQ\", \"Database\"),\n};\nconsole.log(\"Querying the ImageTag table for all images with the tag 'Database'\");\ndynamodb.query(params).eachPage(function(err, data) {\n    if (err) print(err); // an error occurred\n    else if (data) print(data); // successful response\n});"
    }, {
      title: "Query: Using a Local Secondary Index to Get the Popular Images",
      console: "<p>The sort order in the previous example wasn't very useful, so next let's query the <span class='code'>VoteCount-index</span> to retrieve the top 5 most popular items for the tag <span class='code'>Database</span>. We’ll use the <a href='http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_Query.html'>Query API</a> again, but add the <span class='code'>IndexName</span> to query against the index, and <span class='code'>ScanIndexForward</span>: <span class='code'>false</span> to get the results descending.</p></br><p>Run the code (<i class='icon-play' aria-label='play' role='img'></i>) to see a query on a local secondary index.</p>",
      editor: "// Queries ImageTag's VoteCount index to get up to 5 images with the 'Database' tag, ordered by popularity\nvar params = {\n    TableName: 'ImageTag',\n    IndexName: 'VoteCount-index',\n    KeyConditions: dynamodb.Condition(\"Tag\", \"EQ\", \"Database\"),\n    Limit: 5,\n    ScanIndexForward: false\n};\nconsole.log(\"Querying the ImageTag table's VoteCount-index \"\n    + \"for up to 5 images with the tag 'Database', ordered by VoteCount (descending)\");\ndynamodb.query(params, function(err, data) {\n    if (err) print(err); // an error occurred\n    else if (data) print(data); // successful response\n});"
    }, {
      title: "Query: Using a Global Secondary Index to get the Tags for an Image",
      console: "<p>The image <span class='code'>dynamodb.png</span> seems to have the largest number of votes. To see what else <span class='code'>dynamodb.png</span> is tagged with, query the index <span class='code'>ImageId-index</span>.</p></br><p>Run the code (<i class='icon-play' aria-label='play' role='img'></i>) to see a query on a global secondary index.</p>",
      editor: "// Queries ImageTag's ImageId index to get all of the tags for the image 'dynamodb.png'\nvar params = {\n    TableName: 'ImageTag',\n    IndexName: 'ImageId-index',\n    KeyConditions: dynamodb.Condition(\"ImageId\", \"EQ\", \"dynamodb.png\"),\n};\nconsole.log(\"Querying the ImageTag table's ImageId-index all tags for the image 'dynamodb.png'\");\ndynamodb.query(params).eachPage(function(err, data) {\n    if (err) print(err); // an error occurred\n    else if (data) print(data); // successful response\n});"
    }, {
      title: "Creating One Last Table for the Demo",
      console: "<p>Before we can run the functioning demo, there is one more table to create and populate with data: the <span class='code'>Tag</span> table. This table stores each tag and the number of images for each tag. First, create the <span class='code'>Tag</span> table. This is a simple hash-only primary key schema table.</p></br><p>Run the code (<i class='icon-play' aria-label='play' role='img'></i>) to create the Tag table.</p>",
      editor: "// This CreateTable request will create the Tag table.\nvar params = {\n    TableName: 'Tag',\n    KeySchema: [\n        {\n            AttributeName: 'Tag',\n            KeyType: 'HASH'\n        }\n    ],\n    AttributeDefinitions: [\n        {\n            AttributeName: 'Tag',\n            AttributeType: 'S'\n        }\n    ],\n    ProvisionedThroughput:  {\n        ReadCapacityUnits: 1,\n        WriteCapacityUnits: 1\n    }\n};\nconsole.log(\"Creating the Tag table\");\ndynamodb.createTable(params, function(err, data) {\n    if (err) print(err); // an error occurred\n    else print(data); // successful response\n    console.log(\"CreateTable returned\");\n});"
    }, {
      title: "Loading the Last Bit of Demo Data",
      console: "<p>Next, run the code (<i class='icon-play' aria-label='play' role='img'></i>) to populate the <span class='code'>Tag</span> table with data.</p>",
      editor: "// Populates the Tag table to list all of the tags and each tag's image count\n\n// A map of tag to number of images with that tag\nvar tags = {\n    'SDKs & Tools': 12,\n    'Application Services': 7,\n    'Deployment & Management': 6,\n    'Storage & CDN': 4,\n    'Analytics': 3,\n    'Compute & Networking': 5,\n    'Database': 4,\n    'Android': 1,\n    'Amazon AppStream': 1,\n    'AWS CLI': 1,\n    'AWS CloudFormation': 1,\n    'Amazon CloudFront': 1,\n    'Amazon CloudSearch': 1,\n    'AWS CloudTrail': 1,\n    'AWS Data Pipeline': 1,\n    'AWS Direct Connect': 1,\n    '.NET': 1,\n    'Amazon DynamoDB': 1,\n    'Amazon EC2': 1,\n    'Eclipse': 1,\n    'Amazon ElastiCache': 1,\n    'AWS Elastic Beanstalk': 1,\n    'Elastic Load Balancing': 1,\n    'Amazon EMR': 1,\n    'Amazon Glacier': 1,\n    'AWS IAM': 1,\n    'iOS': 1,\n    'Java': 1,\n    'Amazon Kinesis': 1,\n    'Node.js': 1,\n    'AWS OpsWorks': 1,\n    'PHP': 1,\n    'PowerShell': 1,\n    'Python': 1,\n    'Amazon RDS': 1,\n    'Amazon Redshift': 1,\n    'Amazon Route 53': 1,\n    'Ruby': 1,\n    'Amazon S3': 1,\n    'Amazon SES': 1,\n    'Amazon SNS': 1,\n    'Amazon SQS': 1,\n    'Amazon Storage Gateway': 1,\n    'Amazon SWF': 1,\n    'Amazon Elastic Transcoder': 1,\n    'Visual Studio': 1,\n    'Amazon VPC': 1\n};\n\n// Kicks off putting the tags into the table\nputTag();\n\n// Puts the tags into the Tag table one by one\nfunction putTag() {\n\n    // If there are no more tags in the map, we're done\n    if (Object.keys(tags).length === 0) {\n        console.log(\"*** Finished adding tags ***\");\n        return;\n    }\n    // Pop off the next tag in the list\n    var tag = Object.keys(tags)[0];\n    var numImages = tags[tag];\n    delete tags[tag];\n\n    // Put the Tag item into the table\n    dynamodb.putItem({\n        TableName: 'Tag',\n        Item: {\n            Tag: tag,\n            ImageCount: numImages\n        }\n    }, function(err, data) {\n        if (err) print(err); // an error occurred\n        else {\n            console.log(\"Added the '\" + tag + \"' tag\");\n            putTag(); // put the next tag once this one completes\n        }\n    });\n}"
    }, {
      title: "Try Out the Demo",
      console: "<p>Now you can launch the <a href=\"image-tag-demo.html\" target=\"_blank\">image tagging demo web app</a> to see the type of application you can build using a simple schema on DynamoDB.</p>",
      editor: " "
    }
  ]
};
