/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.sqlite4java;

import com.almworks.sqlite4java.SQLite;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java._SQLiteManual;
import com.almworks.sqlite4java._SQLiteSwigged;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Internal {
    private static final Logger logger = Logger.getLogger("com.almworks.sqlite4java");
    private static final String LOG_PREFIX = "[sqlite] ";
    private static final String BASE_LIBRARY_NAME = "sqlite4java";
    private static final String[] DEBUG_SUFFIXES = new String[]{"-d", ""};
    private static final String[] RELEASE_SUFFIXES = new String[]{"", "-d"};
    private static final AtomicInteger lastConnectionNumber = new AtomicInteger(0);

    Internal() {
    }

    static int nextConnectionNumber() {
        return lastConnectionNumber.incrementAndGet();
    }

    static void recoverableError(Object source, String message, boolean throwAssertion) {
        Internal.logWarn(source, message);
        assert (!throwAssertion) : source + " " + message;
    }

    static void log(Level level, Object source, Object message, Throwable exception) {
        if (!logger.isLoggable(level)) {
            return;
        }
        StringBuilder builder = new StringBuilder(LOG_PREFIX);
        if (source != null) {
            if (source instanceof Class) {
                String className = ((Class)source).getName();
                builder.append(className.substring(className.lastIndexOf(46) + 1));
            } else {
                builder.append(source);
            }
            builder.append(": ");
        }
        if (message != null) {
            builder.append(message);
        }
        logger.log(level, builder.toString(), exception);
    }

    static void logFine(Object source, Object message) {
        Internal.log(Level.FINE, source, message, null);
    }

    static void logInfo(Object source, Object message) {
        Internal.log(Level.INFO, source, message, null);
    }

    static void logWarn(Object source, Object message) {
        Internal.log(Level.WARNING, source, message, null);
    }

    static boolean isFineLogging() {
        return logger.isLoggable(Level.FINE);
    }

    static Throwable loadLibraryX() {
        Iterator<String> i$;
        if (Internal.checkLoaded() == null) {
            return null;
        }
        if ("true".equalsIgnoreCase(System.getProperty("sqlite4java.debug"))) {
            logger.setLevel(Level.FINE);
        }
        String classUrl = Internal.getClassUrl();
        String defaultPath = Internal.getDefaultLibPath(classUrl);
        String versionSuffix = Internal.getVersionSuffix(classUrl);
        String forcedPath = Internal.getForcedPath();
        if (Internal.isFineLogging()) {
            Internal.logFine(Internal.class, "loading library");
            Internal.logFine(Internal.class, "java.library.path=" + System.getProperty("java.library.path"));
            Internal.logFine(Internal.class, "sqlite4java.library.path=" + System.getProperty("sqlite4java.library.path"));
            Internal.logFine(Internal.class, "cwd=" + new File(".").getAbsolutePath());
            Internal.logFine(Internal.class, "default path=" + (defaultPath == null ? "null " : new File(defaultPath).getAbsolutePath()));
            Internal.logFine(Internal.class, "forced path=" + (forcedPath == null ? "null " : new File(forcedPath).getAbsolutePath()));
        }
        String os = Internal.getOs();
        String arch = Internal.getArch(os);
        List<String> names = Internal.collectLibraryNames(versionSuffix, os, arch);
        Throwable[] failureReason = new Throwable[]{null};
        boolean loaded = false;
        if (forcedPath != null) {
            String name;
            i$ = names.iterator();
            while (i$.hasNext() && !(loaded = Internal.tryLoadFromPath(name = i$.next(), os, forcedPath, failureReason))) {
            }
        } else {
            String name;
            if (defaultPath != null) {
                i$ = names.iterator();
                while (i$.hasNext() && !(loaded = Internal.tryLoadFromPath(name = i$.next(), os, defaultPath, failureReason))) {
                }
            }
            if (!loaded) {
                i$ = names.iterator();
                while (i$.hasNext() && !(loaded = Internal.tryLoadFromSystemPath(name = i$.next(), failureReason))) {
                }
            }
        }
        if (loaded) {
            String msg = Internal.getLibraryVersionMessage();
            Internal.logInfo(Internal.class, msg);
            return null;
        }
        Throwable t = failureReason[0];
        if (t == null) {
            t = new SQLiteException(-91, "sqlite4java cannot find native library");
        }
        return t;
    }

    private static List<String> collectLibraryNames(String versionSuffix, String os, String arch) {
        String[] configurationSuffixes;
        List<String> baseSuffixes = Internal.collectBaseLibraryNames(os, arch);
        ArrayList<String> r = new ArrayList<String>(24);
        String[] stringArray = configurationSuffixes = SQLite.isDebugBinaryPreferred() ? DEBUG_SUFFIXES : RELEASE_SUFFIXES;
        if (versionSuffix != null) {
            for (String configurationSuffix : configurationSuffixes) {
                for (String baseSuffix : baseSuffixes) {
                    r.add(baseSuffix + configurationSuffix + versionSuffix);
                }
            }
        }
        for (String configurationSuffix : configurationSuffixes) {
            for (String baseSuffix : baseSuffixes) {
                r.add(baseSuffix + configurationSuffix);
            }
        }
        return r;
    }

    private static List<String> collectBaseLibraryNames(String os, String arch) {
        ArrayList<String> r = new ArrayList<String>(6);
        String base = "sqlite4java-" + os;
        r.add(base + "-" + arch);
        if (arch.equals("x86_64") || arch.equals("x64")) {
            r.add(base + "-amd64");
        } else if (arch.equals("x86")) {
            r.add(base + "-i386");
        } else if (arch.equals("i386")) {
            r.add(base + "-x86");
        } else if (arch.startsWith("arm") && arch.length() > 3) {
            if (arch.length() > 5 && arch.startsWith("armv") && Character.isDigit(arch.charAt(4))) {
                r.add(base + "-" + arch.substring(0, 5));
            }
            r.add(base + "-arm");
        }
        r.add(base);
        r.add(BASE_LIBRARY_NAME);
        return r;
    }

    private static String getForcedPath() {
        String r = System.getProperty("sqlite4java.library.path");
        if (r == null || r.length() == 0) {
            return null;
        }
        r = r.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        return r;
    }

    private static String getClassUrl() {
        Class<Internal> c = Internal.class;
        String name = c.getName().replace('.', '/') + ".class";
        URL url = c.getClassLoader().getResource(name);
        if (url == null) {
            return null;
        }
        String classUrl = url.toString();
        try {
            return URLDecoder.decode(classUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Internal.recoverableError(Internal.class, e.getMessage(), true);
            return classUrl;
        }
    }

    private static String getArch(String os) {
        String arch = System.getProperty("os.arch");
        if (arch == null) {
            Internal.logWarn(Internal.class, "os.arch is null");
            arch = "x86";
        } else {
            arch = arch.toLowerCase(Locale.US);
            if ("win32".equals(os) && "amd64".equals(arch)) {
                arch = "x64";
            }
        }
        Internal.logFine(Internal.class, "os.arch=" + arch);
        return arch;
    }

    private static String getOs() {
        String os;
        String osname = System.getProperty("os.name");
        if (osname == null) {
            Internal.logWarn(Internal.class, "os.name is null");
            os = "linux";
        } else {
            String runtimeName;
            os = (osname = osname.toLowerCase(Locale.US)).startsWith("mac") || osname.startsWith("darwin") || osname.startsWith("os x") ? "osx" : (osname.startsWith("windows") ? "win32" : ((runtimeName = System.getProperty("java.runtime.name")) != null && runtimeName.toLowerCase(Locale.US).contains("android") ? "android" : "linux"));
        }
        Internal.logFine(Internal.class, "os.name=" + osname + "; os=" + os);
        return os;
    }

    private static String getDefaultLibPath(String classUrl) {
        return Internal.getDefaultLibPath(System.getProperty("java.library.path"), classUrl);
    }

    static String getDefaultLibPath(String libraryPath, String classUrl) {
        File jar = Internal.getJarFileFromClassUrl(classUrl);
        if (jar == null) {
            return null;
        }
        File loadDir = jar.getParentFile();
        if (loadDir.getPath().length() == 0 || !loadDir.isDirectory()) {
            return null;
        }
        if (libraryPath == null) {
            libraryPath = "";
        }
        boolean contains = false;
        char sep = File.pathSeparatorChar;
        if (libraryPath.length() > 0) {
            int k = 0;
            while (k < libraryPath.length()) {
                int p = libraryPath.indexOf(sep, k);
                if (p < 0) {
                    p = libraryPath.length();
                }
                if (loadDir.equals(new File(libraryPath.substring(k, p)))) {
                    contains = true;
                    break;
                }
                k = p + 1;
            }
        }
        String loadPath = loadDir.getPath();
        if (contains) {
            return null;
        }
        return loadPath;
    }

    private static File getJarFileFromClassUrl(String classUrl) {
        if (classUrl == null) {
            return null;
        }
        String s = classUrl;
        String prefix = "jar:file:";
        if (!s.startsWith(prefix)) {
            return null;
        }
        int k = (s = s.substring(prefix.length())).lastIndexOf(33);
        if (k < 0) {
            return null;
        }
        File jar = new File(s.substring(0, k));
        if (!jar.isFile()) {
            return null;
        }
        return jar;
    }

    static String getVersionSuffix(String classUrl) {
        int t;
        File jar = Internal.getJarFileFromClassUrl(classUrl);
        if (jar == null) {
            return null;
        }
        String name = jar.getName();
        String lower = name.toLowerCase(Locale.US);
        if (!lower.startsWith(BASE_LIBRARY_NAME)) {
            return null;
        }
        if (!lower.endsWith(".jar")) {
            return null;
        }
        int f = BASE_LIBRARY_NAME.length();
        return f + 1 < (t = name.length() - 4) && name.charAt(f) == '-' ? name.substring(f, t) : null;
    }

    private static boolean tryLoadFromPath(String libname, String os, String path, Throwable[] failureReason) {
        String oldSuffix;
        String libFile = System.mapLibraryName(libname);
        if (os.equals("osx") && libFile.endsWith(oldSuffix = ".jnilib")) {
            String newSuffix = ".dylib";
            libFile = libFile.substring(0, libFile.length() - oldSuffix.length()) + newSuffix;
        }
        File lib = new File(new File(path), libFile);
        Internal.logFine(Internal.class, "checking " + lib);
        if (!lib.isFile() || !lib.canRead()) {
            return false;
        }
        String logname = libname + " from " + lib;
        Internal.logFine(Internal.class, "trying to load " + logname);
        try {
            System.load(lib.getAbsolutePath());
            return Internal.verifyLoading(failureReason, logname);
        }
        catch (Throwable t) {
            Internal.logFine(Internal.class, "cannot load " + logname + ": " + t);
            Internal.updateLoadFailureReason(failureReason, t);
            return false;
        }
    }

    private static boolean tryLoadFromSystemPath(String libname, Throwable[] failureReason) {
        Internal.logFine(Internal.class, "trying to load " + libname);
        try {
            System.loadLibrary(libname);
            return Internal.verifyLoading(failureReason, libname + " from system path");
        }
        catch (Throwable t) {
            Internal.logFine(Internal.class, "cannot load " + libname + ": " + t);
            Internal.updateLoadFailureReason(failureReason, t);
            return false;
        }
    }

    private static boolean verifyLoading(Throwable[] failureReason, String logname) {
        Internal.logInfo(Internal.class, "loaded " + logname);
        LinkageError linkError = Internal.checkLoaded();
        if (linkError == null) {
            return true;
        }
        Internal.logFine(Internal.class, "cannot use " + logname + ": " + linkError);
        Internal.updateLoadFailureReason(failureReason, linkError);
        return false;
    }

    private static void updateLoadFailureReason(Throwable[] bestReason, Throwable currentReason) {
        String m2;
        String m1;
        if (bestReason[0] == null) {
            bestReason[0] = currentReason;
        } else if (currentReason != null && (m1 = bestReason[0].getMessage()) != null && m1.contains("java.library.path") && (m2 = currentReason.getMessage()) != null && !m2.contains("java.library.path")) {
            bestReason[0] = currentReason;
        }
    }

    private static LinkageError checkLoaded() {
        try {
            Internal.getLibraryVersionMessage();
            return null;
        }
        catch (LinkageError e) {
            return e;
        }
    }

    private static String getLibraryVersionMessage() {
        String version = _SQLiteSwigged.sqlite3_libversion();
        String wrapper = _SQLiteManual.wrapper_version();
        return "loaded sqlite " + version + ", wrapper " + wrapper;
    }
}

