/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.embedded;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.dynamodbv2.exceptions.AmazonServiceExceptionType;
import com.amazonaws.services.dynamodbv2.exceptions.DynamoDBLocalServiceException;
import com.amazonaws.services.dynamodbv2.local.shared.access.LocalDBClient;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class DDBExceptionMappingInvocationHandler
implements InvocationHandler {
    private final LocalDBClient impl;
    private final ReentrantReadWriteLock shutdownLock = new ReentrantReadWriteLock();
    private boolean isShutdown = false;

    DDBExceptionMappingInvocationHandler(LocalDBClient impl) {
        this.impl = impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("shutdown")) {
            this.shutdownLock.writeLock().lock();
            try {
                if (!this.isShutdown) {
                    this.impl.shutdown();
                    this.isShutdown = true;
                }
                Object var4_4 = null;
                return var4_4;
            }
            finally {
                this.shutdownLock.writeLock().unlock();
            }
        }
        this.shutdownLock.readLock().lock();
        try {
            if (!this.isShutdown) {
                Object result = null;
                try {
                    Object object = result = method.invoke((Object)this.impl, args);
                    return object;
                }
                catch (InvocationTargetException ie) {
                    Throwable e = ie.getTargetException();
                    if (e.getClass().isAssignableFrom(DynamoDBLocalServiceException.class)) {
                        DDBExceptionMappingInvocationHandler.handleDynamoDBLocalServiceException((DynamoDBLocalServiceException)((Object)e));
                    }
                    throw e;
                }
            }
            throw new AmazonServiceException("Embedded server is shut down");
        }
        finally {
            this.shutdownLock.readLock().unlock();
        }
    }

    public static void handleDynamoDBLocalServiceException(DynamoDBLocalServiceException le) throws Throwable {
        AmazonServiceExceptionType exceptionType = AmazonServiceExceptionType.valueOfErrorCode(le.getErrorCode());
        Class<? extends AmazonServiceException> clientException = exceptionType.getClientClass();
        if (AmazonServiceException.class.equals(clientException)) {
            AmazonServiceException ase = new AmazonServiceException(le.getMessage());
            ase.setErrorCode(le.getErrorCode());
            ase.setStatusCode(le.getStatusCode());
            throw ase;
        }
        Constructor<? extends AmazonServiceException> constructor = clientException.getConstructor(String.class);
        AmazonServiceException wrappedException = constructor.newInstance(le.getMessage());
        throw wrappedException;
    }
}

