/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentity.model.DeleteIdentityPoolRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class DeleteIdentityPoolRequestMarshaller
implements Marshaller<Request<DeleteIdentityPoolRequest>, DeleteIdentityPoolRequest> {
    @Override
    public Request<DeleteIdentityPoolRequest> marshall(DeleteIdentityPoolRequest deleteIdentityPoolRequest) {
        if (deleteIdentityPoolRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteIdentityPoolRequest> request = new DefaultRequest<DeleteIdentityPoolRequest>(deleteIdentityPoolRequest, "AmazonCognitoIdentity");
        String target = "AWSCognitoIdentityService.DeleteIdentityPool";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (deleteIdentityPoolRequest.getIdentityPoolId() != null) {
                jsonWriter.key("IdentityPoolId").value(deleteIdentityPoolRequest.getIdentityPoolId());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

