/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.directory.AWSDirectoryServiceAsync;
import com.amazonaws.services.directory.AWSDirectoryServiceClient;
import com.amazonaws.services.directory.model.ConnectDirectoryRequest;
import com.amazonaws.services.directory.model.ConnectDirectoryResult;
import com.amazonaws.services.directory.model.CreateAliasRequest;
import com.amazonaws.services.directory.model.CreateAliasResult;
import com.amazonaws.services.directory.model.CreateComputerRequest;
import com.amazonaws.services.directory.model.CreateComputerResult;
import com.amazonaws.services.directory.model.CreateDirectoryRequest;
import com.amazonaws.services.directory.model.CreateDirectoryResult;
import com.amazonaws.services.directory.model.CreateSnapshotRequest;
import com.amazonaws.services.directory.model.CreateSnapshotResult;
import com.amazonaws.services.directory.model.DeleteDirectoryRequest;
import com.amazonaws.services.directory.model.DeleteDirectoryResult;
import com.amazonaws.services.directory.model.DeleteSnapshotRequest;
import com.amazonaws.services.directory.model.DeleteSnapshotResult;
import com.amazonaws.services.directory.model.DescribeDirectoriesRequest;
import com.amazonaws.services.directory.model.DescribeDirectoriesResult;
import com.amazonaws.services.directory.model.DescribeSnapshotsRequest;
import com.amazonaws.services.directory.model.DescribeSnapshotsResult;
import com.amazonaws.services.directory.model.DisableRadiusRequest;
import com.amazonaws.services.directory.model.DisableRadiusResult;
import com.amazonaws.services.directory.model.DisableSsoRequest;
import com.amazonaws.services.directory.model.DisableSsoResult;
import com.amazonaws.services.directory.model.EnableRadiusRequest;
import com.amazonaws.services.directory.model.EnableRadiusResult;
import com.amazonaws.services.directory.model.EnableSsoRequest;
import com.amazonaws.services.directory.model.EnableSsoResult;
import com.amazonaws.services.directory.model.GetDirectoryLimitsRequest;
import com.amazonaws.services.directory.model.GetDirectoryLimitsResult;
import com.amazonaws.services.directory.model.GetSnapshotLimitsRequest;
import com.amazonaws.services.directory.model.GetSnapshotLimitsResult;
import com.amazonaws.services.directory.model.RestoreFromSnapshotRequest;
import com.amazonaws.services.directory.model.RestoreFromSnapshotResult;
import com.amazonaws.services.directory.model.UpdateRadiusRequest;
import com.amazonaws.services.directory.model.UpdateRadiusResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AWSDirectoryServiceAsyncClient
extends AWSDirectoryServiceClient
implements AWSDirectoryServiceAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AWSDirectoryServiceAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AWSDirectoryServiceAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSDirectoryServiceAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSDirectoryServiceAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AWSDirectoryServiceAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSDirectoryServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSDirectoryServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AWSDirectoryServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSDirectoryServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<DescribeSnapshotsResult> describeSnapshotsAsync(final DescribeSnapshotsRequest describeSnapshotsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSnapshotsResult>(){

            @Override
            public DescribeSnapshotsResult call() throws Exception {
                return AWSDirectoryServiceAsyncClient.this.describeSnapshots(describeSnapshotsRequest);
            }
        });
    }

    @Override
    public Future<DescribeSnapshotsResult> describeSnapshotsAsync(final DescribeSnapshotsRequest describeSnapshotsRequest, final AsyncHandler<DescribeSnapshotsRequest, DescribeSnapshotsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSnapshotsResult>(){

            @Override
            public DescribeSnapshotsResult call() throws Exception {
                DescribeSnapshotsResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.describeSnapshots(describeSnapshotsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeSnapshotsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateAliasResult> createAliasAsync(final CreateAliasRequest createAliasRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateAliasResult>(){

            @Override
            public CreateAliasResult call() throws Exception {
                return AWSDirectoryServiceAsyncClient.this.createAlias(createAliasRequest);
            }
        });
    }

    @Override
    public Future<CreateAliasResult> createAliasAsync(final CreateAliasRequest createAliasRequest, final AsyncHandler<CreateAliasRequest, CreateAliasResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateAliasResult>(){

            @Override
            public CreateAliasResult call() throws Exception {
                CreateAliasResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.createAlias(createAliasRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createAliasRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSnapshotResult> deleteSnapshotAsync(final DeleteSnapshotRequest deleteSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteSnapshotResult>(){

            @Override
            public DeleteSnapshotResult call() throws Exception {
                return AWSDirectoryServiceAsyncClient.this.deleteSnapshot(deleteSnapshotRequest);
            }
        });
    }

    @Override
    public Future<DeleteSnapshotResult> deleteSnapshotAsync(final DeleteSnapshotRequest deleteSnapshotRequest, final AsyncHandler<DeleteSnapshotRequest, DeleteSnapshotResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteSnapshotResult>(){

            @Override
            public DeleteSnapshotResult call() throws Exception {
                DeleteSnapshotResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.deleteSnapshot(deleteSnapshotRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteSnapshotRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateRadiusResult> updateRadiusAsync(final UpdateRadiusRequest updateRadiusRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateRadiusResult>(){

            @Override
            public UpdateRadiusResult call() throws Exception {
                return AWSDirectoryServiceAsyncClient.this.updateRadius(updateRadiusRequest);
            }
        });
    }

    @Override
    public Future<UpdateRadiusResult> updateRadiusAsync(final UpdateRadiusRequest updateRadiusRequest, final AsyncHandler<UpdateRadiusRequest, UpdateRadiusResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateRadiusResult>(){

            @Override
            public UpdateRadiusResult call() throws Exception {
                UpdateRadiusResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.updateRadius(updateRadiusRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateRadiusRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDirectoriesResult> describeDirectoriesAsync(final DescribeDirectoriesRequest describeDirectoriesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDirectoriesResult>(){

            @Override
            public DescribeDirectoriesResult call() throws Exception {
                return AWSDirectoryServiceAsyncClient.this.describeDirectories(describeDirectoriesRequest);
            }
        });
    }

    @Override
    public Future<DescribeDirectoriesResult> describeDirectoriesAsync(final DescribeDirectoriesRequest describeDirectoriesRequest, final AsyncHandler<DescribeDirectoriesRequest, DescribeDirectoriesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDirectoriesResult>(){

            @Override
            public DescribeDirectoriesResult call() throws Exception {
                DescribeDirectoriesResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.describeDirectories(describeDirectoriesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeDirectoriesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ConnectDirectoryResult> connectDirectoryAsync(final ConnectDirectoryRequest connectDirectoryRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ConnectDirectoryResult>(){

            @Override
            public ConnectDirectoryResult call() throws Exception {
                return AWSDirectoryServiceAsyncClient.this.connectDirectory(connectDirectoryRequest);
            }
        });
    }

    @Override
    public Future<ConnectDirectoryResult> connectDirectoryAsync(final ConnectDirectoryRequest connectDirectoryRequest, final AsyncHandler<ConnectDirectoryRequest, ConnectDirectoryResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ConnectDirectoryResult>(){

            @Override
            public ConnectDirectoryResult call() throws Exception {
                ConnectDirectoryResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.connectDirectory(connectDirectoryRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(connectDirectoryRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateSnapshotResult> createSnapshotAsync(final CreateSnapshotRequest createSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateSnapshotResult>(){

            @Override
            public CreateSnapshotResult call() throws Exception {
                return AWSDirectoryServiceAsyncClient.this.createSnapshot(createSnapshotRequest);
            }
        });
    }

    @Override
    public Future<CreateSnapshotResult> createSnapshotAsync(final CreateSnapshotRequest createSnapshotRequest, final AsyncHandler<CreateSnapshotRequest, CreateSnapshotResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateSnapshotResult>(){

            @Override
            public CreateSnapshotResult call() throws Exception {
                CreateSnapshotResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.createSnapshot(createSnapshotRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createSnapshotRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDirectoryResult> deleteDirectoryAsync(final DeleteDirectoryRequest deleteDirectoryRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteDirectoryResult>(){

            @Override
            public DeleteDirectoryResult call() throws Exception {
                return AWSDirectoryServiceAsyncClient.this.deleteDirectory(deleteDirectoryRequest);
            }
        });
    }

    @Override
    public Future<DeleteDirectoryResult> deleteDirectoryAsync(final DeleteDirectoryRequest deleteDirectoryRequest, final AsyncHandler<DeleteDirectoryRequest, DeleteDirectoryResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteDirectoryResult>(){

            @Override
            public DeleteDirectoryResult call() throws Exception {
                DeleteDirectoryResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.deleteDirectory(deleteDirectoryRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteDirectoryRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetDirectoryLimitsResult> getDirectoryLimitsAsync(final GetDirectoryLimitsRequest getDirectoryLimitsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetDirectoryLimitsResult>(){

            @Override
            public GetDirectoryLimitsResult call() throws Exception {
                return AWSDirectoryServiceAsyncClient.this.getDirectoryLimits(getDirectoryLimitsRequest);
            }
        });
    }

    @Override
    public Future<GetDirectoryLimitsResult> getDirectoryLimitsAsync(final GetDirectoryLimitsRequest getDirectoryLimitsRequest, final AsyncHandler<GetDirectoryLimitsRequest, GetDirectoryLimitsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetDirectoryLimitsResult>(){

            @Override
            public GetDirectoryLimitsResult call() throws Exception {
                GetDirectoryLimitsResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.getDirectoryLimits(getDirectoryLimitsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getDirectoryLimitsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DisableSsoResult> disableSsoAsync(final DisableSsoRequest disableSsoRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DisableSsoResult>(){

            @Override
            public DisableSsoResult call() throws Exception {
                return AWSDirectoryServiceAsyncClient.this.disableSso(disableSsoRequest);
            }
        });
    }

    @Override
    public Future<DisableSsoResult> disableSsoAsync(final DisableSsoRequest disableSsoRequest, final AsyncHandler<DisableSsoRequest, DisableSsoResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DisableSsoResult>(){

            @Override
            public DisableSsoResult call() throws Exception {
                DisableSsoResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.disableSso(disableSsoRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(disableSsoRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<EnableRadiusResult> enableRadiusAsync(final EnableRadiusRequest enableRadiusRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EnableRadiusResult>(){

            @Override
            public EnableRadiusResult call() throws Exception {
                return AWSDirectoryServiceAsyncClient.this.enableRadius(enableRadiusRequest);
            }
        });
    }

    @Override
    public Future<EnableRadiusResult> enableRadiusAsync(final EnableRadiusRequest enableRadiusRequest, final AsyncHandler<EnableRadiusRequest, EnableRadiusResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EnableRadiusResult>(){

            @Override
            public EnableRadiusResult call() throws Exception {
                EnableRadiusResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.enableRadius(enableRadiusRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(enableRadiusRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateComputerResult> createComputerAsync(final CreateComputerRequest createComputerRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateComputerResult>(){

            @Override
            public CreateComputerResult call() throws Exception {
                return AWSDirectoryServiceAsyncClient.this.createComputer(createComputerRequest);
            }
        });
    }

    @Override
    public Future<CreateComputerResult> createComputerAsync(final CreateComputerRequest createComputerRequest, final AsyncHandler<CreateComputerRequest, CreateComputerResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateComputerResult>(){

            @Override
            public CreateComputerResult call() throws Exception {
                CreateComputerResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.createComputer(createComputerRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createComputerRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<EnableSsoResult> enableSsoAsync(final EnableSsoRequest enableSsoRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EnableSsoResult>(){

            @Override
            public EnableSsoResult call() throws Exception {
                return AWSDirectoryServiceAsyncClient.this.enableSso(enableSsoRequest);
            }
        });
    }

    @Override
    public Future<EnableSsoResult> enableSsoAsync(final EnableSsoRequest enableSsoRequest, final AsyncHandler<EnableSsoRequest, EnableSsoResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EnableSsoResult>(){

            @Override
            public EnableSsoResult call() throws Exception {
                EnableSsoResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.enableSso(enableSsoRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(enableSsoRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateDirectoryResult> createDirectoryAsync(final CreateDirectoryRequest createDirectoryRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateDirectoryResult>(){

            @Override
            public CreateDirectoryResult call() throws Exception {
                return AWSDirectoryServiceAsyncClient.this.createDirectory(createDirectoryRequest);
            }
        });
    }

    @Override
    public Future<CreateDirectoryResult> createDirectoryAsync(final CreateDirectoryRequest createDirectoryRequest, final AsyncHandler<CreateDirectoryRequest, CreateDirectoryResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateDirectoryResult>(){

            @Override
            public CreateDirectoryResult call() throws Exception {
                CreateDirectoryResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.createDirectory(createDirectoryRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createDirectoryRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<RestoreFromSnapshotResult> restoreFromSnapshotAsync(final RestoreFromSnapshotRequest restoreFromSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RestoreFromSnapshotResult>(){

            @Override
            public RestoreFromSnapshotResult call() throws Exception {
                return AWSDirectoryServiceAsyncClient.this.restoreFromSnapshot(restoreFromSnapshotRequest);
            }
        });
    }

    @Override
    public Future<RestoreFromSnapshotResult> restoreFromSnapshotAsync(final RestoreFromSnapshotRequest restoreFromSnapshotRequest, final AsyncHandler<RestoreFromSnapshotRequest, RestoreFromSnapshotResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RestoreFromSnapshotResult>(){

            @Override
            public RestoreFromSnapshotResult call() throws Exception {
                RestoreFromSnapshotResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.restoreFromSnapshot(restoreFromSnapshotRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(restoreFromSnapshotRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DisableRadiusResult> disableRadiusAsync(final DisableRadiusRequest disableRadiusRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DisableRadiusResult>(){

            @Override
            public DisableRadiusResult call() throws Exception {
                return AWSDirectoryServiceAsyncClient.this.disableRadius(disableRadiusRequest);
            }
        });
    }

    @Override
    public Future<DisableRadiusResult> disableRadiusAsync(final DisableRadiusRequest disableRadiusRequest, final AsyncHandler<DisableRadiusRequest, DisableRadiusResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DisableRadiusResult>(){

            @Override
            public DisableRadiusResult call() throws Exception {
                DisableRadiusResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.disableRadius(disableRadiusRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(disableRadiusRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetSnapshotLimitsResult> getSnapshotLimitsAsync(final GetSnapshotLimitsRequest getSnapshotLimitsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetSnapshotLimitsResult>(){

            @Override
            public GetSnapshotLimitsResult call() throws Exception {
                return AWSDirectoryServiceAsyncClient.this.getSnapshotLimits(getSnapshotLimitsRequest);
            }
        });
    }

    @Override
    public Future<GetSnapshotLimitsResult> getSnapshotLimitsAsync(final GetSnapshotLimitsRequest getSnapshotLimitsRequest, final AsyncHandler<GetSnapshotLimitsRequest, GetSnapshotLimitsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetSnapshotLimitsResult>(){

            @Override
            public GetSnapshotLimitsResult call() throws Exception {
                GetSnapshotLimitsResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.getSnapshotLimits(getSnapshotLimitsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getSnapshotLimitsRequest, result);
                return result;
            }
        });
    }
}

