/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.opsworks.model.Architecture;
import com.amazonaws.services.opsworks.model.AutoScalingType;
import com.amazonaws.services.opsworks.model.BlockDeviceMapping;
import com.amazonaws.services.opsworks.model.ReportedOs;
import com.amazonaws.services.opsworks.model.RootDeviceType;
import com.amazonaws.services.opsworks.model.VirtualizationType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Instance
implements Serializable,
Cloneable {
    private String agentVersion;
    private String amiId;
    private String architecture;
    private String autoScalingType;
    private String availabilityZone;
    private ListWithAutoConstructFlag<BlockDeviceMapping> blockDeviceMappings;
    private String createdAt;
    private Boolean ebsOptimized;
    private String ec2InstanceId;
    private String elasticIp;
    private String hostname;
    private String infrastructureClass;
    private Boolean installUpdatesOnBoot;
    private String instanceId;
    private String instanceProfileArn;
    private String instanceType;
    private String lastServiceErrorId;
    private ListWithAutoConstructFlag<String> layerIds;
    private String os;
    private String platform;
    private String privateDns;
    private String privateIp;
    private String publicDns;
    private String publicIp;
    private String registeredBy;
    private String reportedAgentVersion;
    private ReportedOs reportedOs;
    private String rootDeviceType;
    private String rootDeviceVolumeId;
    private ListWithAutoConstructFlag<String> securityGroupIds;
    private String sshHostDsaKeyFingerprint;
    private String sshHostRsaKeyFingerprint;
    private String sshKeyName;
    private String stackId;
    private String status;
    private String subnetId;
    private String virtualizationType;

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public void setAgentVersion(String agentVersion) {
        this.agentVersion = agentVersion;
    }

    public Instance withAgentVersion(String agentVersion) {
        this.agentVersion = agentVersion;
        return this;
    }

    public String getAmiId() {
        return this.amiId;
    }

    public void setAmiId(String amiId) {
        this.amiId = amiId;
    }

    public Instance withAmiId(String amiId) {
        this.amiId = amiId;
        return this;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public Instance withArchitecture(String architecture) {
        this.architecture = architecture;
        return this;
    }

    public void setArchitecture(Architecture architecture) {
        this.architecture = architecture.toString();
    }

    public Instance withArchitecture(Architecture architecture) {
        this.architecture = architecture.toString();
        return this;
    }

    public String getAutoScalingType() {
        return this.autoScalingType;
    }

    public void setAutoScalingType(String autoScalingType) {
        this.autoScalingType = autoScalingType;
    }

    public Instance withAutoScalingType(String autoScalingType) {
        this.autoScalingType = autoScalingType;
        return this;
    }

    public void setAutoScalingType(AutoScalingType autoScalingType) {
        this.autoScalingType = autoScalingType.toString();
    }

    public Instance withAutoScalingType(AutoScalingType autoScalingType) {
        this.autoScalingType = autoScalingType.toString();
        return this;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public Instance withAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public List<BlockDeviceMapping> getBlockDeviceMappings() {
        if (this.blockDeviceMappings == null) {
            this.blockDeviceMappings = new ListWithAutoConstructFlag();
            this.blockDeviceMappings.setAutoConstruct(true);
        }
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
            return;
        }
        ListWithAutoConstructFlag blockDeviceMappingsCopy = new ListWithAutoConstructFlag(blockDeviceMappings.size());
        blockDeviceMappingsCopy.addAll(blockDeviceMappings);
        this.blockDeviceMappings = blockDeviceMappingsCopy;
    }

    public Instance withBlockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
        if (this.getBlockDeviceMappings() == null) {
            this.setBlockDeviceMappings(new ArrayList<BlockDeviceMapping>(blockDeviceMappings.length));
        }
        for (BlockDeviceMapping value : blockDeviceMappings) {
            this.getBlockDeviceMappings().add(value);
        }
        return this;
    }

    public Instance withBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
        } else {
            ListWithAutoConstructFlag blockDeviceMappingsCopy = new ListWithAutoConstructFlag(blockDeviceMappings.size());
            blockDeviceMappingsCopy.addAll(blockDeviceMappings);
            this.blockDeviceMappings = blockDeviceMappingsCopy;
        }
        return this;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public Instance withCreatedAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public Boolean isEbsOptimized() {
        return this.ebsOptimized;
    }

    public void setEbsOptimized(Boolean ebsOptimized) {
        this.ebsOptimized = ebsOptimized;
    }

    public Instance withEbsOptimized(Boolean ebsOptimized) {
        this.ebsOptimized = ebsOptimized;
        return this;
    }

    public Boolean getEbsOptimized() {
        return this.ebsOptimized;
    }

    public String getEc2InstanceId() {
        return this.ec2InstanceId;
    }

    public void setEc2InstanceId(String ec2InstanceId) {
        this.ec2InstanceId = ec2InstanceId;
    }

    public Instance withEc2InstanceId(String ec2InstanceId) {
        this.ec2InstanceId = ec2InstanceId;
        return this;
    }

    public String getElasticIp() {
        return this.elasticIp;
    }

    public void setElasticIp(String elasticIp) {
        this.elasticIp = elasticIp;
    }

    public Instance withElasticIp(String elasticIp) {
        this.elasticIp = elasticIp;
        return this;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public Instance withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public String getInfrastructureClass() {
        return this.infrastructureClass;
    }

    public void setInfrastructureClass(String infrastructureClass) {
        this.infrastructureClass = infrastructureClass;
    }

    public Instance withInfrastructureClass(String infrastructureClass) {
        this.infrastructureClass = infrastructureClass;
        return this;
    }

    public Boolean isInstallUpdatesOnBoot() {
        return this.installUpdatesOnBoot;
    }

    public void setInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
        this.installUpdatesOnBoot = installUpdatesOnBoot;
    }

    public Instance withInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
        this.installUpdatesOnBoot = installUpdatesOnBoot;
        return this;
    }

    public Boolean getInstallUpdatesOnBoot() {
        return this.installUpdatesOnBoot;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public Instance withInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public String getInstanceProfileArn() {
        return this.instanceProfileArn;
    }

    public void setInstanceProfileArn(String instanceProfileArn) {
        this.instanceProfileArn = instanceProfileArn;
    }

    public Instance withInstanceProfileArn(String instanceProfileArn) {
        this.instanceProfileArn = instanceProfileArn;
        return this;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public Instance withInstanceType(String instanceType) {
        this.instanceType = instanceType;
        return this;
    }

    public String getLastServiceErrorId() {
        return this.lastServiceErrorId;
    }

    public void setLastServiceErrorId(String lastServiceErrorId) {
        this.lastServiceErrorId = lastServiceErrorId;
    }

    public Instance withLastServiceErrorId(String lastServiceErrorId) {
        this.lastServiceErrorId = lastServiceErrorId;
        return this;
    }

    public List<String> getLayerIds() {
        if (this.layerIds == null) {
            this.layerIds = new ListWithAutoConstructFlag();
            this.layerIds.setAutoConstruct(true);
        }
        return this.layerIds;
    }

    public void setLayerIds(Collection<String> layerIds) {
        if (layerIds == null) {
            this.layerIds = null;
            return;
        }
        ListWithAutoConstructFlag layerIdsCopy = new ListWithAutoConstructFlag(layerIds.size());
        layerIdsCopy.addAll(layerIds);
        this.layerIds = layerIdsCopy;
    }

    public Instance withLayerIds(String ... layerIds) {
        if (this.getLayerIds() == null) {
            this.setLayerIds(new ArrayList<String>(layerIds.length));
        }
        for (String value : layerIds) {
            this.getLayerIds().add(value);
        }
        return this;
    }

    public Instance withLayerIds(Collection<String> layerIds) {
        if (layerIds == null) {
            this.layerIds = null;
        } else {
            ListWithAutoConstructFlag layerIdsCopy = new ListWithAutoConstructFlag(layerIds.size());
            layerIdsCopy.addAll(layerIds);
            this.layerIds = layerIdsCopy;
        }
        return this;
    }

    public String getOs() {
        return this.os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public Instance withOs(String os) {
        this.os = os;
        return this;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public Instance withPlatform(String platform) {
        this.platform = platform;
        return this;
    }

    public String getPrivateDns() {
        return this.privateDns;
    }

    public void setPrivateDns(String privateDns) {
        this.privateDns = privateDns;
    }

    public Instance withPrivateDns(String privateDns) {
        this.privateDns = privateDns;
        return this;
    }

    public String getPrivateIp() {
        return this.privateIp;
    }

    public void setPrivateIp(String privateIp) {
        this.privateIp = privateIp;
    }

    public Instance withPrivateIp(String privateIp) {
        this.privateIp = privateIp;
        return this;
    }

    public String getPublicDns() {
        return this.publicDns;
    }

    public void setPublicDns(String publicDns) {
        this.publicDns = publicDns;
    }

    public Instance withPublicDns(String publicDns) {
        this.publicDns = publicDns;
        return this;
    }

    public String getPublicIp() {
        return this.publicIp;
    }

    public void setPublicIp(String publicIp) {
        this.publicIp = publicIp;
    }

    public Instance withPublicIp(String publicIp) {
        this.publicIp = publicIp;
        return this;
    }

    public String getRegisteredBy() {
        return this.registeredBy;
    }

    public void setRegisteredBy(String registeredBy) {
        this.registeredBy = registeredBy;
    }

    public Instance withRegisteredBy(String registeredBy) {
        this.registeredBy = registeredBy;
        return this;
    }

    public String getReportedAgentVersion() {
        return this.reportedAgentVersion;
    }

    public void setReportedAgentVersion(String reportedAgentVersion) {
        this.reportedAgentVersion = reportedAgentVersion;
    }

    public Instance withReportedAgentVersion(String reportedAgentVersion) {
        this.reportedAgentVersion = reportedAgentVersion;
        return this;
    }

    public ReportedOs getReportedOs() {
        return this.reportedOs;
    }

    public void setReportedOs(ReportedOs reportedOs) {
        this.reportedOs = reportedOs;
    }

    public Instance withReportedOs(ReportedOs reportedOs) {
        this.reportedOs = reportedOs;
        return this;
    }

    public String getRootDeviceType() {
        return this.rootDeviceType;
    }

    public void setRootDeviceType(String rootDeviceType) {
        this.rootDeviceType = rootDeviceType;
    }

    public Instance withRootDeviceType(String rootDeviceType) {
        this.rootDeviceType = rootDeviceType;
        return this;
    }

    public void setRootDeviceType(RootDeviceType rootDeviceType) {
        this.rootDeviceType = rootDeviceType.toString();
    }

    public Instance withRootDeviceType(RootDeviceType rootDeviceType) {
        this.rootDeviceType = rootDeviceType.toString();
        return this;
    }

    public String getRootDeviceVolumeId() {
        return this.rootDeviceVolumeId;
    }

    public void setRootDeviceVolumeId(String rootDeviceVolumeId) {
        this.rootDeviceVolumeId = rootDeviceVolumeId;
    }

    public Instance withRootDeviceVolumeId(String rootDeviceVolumeId) {
        this.rootDeviceVolumeId = rootDeviceVolumeId;
        return this;
    }

    public List<String> getSecurityGroupIds() {
        if (this.securityGroupIds == null) {
            this.securityGroupIds = new ListWithAutoConstructFlag();
            this.securityGroupIds.setAutoConstruct(true);
        }
        return this.securityGroupIds;
    }

    public void setSecurityGroupIds(Collection<String> securityGroupIds) {
        if (securityGroupIds == null) {
            this.securityGroupIds = null;
            return;
        }
        ListWithAutoConstructFlag securityGroupIdsCopy = new ListWithAutoConstructFlag(securityGroupIds.size());
        securityGroupIdsCopy.addAll(securityGroupIds);
        this.securityGroupIds = securityGroupIdsCopy;
    }

    public Instance withSecurityGroupIds(String ... securityGroupIds) {
        if (this.getSecurityGroupIds() == null) {
            this.setSecurityGroupIds(new ArrayList<String>(securityGroupIds.length));
        }
        for (String value : securityGroupIds) {
            this.getSecurityGroupIds().add(value);
        }
        return this;
    }

    public Instance withSecurityGroupIds(Collection<String> securityGroupIds) {
        if (securityGroupIds == null) {
            this.securityGroupIds = null;
        } else {
            ListWithAutoConstructFlag securityGroupIdsCopy = new ListWithAutoConstructFlag(securityGroupIds.size());
            securityGroupIdsCopy.addAll(securityGroupIds);
            this.securityGroupIds = securityGroupIdsCopy;
        }
        return this;
    }

    public String getSshHostDsaKeyFingerprint() {
        return this.sshHostDsaKeyFingerprint;
    }

    public void setSshHostDsaKeyFingerprint(String sshHostDsaKeyFingerprint) {
        this.sshHostDsaKeyFingerprint = sshHostDsaKeyFingerprint;
    }

    public Instance withSshHostDsaKeyFingerprint(String sshHostDsaKeyFingerprint) {
        this.sshHostDsaKeyFingerprint = sshHostDsaKeyFingerprint;
        return this;
    }

    public String getSshHostRsaKeyFingerprint() {
        return this.sshHostRsaKeyFingerprint;
    }

    public void setSshHostRsaKeyFingerprint(String sshHostRsaKeyFingerprint) {
        this.sshHostRsaKeyFingerprint = sshHostRsaKeyFingerprint;
    }

    public Instance withSshHostRsaKeyFingerprint(String sshHostRsaKeyFingerprint) {
        this.sshHostRsaKeyFingerprint = sshHostRsaKeyFingerprint;
        return this;
    }

    public String getSshKeyName() {
        return this.sshKeyName;
    }

    public void setSshKeyName(String sshKeyName) {
        this.sshKeyName = sshKeyName;
    }

    public Instance withSshKeyName(String sshKeyName) {
        this.sshKeyName = sshKeyName;
        return this;
    }

    public String getStackId() {
        return this.stackId;
    }

    public void setStackId(String stackId) {
        this.stackId = stackId;
    }

    public Instance withStackId(String stackId) {
        this.stackId = stackId;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Instance withStatus(String status) {
        this.status = status;
        return this;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public Instance withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public String getVirtualizationType() {
        return this.virtualizationType;
    }

    public void setVirtualizationType(String virtualizationType) {
        this.virtualizationType = virtualizationType;
    }

    public Instance withVirtualizationType(String virtualizationType) {
        this.virtualizationType = virtualizationType;
        return this;
    }

    public void setVirtualizationType(VirtualizationType virtualizationType) {
        this.virtualizationType = virtualizationType.toString();
    }

    public Instance withVirtualizationType(VirtualizationType virtualizationType) {
        this.virtualizationType = virtualizationType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAgentVersion() != null) {
            sb.append("AgentVersion: " + this.getAgentVersion() + ",");
        }
        if (this.getAmiId() != null) {
            sb.append("AmiId: " + this.getAmiId() + ",");
        }
        if (this.getArchitecture() != null) {
            sb.append("Architecture: " + this.getArchitecture() + ",");
        }
        if (this.getAutoScalingType() != null) {
            sb.append("AutoScalingType: " + this.getAutoScalingType() + ",");
        }
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: " + this.getAvailabilityZone() + ",");
        }
        if (this.getBlockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: " + this.getBlockDeviceMappings() + ",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: " + this.getCreatedAt() + ",");
        }
        if (this.isEbsOptimized() != null) {
            sb.append("EbsOptimized: " + this.isEbsOptimized() + ",");
        }
        if (this.getEc2InstanceId() != null) {
            sb.append("Ec2InstanceId: " + this.getEc2InstanceId() + ",");
        }
        if (this.getElasticIp() != null) {
            sb.append("ElasticIp: " + this.getElasticIp() + ",");
        }
        if (this.getHostname() != null) {
            sb.append("Hostname: " + this.getHostname() + ",");
        }
        if (this.getInfrastructureClass() != null) {
            sb.append("InfrastructureClass: " + this.getInfrastructureClass() + ",");
        }
        if (this.isInstallUpdatesOnBoot() != null) {
            sb.append("InstallUpdatesOnBoot: " + this.isInstallUpdatesOnBoot() + ",");
        }
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: " + this.getInstanceId() + ",");
        }
        if (this.getInstanceProfileArn() != null) {
            sb.append("InstanceProfileArn: " + this.getInstanceProfileArn() + ",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: " + this.getInstanceType() + ",");
        }
        if (this.getLastServiceErrorId() != null) {
            sb.append("LastServiceErrorId: " + this.getLastServiceErrorId() + ",");
        }
        if (this.getLayerIds() != null) {
            sb.append("LayerIds: " + this.getLayerIds() + ",");
        }
        if (this.getOs() != null) {
            sb.append("Os: " + this.getOs() + ",");
        }
        if (this.getPlatform() != null) {
            sb.append("Platform: " + this.getPlatform() + ",");
        }
        if (this.getPrivateDns() != null) {
            sb.append("PrivateDns: " + this.getPrivateDns() + ",");
        }
        if (this.getPrivateIp() != null) {
            sb.append("PrivateIp: " + this.getPrivateIp() + ",");
        }
        if (this.getPublicDns() != null) {
            sb.append("PublicDns: " + this.getPublicDns() + ",");
        }
        if (this.getPublicIp() != null) {
            sb.append("PublicIp: " + this.getPublicIp() + ",");
        }
        if (this.getRegisteredBy() != null) {
            sb.append("RegisteredBy: " + this.getRegisteredBy() + ",");
        }
        if (this.getReportedAgentVersion() != null) {
            sb.append("ReportedAgentVersion: " + this.getReportedAgentVersion() + ",");
        }
        if (this.getReportedOs() != null) {
            sb.append("ReportedOs: " + this.getReportedOs() + ",");
        }
        if (this.getRootDeviceType() != null) {
            sb.append("RootDeviceType: " + this.getRootDeviceType() + ",");
        }
        if (this.getRootDeviceVolumeId() != null) {
            sb.append("RootDeviceVolumeId: " + this.getRootDeviceVolumeId() + ",");
        }
        if (this.getSecurityGroupIds() != null) {
            sb.append("SecurityGroupIds: " + this.getSecurityGroupIds() + ",");
        }
        if (this.getSshHostDsaKeyFingerprint() != null) {
            sb.append("SshHostDsaKeyFingerprint: " + this.getSshHostDsaKeyFingerprint() + ",");
        }
        if (this.getSshHostRsaKeyFingerprint() != null) {
            sb.append("SshHostRsaKeyFingerprint: " + this.getSshHostRsaKeyFingerprint() + ",");
        }
        if (this.getSshKeyName() != null) {
            sb.append("SshKeyName: " + this.getSshKeyName() + ",");
        }
        if (this.getStackId() != null) {
            sb.append("StackId: " + this.getStackId() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getSubnetId() != null) {
            sb.append("SubnetId: " + this.getSubnetId() + ",");
        }
        if (this.getVirtualizationType() != null) {
            sb.append("VirtualizationType: " + this.getVirtualizationType());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAgentVersion() == null ? 0 : this.getAgentVersion().hashCode());
        hashCode = 31 * hashCode + (this.getAmiId() == null ? 0 : this.getAmiId().hashCode());
        hashCode = 31 * hashCode + (this.getArchitecture() == null ? 0 : this.getArchitecture().hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingType() == null ? 0 : this.getAutoScalingType().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getBlockDeviceMappings() == null ? 0 : this.getBlockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.isEbsOptimized() == null ? 0 : this.isEbsOptimized().hashCode());
        hashCode = 31 * hashCode + (this.getEc2InstanceId() == null ? 0 : this.getEc2InstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getElasticIp() == null ? 0 : this.getElasticIp().hashCode());
        hashCode = 31 * hashCode + (this.getHostname() == null ? 0 : this.getHostname().hashCode());
        hashCode = 31 * hashCode + (this.getInfrastructureClass() == null ? 0 : this.getInfrastructureClass().hashCode());
        hashCode = 31 * hashCode + (this.isInstallUpdatesOnBoot() == null ? 0 : this.isInstallUpdatesOnBoot().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceProfileArn() == null ? 0 : this.getInstanceProfileArn().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getLastServiceErrorId() == null ? 0 : this.getLastServiceErrorId().hashCode());
        hashCode = 31 * hashCode + (this.getLayerIds() == null ? 0 : this.getLayerIds().hashCode());
        hashCode = 31 * hashCode + (this.getOs() == null ? 0 : this.getOs().hashCode());
        hashCode = 31 * hashCode + (this.getPlatform() == null ? 0 : this.getPlatform().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateDns() == null ? 0 : this.getPrivateDns().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIp() == null ? 0 : this.getPrivateIp().hashCode());
        hashCode = 31 * hashCode + (this.getPublicDns() == null ? 0 : this.getPublicDns().hashCode());
        hashCode = 31 * hashCode + (this.getPublicIp() == null ? 0 : this.getPublicIp().hashCode());
        hashCode = 31 * hashCode + (this.getRegisteredBy() == null ? 0 : this.getRegisteredBy().hashCode());
        hashCode = 31 * hashCode + (this.getReportedAgentVersion() == null ? 0 : this.getReportedAgentVersion().hashCode());
        hashCode = 31 * hashCode + (this.getReportedOs() == null ? 0 : this.getReportedOs().hashCode());
        hashCode = 31 * hashCode + (this.getRootDeviceType() == null ? 0 : this.getRootDeviceType().hashCode());
        hashCode = 31 * hashCode + (this.getRootDeviceVolumeId() == null ? 0 : this.getRootDeviceVolumeId().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroupIds() == null ? 0 : this.getSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.getSshHostDsaKeyFingerprint() == null ? 0 : this.getSshHostDsaKeyFingerprint().hashCode());
        hashCode = 31 * hashCode + (this.getSshHostRsaKeyFingerprint() == null ? 0 : this.getSshHostRsaKeyFingerprint().hashCode());
        hashCode = 31 * hashCode + (this.getSshKeyName() == null ? 0 : this.getSshKeyName().hashCode());
        hashCode = 31 * hashCode + (this.getStackId() == null ? 0 : this.getStackId().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetId() == null ? 0 : this.getSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getVirtualizationType() == null ? 0 : this.getVirtualizationType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance)obj;
        if (other.getAgentVersion() == null ^ this.getAgentVersion() == null) {
            return false;
        }
        if (other.getAgentVersion() != null && !other.getAgentVersion().equals(this.getAgentVersion())) {
            return false;
        }
        if (other.getAmiId() == null ^ this.getAmiId() == null) {
            return false;
        }
        if (other.getAmiId() != null && !other.getAmiId().equals(this.getAmiId())) {
            return false;
        }
        if (other.getArchitecture() == null ^ this.getArchitecture() == null) {
            return false;
        }
        if (other.getArchitecture() != null && !other.getArchitecture().equals(this.getArchitecture())) {
            return false;
        }
        if (other.getAutoScalingType() == null ^ this.getAutoScalingType() == null) {
            return false;
        }
        if (other.getAutoScalingType() != null && !other.getAutoScalingType().equals(this.getAutoScalingType())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getBlockDeviceMappings() == null ^ this.getBlockDeviceMappings() == null) {
            return false;
        }
        if (other.getBlockDeviceMappings() != null && !other.getBlockDeviceMappings().equals(this.getBlockDeviceMappings())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.isEbsOptimized() == null ^ this.isEbsOptimized() == null) {
            return false;
        }
        if (other.isEbsOptimized() != null && !other.isEbsOptimized().equals(this.isEbsOptimized())) {
            return false;
        }
        if (other.getEc2InstanceId() == null ^ this.getEc2InstanceId() == null) {
            return false;
        }
        if (other.getEc2InstanceId() != null && !other.getEc2InstanceId().equals(this.getEc2InstanceId())) {
            return false;
        }
        if (other.getElasticIp() == null ^ this.getElasticIp() == null) {
            return false;
        }
        if (other.getElasticIp() != null && !other.getElasticIp().equals(this.getElasticIp())) {
            return false;
        }
        if (other.getHostname() == null ^ this.getHostname() == null) {
            return false;
        }
        if (other.getHostname() != null && !other.getHostname().equals(this.getHostname())) {
            return false;
        }
        if (other.getInfrastructureClass() == null ^ this.getInfrastructureClass() == null) {
            return false;
        }
        if (other.getInfrastructureClass() != null && !other.getInfrastructureClass().equals(this.getInfrastructureClass())) {
            return false;
        }
        if (other.isInstallUpdatesOnBoot() == null ^ this.isInstallUpdatesOnBoot() == null) {
            return false;
        }
        if (other.isInstallUpdatesOnBoot() != null && !other.isInstallUpdatesOnBoot().equals(this.isInstallUpdatesOnBoot())) {
            return false;
        }
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getInstanceProfileArn() == null ^ this.getInstanceProfileArn() == null) {
            return false;
        }
        if (other.getInstanceProfileArn() != null && !other.getInstanceProfileArn().equals(this.getInstanceProfileArn())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getLastServiceErrorId() == null ^ this.getLastServiceErrorId() == null) {
            return false;
        }
        if (other.getLastServiceErrorId() != null && !other.getLastServiceErrorId().equals(this.getLastServiceErrorId())) {
            return false;
        }
        if (other.getLayerIds() == null ^ this.getLayerIds() == null) {
            return false;
        }
        if (other.getLayerIds() != null && !other.getLayerIds().equals(this.getLayerIds())) {
            return false;
        }
        if (other.getOs() == null ^ this.getOs() == null) {
            return false;
        }
        if (other.getOs() != null && !other.getOs().equals(this.getOs())) {
            return false;
        }
        if (other.getPlatform() == null ^ this.getPlatform() == null) {
            return false;
        }
        if (other.getPlatform() != null && !other.getPlatform().equals(this.getPlatform())) {
            return false;
        }
        if (other.getPrivateDns() == null ^ this.getPrivateDns() == null) {
            return false;
        }
        if (other.getPrivateDns() != null && !other.getPrivateDns().equals(this.getPrivateDns())) {
            return false;
        }
        if (other.getPrivateIp() == null ^ this.getPrivateIp() == null) {
            return false;
        }
        if (other.getPrivateIp() != null && !other.getPrivateIp().equals(this.getPrivateIp())) {
            return false;
        }
        if (other.getPublicDns() == null ^ this.getPublicDns() == null) {
            return false;
        }
        if (other.getPublicDns() != null && !other.getPublicDns().equals(this.getPublicDns())) {
            return false;
        }
        if (other.getPublicIp() == null ^ this.getPublicIp() == null) {
            return false;
        }
        if (other.getPublicIp() != null && !other.getPublicIp().equals(this.getPublicIp())) {
            return false;
        }
        if (other.getRegisteredBy() == null ^ this.getRegisteredBy() == null) {
            return false;
        }
        if (other.getRegisteredBy() != null && !other.getRegisteredBy().equals(this.getRegisteredBy())) {
            return false;
        }
        if (other.getReportedAgentVersion() == null ^ this.getReportedAgentVersion() == null) {
            return false;
        }
        if (other.getReportedAgentVersion() != null && !other.getReportedAgentVersion().equals(this.getReportedAgentVersion())) {
            return false;
        }
        if (other.getReportedOs() == null ^ this.getReportedOs() == null) {
            return false;
        }
        if (other.getReportedOs() != null && !other.getReportedOs().equals(this.getReportedOs())) {
            return false;
        }
        if (other.getRootDeviceType() == null ^ this.getRootDeviceType() == null) {
            return false;
        }
        if (other.getRootDeviceType() != null && !other.getRootDeviceType().equals(this.getRootDeviceType())) {
            return false;
        }
        if (other.getRootDeviceVolumeId() == null ^ this.getRootDeviceVolumeId() == null) {
            return false;
        }
        if (other.getRootDeviceVolumeId() != null && !other.getRootDeviceVolumeId().equals(this.getRootDeviceVolumeId())) {
            return false;
        }
        if (other.getSecurityGroupIds() == null ^ this.getSecurityGroupIds() == null) {
            return false;
        }
        if (other.getSecurityGroupIds() != null && !other.getSecurityGroupIds().equals(this.getSecurityGroupIds())) {
            return false;
        }
        if (other.getSshHostDsaKeyFingerprint() == null ^ this.getSshHostDsaKeyFingerprint() == null) {
            return false;
        }
        if (other.getSshHostDsaKeyFingerprint() != null && !other.getSshHostDsaKeyFingerprint().equals(this.getSshHostDsaKeyFingerprint())) {
            return false;
        }
        if (other.getSshHostRsaKeyFingerprint() == null ^ this.getSshHostRsaKeyFingerprint() == null) {
            return false;
        }
        if (other.getSshHostRsaKeyFingerprint() != null && !other.getSshHostRsaKeyFingerprint().equals(this.getSshHostRsaKeyFingerprint())) {
            return false;
        }
        if (other.getSshKeyName() == null ^ this.getSshKeyName() == null) {
            return false;
        }
        if (other.getSshKeyName() != null && !other.getSshKeyName().equals(this.getSshKeyName())) {
            return false;
        }
        if (other.getStackId() == null ^ this.getStackId() == null) {
            return false;
        }
        if (other.getStackId() != null && !other.getStackId().equals(this.getStackId())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getSubnetId() == null ^ this.getSubnetId() == null) {
            return false;
        }
        if (other.getSubnetId() != null && !other.getSubnetId().equals(this.getSubnetId())) {
            return false;
        }
        if (other.getVirtualizationType() == null ^ this.getVirtualizationType() == null) {
            return false;
        }
        return other.getVirtualizationType() == null || other.getVirtualizationType().equals(this.getVirtualizationType());
    }

    public Instance clone() {
        try {
            return (Instance)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

